/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the information about one processor in a log transformer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Processor implements SdkPojo, Serializable, ToCopyableBuilder<Processor.Builder, Processor> {
    private static final SdkField<AddKeys> ADD_KEYS_FIELD = SdkField.<AddKeys> builder(MarshallingType.SDK_POJO)
            .memberName("addKeys").getter(getter(Processor::addKeys)).setter(setter(Builder::addKeys))
            .constructor(AddKeys::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addKeys").build()).build();

    private static final SdkField<CopyValue> COPY_VALUE_FIELD = SdkField.<CopyValue> builder(MarshallingType.SDK_POJO)
            .memberName("copyValue").getter(getter(Processor::copyValue)).setter(setter(Builder::copyValue))
            .constructor(CopyValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyValue").build()).build();

    private static final SdkField<CSV> CSV_FIELD = SdkField.<CSV> builder(MarshallingType.SDK_POJO).memberName("csv")
            .getter(getter(Processor::csv)).setter(setter(Builder::csv)).constructor(CSV::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csv").build()).build();

    private static final SdkField<DateTimeConverter> DATE_TIME_CONVERTER_FIELD = SdkField
            .<DateTimeConverter> builder(MarshallingType.SDK_POJO).memberName("dateTimeConverter")
            .getter(getter(Processor::dateTimeConverter)).setter(setter(Builder::dateTimeConverter))
            .constructor(DateTimeConverter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateTimeConverter").build()).build();

    private static final SdkField<DeleteKeys> DELETE_KEYS_FIELD = SdkField.<DeleteKeys> builder(MarshallingType.SDK_POJO)
            .memberName("deleteKeys").getter(getter(Processor::deleteKeys)).setter(setter(Builder::deleteKeys))
            .constructor(DeleteKeys::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteKeys").build()).build();

    private static final SdkField<Grok> GROK_FIELD = SdkField.<Grok> builder(MarshallingType.SDK_POJO).memberName("grok")
            .getter(getter(Processor::grok)).setter(setter(Builder::grok)).constructor(Grok::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grok").build()).build();

    private static final SdkField<ListToMap> LIST_TO_MAP_FIELD = SdkField.<ListToMap> builder(MarshallingType.SDK_POJO)
            .memberName("listToMap").getter(getter(Processor::listToMap)).setter(setter(Builder::listToMap))
            .constructor(ListToMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listToMap").build()).build();

    private static final SdkField<LowerCaseString> LOWER_CASE_STRING_FIELD = SdkField
            .<LowerCaseString> builder(MarshallingType.SDK_POJO).memberName("lowerCaseString")
            .getter(getter(Processor::lowerCaseString)).setter(setter(Builder::lowerCaseString))
            .constructor(LowerCaseString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lowerCaseString").build()).build();

    private static final SdkField<MoveKeys> MOVE_KEYS_FIELD = SdkField.<MoveKeys> builder(MarshallingType.SDK_POJO)
            .memberName("moveKeys").getter(getter(Processor::moveKeys)).setter(setter(Builder::moveKeys))
            .constructor(MoveKeys::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moveKeys").build()).build();

    private static final SdkField<ParseCloudfront> PARSE_CLOUDFRONT_FIELD = SdkField
            .<ParseCloudfront> builder(MarshallingType.SDK_POJO).memberName("parseCloudfront")
            .getter(getter(Processor::parseCloudfront)).setter(setter(Builder::parseCloudfront))
            .constructor(ParseCloudfront::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parseCloudfront").build()).build();

    private static final SdkField<ParseJSON> PARSE_JSON_FIELD = SdkField.<ParseJSON> builder(MarshallingType.SDK_POJO)
            .memberName("parseJSON").getter(getter(Processor::parseJSON)).setter(setter(Builder::parseJSON))
            .constructor(ParseJSON::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parseJSON").build()).build();

    private static final SdkField<ParseKeyValue> PARSE_KEY_VALUE_FIELD = SdkField
            .<ParseKeyValue> builder(MarshallingType.SDK_POJO).memberName("parseKeyValue")
            .getter(getter(Processor::parseKeyValue)).setter(setter(Builder::parseKeyValue)).constructor(ParseKeyValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parseKeyValue").build()).build();

    private static final SdkField<ParseRoute53> PARSE_ROUTE53_FIELD = SdkField.<ParseRoute53> builder(MarshallingType.SDK_POJO)
            .memberName("parseRoute53").getter(getter(Processor::parseRoute53)).setter(setter(Builder::parseRoute53))
            .constructor(ParseRoute53::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parseRoute53").build()).build();

    private static final SdkField<ParseToOCSF> PARSE_TO_OCSF_FIELD = SdkField.<ParseToOCSF> builder(MarshallingType.SDK_POJO)
            .memberName("parseToOCSF").getter(getter(Processor::parseToOCSF)).setter(setter(Builder::parseToOCSF))
            .constructor(ParseToOCSF::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parseToOCSF").build()).build();

    private static final SdkField<ParsePostgres> PARSE_POSTGRES_FIELD = SdkField
            .<ParsePostgres> builder(MarshallingType.SDK_POJO).memberName("parsePostgres")
            .getter(getter(Processor::parsePostgres)).setter(setter(Builder::parsePostgres)).constructor(ParsePostgres::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsePostgres").build()).build();

    private static final SdkField<ParseVPC> PARSE_VPC_FIELD = SdkField.<ParseVPC> builder(MarshallingType.SDK_POJO)
            .memberName("parseVPC").getter(getter(Processor::parseVPC)).setter(setter(Builder::parseVPC))
            .constructor(ParseVPC::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parseVPC").build()).build();

    private static final SdkField<ParseWAF> PARSE_WAF_FIELD = SdkField.<ParseWAF> builder(MarshallingType.SDK_POJO)
            .memberName("parseWAF").getter(getter(Processor::parseWAF)).setter(setter(Builder::parseWAF))
            .constructor(ParseWAF::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parseWAF").build()).build();

    private static final SdkField<RenameKeys> RENAME_KEYS_FIELD = SdkField.<RenameKeys> builder(MarshallingType.SDK_POJO)
            .memberName("renameKeys").getter(getter(Processor::renameKeys)).setter(setter(Builder::renameKeys))
            .constructor(RenameKeys::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renameKeys").build()).build();

    private static final SdkField<SplitString> SPLIT_STRING_FIELD = SdkField.<SplitString> builder(MarshallingType.SDK_POJO)
            .memberName("splitString").getter(getter(Processor::splitString)).setter(setter(Builder::splitString))
            .constructor(SplitString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("splitString").build()).build();

    private static final SdkField<SubstituteString> SUBSTITUTE_STRING_FIELD = SdkField
            .<SubstituteString> builder(MarshallingType.SDK_POJO).memberName("substituteString")
            .getter(getter(Processor::substituteString)).setter(setter(Builder::substituteString))
            .constructor(SubstituteString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("substituteString").build()).build();

    private static final SdkField<TrimString> TRIM_STRING_FIELD = SdkField.<TrimString> builder(MarshallingType.SDK_POJO)
            .memberName("trimString").getter(getter(Processor::trimString)).setter(setter(Builder::trimString))
            .constructor(TrimString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trimString").build()).build();

    private static final SdkField<TypeConverter> TYPE_CONVERTER_FIELD = SdkField
            .<TypeConverter> builder(MarshallingType.SDK_POJO).memberName("typeConverter")
            .getter(getter(Processor::typeConverter)).setter(setter(Builder::typeConverter)).constructor(TypeConverter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeConverter").build()).build();

    private static final SdkField<UpperCaseString> UPPER_CASE_STRING_FIELD = SdkField
            .<UpperCaseString> builder(MarshallingType.SDK_POJO).memberName("upperCaseString")
            .getter(getter(Processor::upperCaseString)).setter(setter(Builder::upperCaseString))
            .constructor(UpperCaseString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upperCaseString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_KEYS_FIELD,
            COPY_VALUE_FIELD, CSV_FIELD, DATE_TIME_CONVERTER_FIELD, DELETE_KEYS_FIELD, GROK_FIELD, LIST_TO_MAP_FIELD,
            LOWER_CASE_STRING_FIELD, MOVE_KEYS_FIELD, PARSE_CLOUDFRONT_FIELD, PARSE_JSON_FIELD, PARSE_KEY_VALUE_FIELD,
            PARSE_ROUTE53_FIELD, PARSE_TO_OCSF_FIELD, PARSE_POSTGRES_FIELD, PARSE_VPC_FIELD, PARSE_WAF_FIELD, RENAME_KEYS_FIELD,
            SPLIT_STRING_FIELD, SUBSTITUTE_STRING_FIELD, TRIM_STRING_FIELD, TYPE_CONVERTER_FIELD, UPPER_CASE_STRING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AddKeys addKeys;

    private final CopyValue copyValue;

    private final CSV csv;

    private final DateTimeConverter dateTimeConverter;

    private final DeleteKeys deleteKeys;

    private final Grok grok;

    private final ListToMap listToMap;

    private final LowerCaseString lowerCaseString;

    private final MoveKeys moveKeys;

    private final ParseCloudfront parseCloudfront;

    private final ParseJSON parseJSON;

    private final ParseKeyValue parseKeyValue;

    private final ParseRoute53 parseRoute53;

    private final ParseToOCSF parseToOCSF;

    private final ParsePostgres parsePostgres;

    private final ParseVPC parseVPC;

    private final ParseWAF parseWAF;

    private final RenameKeys renameKeys;

    private final SplitString splitString;

    private final SubstituteString substituteString;

    private final TrimString trimString;

    private final TypeConverter typeConverter;

    private final UpperCaseString upperCaseString;

    private Processor(BuilderImpl builder) {
        this.addKeys = builder.addKeys;
        this.copyValue = builder.copyValue;
        this.csv = builder.csv;
        this.dateTimeConverter = builder.dateTimeConverter;
        this.deleteKeys = builder.deleteKeys;
        this.grok = builder.grok;
        this.listToMap = builder.listToMap;
        this.lowerCaseString = builder.lowerCaseString;
        this.moveKeys = builder.moveKeys;
        this.parseCloudfront = builder.parseCloudfront;
        this.parseJSON = builder.parseJSON;
        this.parseKeyValue = builder.parseKeyValue;
        this.parseRoute53 = builder.parseRoute53;
        this.parseToOCSF = builder.parseToOCSF;
        this.parsePostgres = builder.parsePostgres;
        this.parseVPC = builder.parseVPC;
        this.parseWAF = builder.parseWAF;
        this.renameKeys = builder.renameKeys;
        this.splitString = builder.splitString;
        this.substituteString = builder.substituteString;
        this.trimString = builder.trimString;
        this.typeConverter = builder.typeConverter;
        this.upperCaseString = builder.upperCaseString;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys"
     * > addKeys</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys"
     *         > addKeys</a> processor in your transformer.
     */
    public final AddKeys addKeys() {
        return addKeys;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-copyValue"
     * > copyValue</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-copyValue"
     *         > copyValue</a> processor in your transformer.
     */
    public final CopyValue copyValue() {
        return copyValue;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV"
     * > CSV</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV"
     *         > CSV</a> processor in your transformer.
     */
    public final CSV csv() {
        return csv;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-datetimeConverter"
     * > datetimeConverter</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-datetimeConverter"
     *         > datetimeConverter</a> processor in your transformer.
     */
    public final DateTimeConverter dateTimeConverter() {
        return dateTimeConverter;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys"
     * > deleteKeys</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys"
     *         > deleteKeys</a> processor in your transformer.
     */
    public final DeleteKeys deleteKeys() {
        return deleteKeys;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-grok"
     * > grok</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-grok"
     *         > grok</a> processor in your transformer.
     */
    public final Grok grok() {
        return grok;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap"
     * > listToMap</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap"
     *         > listToMap</a> processor in your transformer.
     */
    public final ListToMap listToMap() {
        return listToMap;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-lowerCaseString"
     * > lowerCaseString</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-lowerCaseString"
     *         > lowerCaseString</a> processor in your transformer.
     */
    public final LowerCaseString lowerCaseString() {
        return lowerCaseString;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-moveKeys"
     * > moveKeys</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-moveKeys"
     *         > moveKeys</a> processor in your transformer.
     */
    public final MoveKeys moveKeys() {
        return moveKeys;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseCloudfront"
     * > parseCloudfront</a> processor in your transformer.
     * </p>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseCloudfront"
     *         > parseCloudfront</a> processor in your transformer.</p>
     *         <p>
     *         If you use this processor, it must be the first processor in your transformer.
     */
    public final ParseCloudfront parseCloudfront() {
        return parseCloudfront;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseJSON"
     * > parseJSON</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseJSON"
     *         > parseJSON</a> processor in your transformer.
     */
    public final ParseJSON parseJSON() {
        return parseJSON;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseKeyValue"
     * > parseKeyValue</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseKeyValue"
     *         > parseKeyValue</a> processor in your transformer.
     */
    public final ParseKeyValue parseKeyValue() {
        return parseKeyValue;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseRoute53"
     * > parseRoute53</a> processor in your transformer.
     * </p>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseRoute53"
     *         > parseRoute53</a> processor in your transformer.</p>
     *         <p>
     *         If you use this processor, it must be the first processor in your transformer.
     */
    public final ParseRoute53 parseRoute53() {
        return parseRoute53;
    }

    /**
     * <p>
     * Use this processor to convert logs into Open Cybersecurity Schema Framework (OCSF) format
     * </p>
     * 
     * @return Use this processor to convert logs into Open Cybersecurity Schema Framework (OCSF) format
     */
    public final ParseToOCSF parseToOCSF() {
        return parseToOCSF;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres"
     * > parsePostGres</a> processor in your transformer.
     * </p>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres"
     *         > parsePostGres</a> processor in your transformer.</p>
     *         <p>
     *         If you use this processor, it must be the first processor in your transformer.
     */
    public final ParsePostgres parsePostgres() {
        return parsePostgres;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseVPC"
     * > parseVPC</a> processor in your transformer.
     * </p>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseVPC"
     *         > parseVPC</a> processor in your transformer.</p>
     *         <p>
     *         If you use this processor, it must be the first processor in your transformer.
     */
    public final ParseVPC parseVPC() {
        return parseVPC;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF"
     * > parseWAF</a> processor in your transformer.
     * </p>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF"
     *         > parseWAF</a> processor in your transformer.</p>
     *         <p>
     *         If you use this processor, it must be the first processor in your transformer.
     */
    public final ParseWAF parseWAF() {
        return parseWAF;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys"
     * > renameKeys</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys"
     *         > renameKeys</a> processor in your transformer.
     */
    public final RenameKeys renameKeys() {
        return renameKeys;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-splitString"
     * > splitString</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-splitString"
     *         > splitString</a> processor in your transformer.
     */
    public final SplitString splitString() {
        return splitString;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-substituteString"
     * > substituteString</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-substituteString"
     *         > substituteString</a> processor in your transformer.
     */
    public final SubstituteString substituteString() {
        return substituteString;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-trimString"
     * > trimString</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-trimString"
     *         > trimString</a> processor in your transformer.
     */
    public final TrimString trimString() {
        return trimString;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-typeConverter"
     * > typeConverter</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-typeConverter"
     *         > typeConverter</a> processor in your transformer.
     */
    public final TypeConverter typeConverter() {
        return typeConverter;
    }

    /**
     * <p>
     * Use this parameter to include the <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-upperCaseString"
     * > upperCaseString</a> processor in your transformer.
     * </p>
     * 
     * @return Use this parameter to include the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-upperCaseString"
     *         > upperCaseString</a> processor in your transformer.
     */
    public final UpperCaseString upperCaseString() {
        return upperCaseString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addKeys());
        hashCode = 31 * hashCode + Objects.hashCode(copyValue());
        hashCode = 31 * hashCode + Objects.hashCode(csv());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeConverter());
        hashCode = 31 * hashCode + Objects.hashCode(deleteKeys());
        hashCode = 31 * hashCode + Objects.hashCode(grok());
        hashCode = 31 * hashCode + Objects.hashCode(listToMap());
        hashCode = 31 * hashCode + Objects.hashCode(lowerCaseString());
        hashCode = 31 * hashCode + Objects.hashCode(moveKeys());
        hashCode = 31 * hashCode + Objects.hashCode(parseCloudfront());
        hashCode = 31 * hashCode + Objects.hashCode(parseJSON());
        hashCode = 31 * hashCode + Objects.hashCode(parseKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(parseRoute53());
        hashCode = 31 * hashCode + Objects.hashCode(parseToOCSF());
        hashCode = 31 * hashCode + Objects.hashCode(parsePostgres());
        hashCode = 31 * hashCode + Objects.hashCode(parseVPC());
        hashCode = 31 * hashCode + Objects.hashCode(parseWAF());
        hashCode = 31 * hashCode + Objects.hashCode(renameKeys());
        hashCode = 31 * hashCode + Objects.hashCode(splitString());
        hashCode = 31 * hashCode + Objects.hashCode(substituteString());
        hashCode = 31 * hashCode + Objects.hashCode(trimString());
        hashCode = 31 * hashCode + Objects.hashCode(typeConverter());
        hashCode = 31 * hashCode + Objects.hashCode(upperCaseString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor) obj;
        return Objects.equals(addKeys(), other.addKeys()) && Objects.equals(copyValue(), other.copyValue())
                && Objects.equals(csv(), other.csv()) && Objects.equals(dateTimeConverter(), other.dateTimeConverter())
                && Objects.equals(deleteKeys(), other.deleteKeys()) && Objects.equals(grok(), other.grok())
                && Objects.equals(listToMap(), other.listToMap()) && Objects.equals(lowerCaseString(), other.lowerCaseString())
                && Objects.equals(moveKeys(), other.moveKeys()) && Objects.equals(parseCloudfront(), other.parseCloudfront())
                && Objects.equals(parseJSON(), other.parseJSON()) && Objects.equals(parseKeyValue(), other.parseKeyValue())
                && Objects.equals(parseRoute53(), other.parseRoute53()) && Objects.equals(parseToOCSF(), other.parseToOCSF())
                && Objects.equals(parsePostgres(), other.parsePostgres()) && Objects.equals(parseVPC(), other.parseVPC())
                && Objects.equals(parseWAF(), other.parseWAF()) && Objects.equals(renameKeys(), other.renameKeys())
                && Objects.equals(splitString(), other.splitString())
                && Objects.equals(substituteString(), other.substituteString())
                && Objects.equals(trimString(), other.trimString()) && Objects.equals(typeConverter(), other.typeConverter())
                && Objects.equals(upperCaseString(), other.upperCaseString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Processor").add("AddKeys", addKeys()).add("CopyValue", copyValue()).add("Csv", csv())
                .add("DateTimeConverter", dateTimeConverter()).add("DeleteKeys", deleteKeys()).add("Grok", grok())
                .add("ListToMap", listToMap()).add("LowerCaseString", lowerCaseString()).add("MoveKeys", moveKeys())
                .add("ParseCloudfront", parseCloudfront()).add("ParseJSON", parseJSON()).add("ParseKeyValue", parseKeyValue())
                .add("ParseRoute53", parseRoute53()).add("ParseToOCSF", parseToOCSF()).add("ParsePostgres", parsePostgres())
                .add("ParseVPC", parseVPC()).add("ParseWAF", parseWAF()).add("RenameKeys", renameKeys())
                .add("SplitString", splitString()).add("SubstituteString", substituteString()).add("TrimString", trimString())
                .add("TypeConverter", typeConverter()).add("UpperCaseString", upperCaseString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addKeys":
            return Optional.ofNullable(clazz.cast(addKeys()));
        case "copyValue":
            return Optional.ofNullable(clazz.cast(copyValue()));
        case "csv":
            return Optional.ofNullable(clazz.cast(csv()));
        case "dateTimeConverter":
            return Optional.ofNullable(clazz.cast(dateTimeConverter()));
        case "deleteKeys":
            return Optional.ofNullable(clazz.cast(deleteKeys()));
        case "grok":
            return Optional.ofNullable(clazz.cast(grok()));
        case "listToMap":
            return Optional.ofNullable(clazz.cast(listToMap()));
        case "lowerCaseString":
            return Optional.ofNullable(clazz.cast(lowerCaseString()));
        case "moveKeys":
            return Optional.ofNullable(clazz.cast(moveKeys()));
        case "parseCloudfront":
            return Optional.ofNullable(clazz.cast(parseCloudfront()));
        case "parseJSON":
            return Optional.ofNullable(clazz.cast(parseJSON()));
        case "parseKeyValue":
            return Optional.ofNullable(clazz.cast(parseKeyValue()));
        case "parseRoute53":
            return Optional.ofNullable(clazz.cast(parseRoute53()));
        case "parseToOCSF":
            return Optional.ofNullable(clazz.cast(parseToOCSF()));
        case "parsePostgres":
            return Optional.ofNullable(clazz.cast(parsePostgres()));
        case "parseVPC":
            return Optional.ofNullable(clazz.cast(parseVPC()));
        case "parseWAF":
            return Optional.ofNullable(clazz.cast(parseWAF()));
        case "renameKeys":
            return Optional.ofNullable(clazz.cast(renameKeys()));
        case "splitString":
            return Optional.ofNullable(clazz.cast(splitString()));
        case "substituteString":
            return Optional.ofNullable(clazz.cast(substituteString()));
        case "trimString":
            return Optional.ofNullable(clazz.cast(trimString()));
        case "typeConverter":
            return Optional.ofNullable(clazz.cast(typeConverter()));
        case "upperCaseString":
            return Optional.ofNullable(clazz.cast(upperCaseString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addKeys", ADD_KEYS_FIELD);
        map.put("copyValue", COPY_VALUE_FIELD);
        map.put("csv", CSV_FIELD);
        map.put("dateTimeConverter", DATE_TIME_CONVERTER_FIELD);
        map.put("deleteKeys", DELETE_KEYS_FIELD);
        map.put("grok", GROK_FIELD);
        map.put("listToMap", LIST_TO_MAP_FIELD);
        map.put("lowerCaseString", LOWER_CASE_STRING_FIELD);
        map.put("moveKeys", MOVE_KEYS_FIELD);
        map.put("parseCloudfront", PARSE_CLOUDFRONT_FIELD);
        map.put("parseJSON", PARSE_JSON_FIELD);
        map.put("parseKeyValue", PARSE_KEY_VALUE_FIELD);
        map.put("parseRoute53", PARSE_ROUTE53_FIELD);
        map.put("parseToOCSF", PARSE_TO_OCSF_FIELD);
        map.put("parsePostgres", PARSE_POSTGRES_FIELD);
        map.put("parseVPC", PARSE_VPC_FIELD);
        map.put("parseWAF", PARSE_WAF_FIELD);
        map.put("renameKeys", RENAME_KEYS_FIELD);
        map.put("splitString", SPLIT_STRING_FIELD);
        map.put("substituteString", SUBSTITUTE_STRING_FIELD);
        map.put("trimString", TRIM_STRING_FIELD);
        map.put("typeConverter", TYPE_CONVERTER_FIELD);
        map.put("upperCaseString", UPPER_CASE_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Processor, T> g) {
        return obj -> g.apply((Processor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Processor> {
        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys"
         * > addKeys</a> processor in your transformer.
         * </p>
         * 
         * @param addKeys
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys"
         *        > addKeys</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addKeys(AddKeys addKeys);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys"
         * > addKeys</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddKeys.Builder} avoiding the need to
         * create one manually via {@link AddKeys#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddKeys.Builder#build()} is called immediately and its result is
         * passed to {@link #addKeys(AddKeys)}.
         * 
         * @param addKeys
         *        a consumer that will call methods on {@link AddKeys.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addKeys(AddKeys)
         */
        default Builder addKeys(Consumer<AddKeys.Builder> addKeys) {
            return addKeys(AddKeys.builder().applyMutation(addKeys).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-copyValue"
         * > copyValue</a> processor in your transformer.
         * </p>
         * 
         * @param copyValue
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-copyValue"
         *        > copyValue</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyValue(CopyValue copyValue);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-copyValue"
         * > copyValue</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link CopyValue.Builder} avoiding the need to
         * create one manually via {@link CopyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CopyValue.Builder#build()} is called immediately and its result
         * is passed to {@link #copyValue(CopyValue)}.
         * 
         * @param copyValue
         *        a consumer that will call methods on {@link CopyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyValue(CopyValue)
         */
        default Builder copyValue(Consumer<CopyValue.Builder> copyValue) {
            return copyValue(CopyValue.builder().applyMutation(copyValue).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV"
         * > CSV</a> processor in your transformer.
         * </p>
         * 
         * @param csv
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV"
         *        > CSV</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csv(CSV csv);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV"
         * > CSV</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link CSV.Builder} avoiding the need to create
         * one manually via {@link CSV#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CSV.Builder#build()} is called immediately and its result is
         * passed to {@link #csv(CSV)}.
         * 
         * @param csv
         *        a consumer that will call methods on {@link CSV.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csv(CSV)
         */
        default Builder csv(Consumer<CSV.Builder> csv) {
            return csv(CSV.builder().applyMutation(csv).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-datetimeConverter"
         * > datetimeConverter</a> processor in your transformer.
         * </p>
         * 
         * @param dateTimeConverter
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-datetimeConverter"
         *        > datetimeConverter</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeConverter(DateTimeConverter dateTimeConverter);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-datetimeConverter"
         * > datetimeConverter</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeConverter.Builder} avoiding the
         * need to create one manually via {@link DateTimeConverter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeConverter.Builder#build()} is called immediately and its
         * result is passed to {@link #dateTimeConverter(DateTimeConverter)}.
         * 
         * @param dateTimeConverter
         *        a consumer that will call methods on {@link DateTimeConverter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeConverter(DateTimeConverter)
         */
        default Builder dateTimeConverter(Consumer<DateTimeConverter.Builder> dateTimeConverter) {
            return dateTimeConverter(DateTimeConverter.builder().applyMutation(dateTimeConverter).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys"
         * > deleteKeys</a> processor in your transformer.
         * </p>
         * 
         * @param deleteKeys
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys"
         *        > deleteKeys</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteKeys(DeleteKeys deleteKeys);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys"
         * > deleteKeys</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteKeys.Builder} avoiding the need to
         * create one manually via {@link DeleteKeys#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteKeys.Builder#build()} is called immediately and its result
         * is passed to {@link #deleteKeys(DeleteKeys)}.
         * 
         * @param deleteKeys
         *        a consumer that will call methods on {@link DeleteKeys.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteKeys(DeleteKeys)
         */
        default Builder deleteKeys(Consumer<DeleteKeys.Builder> deleteKeys) {
            return deleteKeys(DeleteKeys.builder().applyMutation(deleteKeys).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-grok"
         * > grok</a> processor in your transformer.
         * </p>
         * 
         * @param grok
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-grok"
         *        > grok</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grok(Grok grok);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-grok"
         * > grok</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link Grok.Builder} avoiding the need to create
         * one manually via {@link Grok#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Grok.Builder#build()} is called immediately and its result is
         * passed to {@link #grok(Grok)}.
         * 
         * @param grok
         *        a consumer that will call methods on {@link Grok.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grok(Grok)
         */
        default Builder grok(Consumer<Grok.Builder> grok) {
            return grok(Grok.builder().applyMutation(grok).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap"
         * > listToMap</a> processor in your transformer.
         * </p>
         * 
         * @param listToMap
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap"
         *        > listToMap</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listToMap(ListToMap listToMap);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap"
         * > listToMap</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListToMap.Builder} avoiding the need to
         * create one manually via {@link ListToMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListToMap.Builder#build()} is called immediately and its result
         * is passed to {@link #listToMap(ListToMap)}.
         * 
         * @param listToMap
         *        a consumer that will call methods on {@link ListToMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listToMap(ListToMap)
         */
        default Builder listToMap(Consumer<ListToMap.Builder> listToMap) {
            return listToMap(ListToMap.builder().applyMutation(listToMap).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-lowerCaseString"
         * > lowerCaseString</a> processor in your transformer.
         * </p>
         * 
         * @param lowerCaseString
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-lowerCaseString"
         *        > lowerCaseString</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerCaseString(LowerCaseString lowerCaseString);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-lowerCaseString"
         * > lowerCaseString</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link LowerCaseString.Builder} avoiding the
         * need to create one manually via {@link LowerCaseString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LowerCaseString.Builder#build()} is called immediately and its
         * result is passed to {@link #lowerCaseString(LowerCaseString)}.
         * 
         * @param lowerCaseString
         *        a consumer that will call methods on {@link LowerCaseString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lowerCaseString(LowerCaseString)
         */
        default Builder lowerCaseString(Consumer<LowerCaseString.Builder> lowerCaseString) {
            return lowerCaseString(LowerCaseString.builder().applyMutation(lowerCaseString).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-moveKeys"
         * > moveKeys</a> processor in your transformer.
         * </p>
         * 
         * @param moveKeys
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-moveKeys"
         *        > moveKeys</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moveKeys(MoveKeys moveKeys);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-moveKeys"
         * > moveKeys</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link MoveKeys.Builder} avoiding the need to
         * create one manually via {@link MoveKeys#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MoveKeys.Builder#build()} is called immediately and its result is
         * passed to {@link #moveKeys(MoveKeys)}.
         * 
         * @param moveKeys
         *        a consumer that will call methods on {@link MoveKeys.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moveKeys(MoveKeys)
         */
        default Builder moveKeys(Consumer<MoveKeys.Builder> moveKeys) {
            return moveKeys(MoveKeys.builder().applyMutation(moveKeys).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseCloudfront"
         * > parseCloudfront</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * 
         * @param parseCloudfront
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseCloudfront"
         *        > parseCloudfront</a> processor in your transformer.</p>
         *        <p>
         *        If you use this processor, it must be the first processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parseCloudfront(ParseCloudfront parseCloudfront);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseCloudfront"
         * > parseCloudfront</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParseCloudfront.Builder} avoiding the
         * need to create one manually via {@link ParseCloudfront#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParseCloudfront.Builder#build()} is called immediately and its
         * result is passed to {@link #parseCloudfront(ParseCloudfront)}.
         * 
         * @param parseCloudfront
         *        a consumer that will call methods on {@link ParseCloudfront.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parseCloudfront(ParseCloudfront)
         */
        default Builder parseCloudfront(Consumer<ParseCloudfront.Builder> parseCloudfront) {
            return parseCloudfront(ParseCloudfront.builder().applyMutation(parseCloudfront).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseJSON"
         * > parseJSON</a> processor in your transformer.
         * </p>
         * 
         * @param parseJSON
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseJSON"
         *        > parseJSON</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parseJSON(ParseJSON parseJSON);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseJSON"
         * > parseJSON</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParseJSON.Builder} avoiding the need to
         * create one manually via {@link ParseJSON#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParseJSON.Builder#build()} is called immediately and its result
         * is passed to {@link #parseJSON(ParseJSON)}.
         * 
         * @param parseJSON
         *        a consumer that will call methods on {@link ParseJSON.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parseJSON(ParseJSON)
         */
        default Builder parseJSON(Consumer<ParseJSON.Builder> parseJSON) {
            return parseJSON(ParseJSON.builder().applyMutation(parseJSON).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseKeyValue"
         * > parseKeyValue</a> processor in your transformer.
         * </p>
         * 
         * @param parseKeyValue
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseKeyValue"
         *        > parseKeyValue</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parseKeyValue(ParseKeyValue parseKeyValue);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseKeyValue"
         * > parseKeyValue</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParseKeyValue.Builder} avoiding the need
         * to create one manually via {@link ParseKeyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParseKeyValue.Builder#build()} is called immediately and its
         * result is passed to {@link #parseKeyValue(ParseKeyValue)}.
         * 
         * @param parseKeyValue
         *        a consumer that will call methods on {@link ParseKeyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parseKeyValue(ParseKeyValue)
         */
        default Builder parseKeyValue(Consumer<ParseKeyValue.Builder> parseKeyValue) {
            return parseKeyValue(ParseKeyValue.builder().applyMutation(parseKeyValue).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseRoute53"
         * > parseRoute53</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * 
         * @param parseRoute53
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseRoute53"
         *        > parseRoute53</a> processor in your transformer.</p>
         *        <p>
         *        If you use this processor, it must be the first processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parseRoute53(ParseRoute53 parseRoute53);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseRoute53"
         * > parseRoute53</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParseRoute53.Builder} avoiding the need
         * to create one manually via {@link ParseRoute53#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParseRoute53.Builder#build()} is called immediately and its
         * result is passed to {@link #parseRoute53(ParseRoute53)}.
         * 
         * @param parseRoute53
         *        a consumer that will call methods on {@link ParseRoute53.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parseRoute53(ParseRoute53)
         */
        default Builder parseRoute53(Consumer<ParseRoute53.Builder> parseRoute53) {
            return parseRoute53(ParseRoute53.builder().applyMutation(parseRoute53).build());
        }

        /**
         * <p>
         * Use this processor to convert logs into Open Cybersecurity Schema Framework (OCSF) format
         * </p>
         * 
         * @param parseToOCSF
         *        Use this processor to convert logs into Open Cybersecurity Schema Framework (OCSF) format
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parseToOCSF(ParseToOCSF parseToOCSF);

        /**
         * <p>
         * Use this processor to convert logs into Open Cybersecurity Schema Framework (OCSF) format
         * </p>
         * This is a convenience method that creates an instance of the {@link ParseToOCSF.Builder} avoiding the need to
         * create one manually via {@link ParseToOCSF#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParseToOCSF.Builder#build()} is called immediately and its result
         * is passed to {@link #parseToOCSF(ParseToOCSF)}.
         * 
         * @param parseToOCSF
         *        a consumer that will call methods on {@link ParseToOCSF.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parseToOCSF(ParseToOCSF)
         */
        default Builder parseToOCSF(Consumer<ParseToOCSF.Builder> parseToOCSF) {
            return parseToOCSF(ParseToOCSF.builder().applyMutation(parseToOCSF).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres"
         * > parsePostGres</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * 
         * @param parsePostgres
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres"
         *        > parsePostGres</a> processor in your transformer.</p>
         *        <p>
         *        If you use this processor, it must be the first processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsePostgres(ParsePostgres parsePostgres);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres"
         * > parsePostGres</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParsePostgres.Builder} avoiding the need
         * to create one manually via {@link ParsePostgres#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParsePostgres.Builder#build()} is called immediately and its
         * result is passed to {@link #parsePostgres(ParsePostgres)}.
         * 
         * @param parsePostgres
         *        a consumer that will call methods on {@link ParsePostgres.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parsePostgres(ParsePostgres)
         */
        default Builder parsePostgres(Consumer<ParsePostgres.Builder> parsePostgres) {
            return parsePostgres(ParsePostgres.builder().applyMutation(parsePostgres).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseVPC"
         * > parseVPC</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * 
         * @param parseVPC
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseVPC"
         *        > parseVPC</a> processor in your transformer.</p>
         *        <p>
         *        If you use this processor, it must be the first processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parseVPC(ParseVPC parseVPC);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseVPC"
         * > parseVPC</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParseVPC.Builder} avoiding the need to
         * create one manually via {@link ParseVPC#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParseVPC.Builder#build()} is called immediately and its result is
         * passed to {@link #parseVPC(ParseVPC)}.
         * 
         * @param parseVPC
         *        a consumer that will call methods on {@link ParseVPC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parseVPC(ParseVPC)
         */
        default Builder parseVPC(Consumer<ParseVPC.Builder> parseVPC) {
            return parseVPC(ParseVPC.builder().applyMutation(parseVPC).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF"
         * > parseWAF</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * 
         * @param parseWAF
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF"
         *        > parseWAF</a> processor in your transformer.</p>
         *        <p>
         *        If you use this processor, it must be the first processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parseWAF(ParseWAF parseWAF);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF"
         * > parseWAF</a> processor in your transformer.
         * </p>
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParseWAF.Builder} avoiding the need to
         * create one manually via {@link ParseWAF#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParseWAF.Builder#build()} is called immediately and its result is
         * passed to {@link #parseWAF(ParseWAF)}.
         * 
         * @param parseWAF
         *        a consumer that will call methods on {@link ParseWAF.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parseWAF(ParseWAF)
         */
        default Builder parseWAF(Consumer<ParseWAF.Builder> parseWAF) {
            return parseWAF(ParseWAF.builder().applyMutation(parseWAF).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys"
         * > renameKeys</a> processor in your transformer.
         * </p>
         * 
         * @param renameKeys
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys"
         *        > renameKeys</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renameKeys(RenameKeys renameKeys);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys"
         * > renameKeys</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenameKeys.Builder} avoiding the need to
         * create one manually via {@link RenameKeys#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenameKeys.Builder#build()} is called immediately and its result
         * is passed to {@link #renameKeys(RenameKeys)}.
         * 
         * @param renameKeys
         *        a consumer that will call methods on {@link RenameKeys.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renameKeys(RenameKeys)
         */
        default Builder renameKeys(Consumer<RenameKeys.Builder> renameKeys) {
            return renameKeys(RenameKeys.builder().applyMutation(renameKeys).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-splitString"
         * > splitString</a> processor in your transformer.
         * </p>
         * 
         * @param splitString
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-splitString"
         *        > splitString</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitString(SplitString splitString);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-splitString"
         * > splitString</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link SplitString.Builder} avoiding the need to
         * create one manually via {@link SplitString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SplitString.Builder#build()} is called immediately and its result
         * is passed to {@link #splitString(SplitString)}.
         * 
         * @param splitString
         *        a consumer that will call methods on {@link SplitString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splitString(SplitString)
         */
        default Builder splitString(Consumer<SplitString.Builder> splitString) {
            return splitString(SplitString.builder().applyMutation(splitString).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-substituteString"
         * > substituteString</a> processor in your transformer.
         * </p>
         * 
         * @param substituteString
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-substituteString"
         *        > substituteString</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substituteString(SubstituteString substituteString);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-substituteString"
         * > substituteString</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubstituteString.Builder} avoiding the
         * need to create one manually via {@link SubstituteString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubstituteString.Builder#build()} is called immediately and its
         * result is passed to {@link #substituteString(SubstituteString)}.
         * 
         * @param substituteString
         *        a consumer that will call methods on {@link SubstituteString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #substituteString(SubstituteString)
         */
        default Builder substituteString(Consumer<SubstituteString.Builder> substituteString) {
            return substituteString(SubstituteString.builder().applyMutation(substituteString).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-trimString"
         * > trimString</a> processor in your transformer.
         * </p>
         * 
         * @param trimString
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-trimString"
         *        > trimString</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trimString(TrimString trimString);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-trimString"
         * > trimString</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrimString.Builder} avoiding the need to
         * create one manually via {@link TrimString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrimString.Builder#build()} is called immediately and its result
         * is passed to {@link #trimString(TrimString)}.
         * 
         * @param trimString
         *        a consumer that will call methods on {@link TrimString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trimString(TrimString)
         */
        default Builder trimString(Consumer<TrimString.Builder> trimString) {
            return trimString(TrimString.builder().applyMutation(trimString).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-typeConverter"
         * > typeConverter</a> processor in your transformer.
         * </p>
         * 
         * @param typeConverter
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-typeConverter"
         *        > typeConverter</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConverter(TypeConverter typeConverter);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-typeConverter"
         * > typeConverter</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TypeConverter.Builder} avoiding the need
         * to create one manually via {@link TypeConverter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TypeConverter.Builder#build()} is called immediately and its
         * result is passed to {@link #typeConverter(TypeConverter)}.
         * 
         * @param typeConverter
         *        a consumer that will call methods on {@link TypeConverter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeConverter(TypeConverter)
         */
        default Builder typeConverter(Consumer<TypeConverter.Builder> typeConverter) {
            return typeConverter(TypeConverter.builder().applyMutation(typeConverter).build());
        }

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-upperCaseString"
         * > upperCaseString</a> processor in your transformer.
         * </p>
         * 
         * @param upperCaseString
         *        Use this parameter to include the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-upperCaseString"
         *        > upperCaseString</a> processor in your transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperCaseString(UpperCaseString upperCaseString);

        /**
         * <p>
         * Use this parameter to include the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-upperCaseString"
         * > upperCaseString</a> processor in your transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpperCaseString.Builder} avoiding the
         * need to create one manually via {@link UpperCaseString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpperCaseString.Builder#build()} is called immediately and its
         * result is passed to {@link #upperCaseString(UpperCaseString)}.
         * 
         * @param upperCaseString
         *        a consumer that will call methods on {@link UpperCaseString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upperCaseString(UpperCaseString)
         */
        default Builder upperCaseString(Consumer<UpperCaseString.Builder> upperCaseString) {
            return upperCaseString(UpperCaseString.builder().applyMutation(upperCaseString).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AddKeys addKeys;

        private CopyValue copyValue;

        private CSV csv;

        private DateTimeConverter dateTimeConverter;

        private DeleteKeys deleteKeys;

        private Grok grok;

        private ListToMap listToMap;

        private LowerCaseString lowerCaseString;

        private MoveKeys moveKeys;

        private ParseCloudfront parseCloudfront;

        private ParseJSON parseJSON;

        private ParseKeyValue parseKeyValue;

        private ParseRoute53 parseRoute53;

        private ParseToOCSF parseToOCSF;

        private ParsePostgres parsePostgres;

        private ParseVPC parseVPC;

        private ParseWAF parseWAF;

        private RenameKeys renameKeys;

        private SplitString splitString;

        private SubstituteString substituteString;

        private TrimString trimString;

        private TypeConverter typeConverter;

        private UpperCaseString upperCaseString;

        private BuilderImpl() {
        }

        private BuilderImpl(Processor model) {
            addKeys(model.addKeys);
            copyValue(model.copyValue);
            csv(model.csv);
            dateTimeConverter(model.dateTimeConverter);
            deleteKeys(model.deleteKeys);
            grok(model.grok);
            listToMap(model.listToMap);
            lowerCaseString(model.lowerCaseString);
            moveKeys(model.moveKeys);
            parseCloudfront(model.parseCloudfront);
            parseJSON(model.parseJSON);
            parseKeyValue(model.parseKeyValue);
            parseRoute53(model.parseRoute53);
            parseToOCSF(model.parseToOCSF);
            parsePostgres(model.parsePostgres);
            parseVPC(model.parseVPC);
            parseWAF(model.parseWAF);
            renameKeys(model.renameKeys);
            splitString(model.splitString);
            substituteString(model.substituteString);
            trimString(model.trimString);
            typeConverter(model.typeConverter);
            upperCaseString(model.upperCaseString);
        }

        public final AddKeys.Builder getAddKeys() {
            return addKeys != null ? addKeys.toBuilder() : null;
        }

        public final void setAddKeys(AddKeys.BuilderImpl addKeys) {
            this.addKeys = addKeys != null ? addKeys.build() : null;
        }

        @Override
        public final Builder addKeys(AddKeys addKeys) {
            this.addKeys = addKeys;
            return this;
        }

        public final CopyValue.Builder getCopyValue() {
            return copyValue != null ? copyValue.toBuilder() : null;
        }

        public final void setCopyValue(CopyValue.BuilderImpl copyValue) {
            this.copyValue = copyValue != null ? copyValue.build() : null;
        }

        @Override
        public final Builder copyValue(CopyValue copyValue) {
            this.copyValue = copyValue;
            return this;
        }

        public final CSV.Builder getCsv() {
            return csv != null ? csv.toBuilder() : null;
        }

        public final void setCsv(CSV.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        @Override
        public final Builder csv(CSV csv) {
            this.csv = csv;
            return this;
        }

        public final DateTimeConverter.Builder getDateTimeConverter() {
            return dateTimeConverter != null ? dateTimeConverter.toBuilder() : null;
        }

        public final void setDateTimeConverter(DateTimeConverter.BuilderImpl dateTimeConverter) {
            this.dateTimeConverter = dateTimeConverter != null ? dateTimeConverter.build() : null;
        }

        @Override
        public final Builder dateTimeConverter(DateTimeConverter dateTimeConverter) {
            this.dateTimeConverter = dateTimeConverter;
            return this;
        }

        public final DeleteKeys.Builder getDeleteKeys() {
            return deleteKeys != null ? deleteKeys.toBuilder() : null;
        }

        public final void setDeleteKeys(DeleteKeys.BuilderImpl deleteKeys) {
            this.deleteKeys = deleteKeys != null ? deleteKeys.build() : null;
        }

        @Override
        public final Builder deleteKeys(DeleteKeys deleteKeys) {
            this.deleteKeys = deleteKeys;
            return this;
        }

        public final Grok.Builder getGrok() {
            return grok != null ? grok.toBuilder() : null;
        }

        public final void setGrok(Grok.BuilderImpl grok) {
            this.grok = grok != null ? grok.build() : null;
        }

        @Override
        public final Builder grok(Grok grok) {
            this.grok = grok;
            return this;
        }

        public final ListToMap.Builder getListToMap() {
            return listToMap != null ? listToMap.toBuilder() : null;
        }

        public final void setListToMap(ListToMap.BuilderImpl listToMap) {
            this.listToMap = listToMap != null ? listToMap.build() : null;
        }

        @Override
        public final Builder listToMap(ListToMap listToMap) {
            this.listToMap = listToMap;
            return this;
        }

        public final LowerCaseString.Builder getLowerCaseString() {
            return lowerCaseString != null ? lowerCaseString.toBuilder() : null;
        }

        public final void setLowerCaseString(LowerCaseString.BuilderImpl lowerCaseString) {
            this.lowerCaseString = lowerCaseString != null ? lowerCaseString.build() : null;
        }

        @Override
        public final Builder lowerCaseString(LowerCaseString lowerCaseString) {
            this.lowerCaseString = lowerCaseString;
            return this;
        }

        public final MoveKeys.Builder getMoveKeys() {
            return moveKeys != null ? moveKeys.toBuilder() : null;
        }

        public final void setMoveKeys(MoveKeys.BuilderImpl moveKeys) {
            this.moveKeys = moveKeys != null ? moveKeys.build() : null;
        }

        @Override
        public final Builder moveKeys(MoveKeys moveKeys) {
            this.moveKeys = moveKeys;
            return this;
        }

        public final ParseCloudfront.Builder getParseCloudfront() {
            return parseCloudfront != null ? parseCloudfront.toBuilder() : null;
        }

        public final void setParseCloudfront(ParseCloudfront.BuilderImpl parseCloudfront) {
            this.parseCloudfront = parseCloudfront != null ? parseCloudfront.build() : null;
        }

        @Override
        public final Builder parseCloudfront(ParseCloudfront parseCloudfront) {
            this.parseCloudfront = parseCloudfront;
            return this;
        }

        public final ParseJSON.Builder getParseJSON() {
            return parseJSON != null ? parseJSON.toBuilder() : null;
        }

        public final void setParseJSON(ParseJSON.BuilderImpl parseJSON) {
            this.parseJSON = parseJSON != null ? parseJSON.build() : null;
        }

        @Override
        public final Builder parseJSON(ParseJSON parseJSON) {
            this.parseJSON = parseJSON;
            return this;
        }

        public final ParseKeyValue.Builder getParseKeyValue() {
            return parseKeyValue != null ? parseKeyValue.toBuilder() : null;
        }

        public final void setParseKeyValue(ParseKeyValue.BuilderImpl parseKeyValue) {
            this.parseKeyValue = parseKeyValue != null ? parseKeyValue.build() : null;
        }

        @Override
        public final Builder parseKeyValue(ParseKeyValue parseKeyValue) {
            this.parseKeyValue = parseKeyValue;
            return this;
        }

        public final ParseRoute53.Builder getParseRoute53() {
            return parseRoute53 != null ? parseRoute53.toBuilder() : null;
        }

        public final void setParseRoute53(ParseRoute53.BuilderImpl parseRoute53) {
            this.parseRoute53 = parseRoute53 != null ? parseRoute53.build() : null;
        }

        @Override
        public final Builder parseRoute53(ParseRoute53 parseRoute53) {
            this.parseRoute53 = parseRoute53;
            return this;
        }

        public final ParseToOCSF.Builder getParseToOCSF() {
            return parseToOCSF != null ? parseToOCSF.toBuilder() : null;
        }

        public final void setParseToOCSF(ParseToOCSF.BuilderImpl parseToOCSF) {
            this.parseToOCSF = parseToOCSF != null ? parseToOCSF.build() : null;
        }

        @Override
        public final Builder parseToOCSF(ParseToOCSF parseToOCSF) {
            this.parseToOCSF = parseToOCSF;
            return this;
        }

        public final ParsePostgres.Builder getParsePostgres() {
            return parsePostgres != null ? parsePostgres.toBuilder() : null;
        }

        public final void setParsePostgres(ParsePostgres.BuilderImpl parsePostgres) {
            this.parsePostgres = parsePostgres != null ? parsePostgres.build() : null;
        }

        @Override
        public final Builder parsePostgres(ParsePostgres parsePostgres) {
            this.parsePostgres = parsePostgres;
            return this;
        }

        public final ParseVPC.Builder getParseVPC() {
            return parseVPC != null ? parseVPC.toBuilder() : null;
        }

        public final void setParseVPC(ParseVPC.BuilderImpl parseVPC) {
            this.parseVPC = parseVPC != null ? parseVPC.build() : null;
        }

        @Override
        public final Builder parseVPC(ParseVPC parseVPC) {
            this.parseVPC = parseVPC;
            return this;
        }

        public final ParseWAF.Builder getParseWAF() {
            return parseWAF != null ? parseWAF.toBuilder() : null;
        }

        public final void setParseWAF(ParseWAF.BuilderImpl parseWAF) {
            this.parseWAF = parseWAF != null ? parseWAF.build() : null;
        }

        @Override
        public final Builder parseWAF(ParseWAF parseWAF) {
            this.parseWAF = parseWAF;
            return this;
        }

        public final RenameKeys.Builder getRenameKeys() {
            return renameKeys != null ? renameKeys.toBuilder() : null;
        }

        public final void setRenameKeys(RenameKeys.BuilderImpl renameKeys) {
            this.renameKeys = renameKeys != null ? renameKeys.build() : null;
        }

        @Override
        public final Builder renameKeys(RenameKeys renameKeys) {
            this.renameKeys = renameKeys;
            return this;
        }

        public final SplitString.Builder getSplitString() {
            return splitString != null ? splitString.toBuilder() : null;
        }

        public final void setSplitString(SplitString.BuilderImpl splitString) {
            this.splitString = splitString != null ? splitString.build() : null;
        }

        @Override
        public final Builder splitString(SplitString splitString) {
            this.splitString = splitString;
            return this;
        }

        public final SubstituteString.Builder getSubstituteString() {
            return substituteString != null ? substituteString.toBuilder() : null;
        }

        public final void setSubstituteString(SubstituteString.BuilderImpl substituteString) {
            this.substituteString = substituteString != null ? substituteString.build() : null;
        }

        @Override
        public final Builder substituteString(SubstituteString substituteString) {
            this.substituteString = substituteString;
            return this;
        }

        public final TrimString.Builder getTrimString() {
            return trimString != null ? trimString.toBuilder() : null;
        }

        public final void setTrimString(TrimString.BuilderImpl trimString) {
            this.trimString = trimString != null ? trimString.build() : null;
        }

        @Override
        public final Builder trimString(TrimString trimString) {
            this.trimString = trimString;
            return this;
        }

        public final TypeConverter.Builder getTypeConverter() {
            return typeConverter != null ? typeConverter.toBuilder() : null;
        }

        public final void setTypeConverter(TypeConverter.BuilderImpl typeConverter) {
            this.typeConverter = typeConverter != null ? typeConverter.build() : null;
        }

        @Override
        public final Builder typeConverter(TypeConverter typeConverter) {
            this.typeConverter = typeConverter;
            return this;
        }

        public final UpperCaseString.Builder getUpperCaseString() {
            return upperCaseString != null ? upperCaseString.toBuilder() : null;
        }

        public final void setUpperCaseString(UpperCaseString.BuilderImpl upperCaseString) {
            this.upperCaseString = upperCaseString != null ? upperCaseString.build() : null;
        }

        @Override
        public final Builder upperCaseString(UpperCaseString upperCaseString) {
            this.upperCaseString = upperCaseString;
            return this;
        }

        @Override
        public Processor build() {
            return new Processor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
