/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDataProtectionPolicyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutDataProtectionPolicyRequest.Builder, PutDataProtectionPolicyRequest> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupIdentifier").getter(getter(PutDataProtectionPolicyRequest::logGroupIdentifier))
            .setter(setter(Builder::logGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build())
            .build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(PutDataProtectionPolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD,
            POLICY_DOCUMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String logGroupIdentifier;

    private final String policyDocument;

    private PutDataProtectionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.policyDocument = builder.policyDocument;
    }

    /**
     * <p>
     * Specify either the log group name or log group ARN.
     * </p>
     * 
     * @return Specify either the log group name or log group ARN.
     */
    public final String logGroupIdentifier() {
        return logGroupIdentifier;
    }

    /**
     * <p>
     * Specify the data protection policy, in JSON.
     * </p>
     * <p>
     * This policy must include two JSON blocks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property with
     * an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of sensitive data that you
     * want to mask. For more information about the available options, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html">Types of data
     * that you can mask</a>.
     * </p>
     * <p>
     * The <code>Operation</code> property with an <code>Audit</code> action is required to find the sensitive data
     * terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code> object. You can optionally
     * use that <code>FindingsDestination</code> object to list one or more destinations to send audit findings to. If
     * you specify destinations such as log groups, Firehose streams, and S3 buckets, they must already exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property with
     * an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly match the
     * <code>DataIdentifer</code> array in the first block of the policy.
     * </p>
     * <p>
     * The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the data, and
     * it must contain the <code> "MaskConfig": {}</code> object. The <code> "MaskConfig": {}</code> object must be
     * empty.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an example data protection policy, see the <b>Examples</b> section on this page.
     * </p>
     * <important>
     * <p>
     * The contents of the two <code>DataIdentifer</code> arrays must match exactly.
     * </p>
     * </important>
     * <p>
     * In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code>,
     * <code>Description</code>, and <code>Version</code> fields. The <code>Name</code> is used as a dimension when
     * CloudWatch Logs reports audit findings metrics to CloudWatch.
     * </p>
     * <p>
     * The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
     * </p>
     * 
     * @return Specify the data protection policy, in JSON.</p>
     *         <p>
     *         This policy must include two JSON blocks:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code>
     *         property with an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of
     *         sensitive data that you want to mask. For more information about the available options, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html">Types
     *         of data that you can mask</a>.
     *         </p>
     *         <p>
     *         The <code>Operation</code> property with an <code>Audit</code> action is required to find the sensitive
     *         data terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code> object. You
     *         can optionally use that <code>FindingsDestination</code> object to list one or more destinations to send
     *         audit findings to. If you specify destinations such as log groups, Firehose streams, and S3 buckets, they
     *         must already exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code>
     *         property with an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly match
     *         the <code>DataIdentifer</code> array in the first block of the policy.
     *         </p>
     *         <p>
     *         The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the
     *         data, and it must contain the <code> "MaskConfig": {}</code> object. The <code> "MaskConfig": {}</code>
     *         object must be empty.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For an example data protection policy, see the <b>Examples</b> section on this page.
     *         </p>
     *         <important>
     *         <p>
     *         The contents of the two <code>DataIdentifer</code> arrays must match exactly.
     *         </p>
     *         </important>
     *         <p>
     *         In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code>,
     *         <code>Description</code>, and <code>Version</code> fields. The <code>Name</code> is used as a dimension
     *         when CloudWatch Logs reports audit findings metrics to CloudWatch.
     *         </p>
     *         <p>
     *         The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataProtectionPolicyRequest)) {
            return false;
        }
        PutDataProtectionPolicyRequest other = (PutDataProtectionPolicyRequest) obj;
        return Objects.equals(logGroupIdentifier(), other.logGroupIdentifier())
                && Objects.equals(policyDocument(), other.policyDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDataProtectionPolicyRequest").add("LogGroupIdentifier", logGroupIdentifier())
                .add("PolicyDocument", policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupIdentifier":
            return Optional.ofNullable(clazz.cast(logGroupIdentifier()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDataProtectionPolicyRequest, T> g) {
        return obj -> g.apply((PutDataProtectionPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDataProtectionPolicyRequest> {
        /**
         * <p>
         * Specify either the log group name or log group ARN.
         * </p>
         * 
         * @param logGroupIdentifier
         *        Specify either the log group name or log group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifier(String logGroupIdentifier);

        /**
         * <p>
         * Specify the data protection policy, in JSON.
         * </p>
         * <p>
         * This policy must include two JSON blocks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property
         * with an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of sensitive data
         * that you want to mask. For more information about the available options, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html">Types of
         * data that you can mask</a>.
         * </p>
         * <p>
         * The <code>Operation</code> property with an <code>Audit</code> action is required to find the sensitive data
         * terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code> object. You can
         * optionally use that <code>FindingsDestination</code> object to list one or more destinations to send audit
         * findings to. If you specify destinations such as log groups, Firehose streams, and S3 buckets, they must
         * already exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property
         * with an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly match the
         * <code>DataIdentifer</code> array in the first block of the policy.
         * </p>
         * <p>
         * The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the data,
         * and it must contain the <code> "MaskConfig": {}</code> object. The <code> "MaskConfig": {}</code> object must
         * be empty.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For an example data protection policy, see the <b>Examples</b> section on this page.
         * </p>
         * <important>
         * <p>
         * The contents of the two <code>DataIdentifer</code> arrays must match exactly.
         * </p>
         * </important>
         * <p>
         * In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code>,
         * <code>Description</code>, and <code>Version</code> fields. The <code>Name</code> is used as a dimension when
         * CloudWatch Logs reports audit findings metrics to CloudWatch.
         * </p>
         * <p>
         * The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
         * </p>
         * 
         * @param policyDocument
         *        Specify the data protection policy, in JSON.</p>
         *        <p>
         *        This policy must include two JSON blocks:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code>
         *        property with an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of
         *        sensitive data that you want to mask. For more information about the available options, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html"
         *        >Types of data that you can mask</a>.
         *        </p>
         *        <p>
         *        The <code>Operation</code> property with an <code>Audit</code> action is required to find the
         *        sensitive data terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code>
         *        object. You can optionally use that <code>FindingsDestination</code> object to list one or more
         *        destinations to send audit findings to. If you specify destinations such as log groups, Firehose
         *        streams, and S3 buckets, they must already exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code>
         *        property with an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly
         *        match the <code>DataIdentifer</code> array in the first block of the policy.
         *        </p>
         *        <p>
         *        The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the
         *        data, and it must contain the <code> "MaskConfig": {}</code> object. The
         *        <code> "MaskConfig": {}</code> object must be empty.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For an example data protection policy, see the <b>Examples</b> section on this page.
         *        </p>
         *        <important>
         *        <p>
         *        The contents of the two <code>DataIdentifer</code> arrays must match exactly.
         *        </p>
         *        </important>
         *        <p>
         *        In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code>, <code>Description</code>, and <code>Version</code> fields. The <code>Name</code> is used as a
         *        dimension when CloudWatch Logs reports audit findings metrics to CloudWatch.
         *        </p>
         *        <p>
         *        The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupIdentifier;

        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataProtectionPolicyRequest model) {
            super(model);
            logGroupIdentifier(model.logGroupIdentifier);
            policyDocument(model.policyDocument);
        }

        public final String getLogGroupIdentifier() {
            return logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataProtectionPolicyRequest build() {
            return new PutDataProtectionPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
