/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the number of log events scanned by the query, the number of log events that matched the query criteria, and
 * the total number of bytes in the log events that were scanned.
 * </p>
 * <p>
 * If the query involved log groups that have field index policies, the estimated number of skipped log events and the
 * total bytes of those skipped log events are included. Using field indexes to skip log events in queries reduces scan
 * volume and improves performance. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
 * indexes to improve query performance and reduce scan volume</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryStatistics implements SdkPojo, Serializable, ToCopyableBuilder<QueryStatistics.Builder, QueryStatistics> {
    private static final SdkField<Double> RECORDS_MATCHED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("recordsMatched").getter(getter(QueryStatistics::recordsMatched)).setter(setter(Builder::recordsMatched))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsMatched").build()).build();

    private static final SdkField<Double> RECORDS_SCANNED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("recordsScanned").getter(getter(QueryStatistics::recordsScanned)).setter(setter(Builder::recordsScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsScanned").build()).build();

    private static final SdkField<Double> ESTIMATED_RECORDS_SKIPPED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedRecordsSkipped").getter(getter(QueryStatistics::estimatedRecordsSkipped))
            .setter(setter(Builder::estimatedRecordsSkipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedRecordsSkipped").build())
            .build();

    private static final SdkField<Double> BYTES_SCANNED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("bytesScanned").getter(getter(QueryStatistics::bytesScanned)).setter(setter(Builder::bytesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesScanned").build()).build();

    private static final SdkField<Double> ESTIMATED_BYTES_SKIPPED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedBytesSkipped").getter(getter(QueryStatistics::estimatedBytesSkipped))
            .setter(setter(Builder::estimatedBytesSkipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedBytesSkipped").build())
            .build();

    private static final SdkField<Double> LOG_GROUPS_SCANNED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("logGroupsScanned").getter(getter(QueryStatistics::logGroupsScanned))
            .setter(setter(Builder::logGroupsScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupsScanned").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_MATCHED_FIELD,
            RECORDS_SCANNED_FIELD, ESTIMATED_RECORDS_SKIPPED_FIELD, BYTES_SCANNED_FIELD, ESTIMATED_BYTES_SKIPPED_FIELD,
            LOG_GROUPS_SCANNED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double recordsMatched;

    private final Double recordsScanned;

    private final Double estimatedRecordsSkipped;

    private final Double bytesScanned;

    private final Double estimatedBytesSkipped;

    private final Double logGroupsScanned;

    private QueryStatistics(BuilderImpl builder) {
        this.recordsMatched = builder.recordsMatched;
        this.recordsScanned = builder.recordsScanned;
        this.estimatedRecordsSkipped = builder.estimatedRecordsSkipped;
        this.bytesScanned = builder.bytesScanned;
        this.estimatedBytesSkipped = builder.estimatedBytesSkipped;
        this.logGroupsScanned = builder.logGroupsScanned;
    }

    /**
     * <p>
     * The number of log events that matched the query string.
     * </p>
     * 
     * @return The number of log events that matched the query string.
     */
    public final Double recordsMatched() {
        return recordsMatched;
    }

    /**
     * <p>
     * The total number of log events scanned during the query.
     * </p>
     * 
     * @return The total number of log events scanned during the query.
     */
    public final Double recordsScanned() {
        return recordsScanned;
    }

    /**
     * <p>
     * An estimate of the number of log events that were skipped when processing this query, because the query contained
     * an indexed field. Skipping these entries lowers query costs and improves the query performance time. For more
     * information about field indexes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     * >PutIndexPolicy</a>.
     * </p>
     * 
     * @return An estimate of the number of log events that were skipped when processing this query, because the query
     *         contained an indexed field. Skipping these entries lowers query costs and improves the query performance
     *         time. For more information about field indexes, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     *         >PutIndexPolicy</a>.
     */
    public final Double estimatedRecordsSkipped() {
        return estimatedRecordsSkipped;
    }

    /**
     * <p>
     * The total number of bytes in the log events scanned during the query.
     * </p>
     * 
     * @return The total number of bytes in the log events scanned during the query.
     */
    public final Double bytesScanned() {
        return bytesScanned;
    }

    /**
     * <p>
     * An estimate of the number of bytes in the log events that were skipped when processing this query, because the
     * query contained an indexed field. Skipping these entries lowers query costs and improves the query performance
     * time. For more information about field indexes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     * >PutIndexPolicy</a>.
     * </p>
     * 
     * @return An estimate of the number of bytes in the log events that were skipped when processing this query,
     *         because the query contained an indexed field. Skipping these entries lowers query costs and improves the
     *         query performance time. For more information about field indexes, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     *         >PutIndexPolicy</a>.
     */
    public final Double estimatedBytesSkipped() {
        return estimatedBytesSkipped;
    }

    /**
     * <p>
     * The number of log groups that were scanned by this query.
     * </p>
     * 
     * @return The number of log groups that were scanned by this query.
     */
    public final Double logGroupsScanned() {
        return logGroupsScanned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordsMatched());
        hashCode = 31 * hashCode + Objects.hashCode(recordsScanned());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedRecordsSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(bytesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedBytesSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupsScanned());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStatistics)) {
            return false;
        }
        QueryStatistics other = (QueryStatistics) obj;
        return Objects.equals(recordsMatched(), other.recordsMatched())
                && Objects.equals(recordsScanned(), other.recordsScanned())
                && Objects.equals(estimatedRecordsSkipped(), other.estimatedRecordsSkipped())
                && Objects.equals(bytesScanned(), other.bytesScanned())
                && Objects.equals(estimatedBytesSkipped(), other.estimatedBytesSkipped())
                && Objects.equals(logGroupsScanned(), other.logGroupsScanned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryStatistics").add("RecordsMatched", recordsMatched())
                .add("RecordsScanned", recordsScanned()).add("EstimatedRecordsSkipped", estimatedRecordsSkipped())
                .add("BytesScanned", bytesScanned()).add("EstimatedBytesSkipped", estimatedBytesSkipped())
                .add("LogGroupsScanned", logGroupsScanned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordsMatched":
            return Optional.ofNullable(clazz.cast(recordsMatched()));
        case "recordsScanned":
            return Optional.ofNullable(clazz.cast(recordsScanned()));
        case "estimatedRecordsSkipped":
            return Optional.ofNullable(clazz.cast(estimatedRecordsSkipped()));
        case "bytesScanned":
            return Optional.ofNullable(clazz.cast(bytesScanned()));
        case "estimatedBytesSkipped":
            return Optional.ofNullable(clazz.cast(estimatedBytesSkipped()));
        case "logGroupsScanned":
            return Optional.ofNullable(clazz.cast(logGroupsScanned()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recordsMatched", RECORDS_MATCHED_FIELD);
        map.put("recordsScanned", RECORDS_SCANNED_FIELD);
        map.put("estimatedRecordsSkipped", ESTIMATED_RECORDS_SKIPPED_FIELD);
        map.put("bytesScanned", BYTES_SCANNED_FIELD);
        map.put("estimatedBytesSkipped", ESTIMATED_BYTES_SKIPPED_FIELD);
        map.put("logGroupsScanned", LOG_GROUPS_SCANNED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryStatistics, T> g) {
        return obj -> g.apply((QueryStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryStatistics> {
        /**
         * <p>
         * The number of log events that matched the query string.
         * </p>
         * 
         * @param recordsMatched
         *        The number of log events that matched the query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsMatched(Double recordsMatched);

        /**
         * <p>
         * The total number of log events scanned during the query.
         * </p>
         * 
         * @param recordsScanned
         *        The total number of log events scanned during the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsScanned(Double recordsScanned);

        /**
         * <p>
         * An estimate of the number of log events that were skipped when processing this query, because the query
         * contained an indexed field. Skipping these entries lowers query costs and improves the query performance
         * time. For more information about field indexes, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
         * >PutIndexPolicy</a>.
         * </p>
         * 
         * @param estimatedRecordsSkipped
         *        An estimate of the number of log events that were skipped when processing this query, because the
         *        query contained an indexed field. Skipping these entries lowers query costs and improves the query
         *        performance time. For more information about field indexes, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
         *        >PutIndexPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedRecordsSkipped(Double estimatedRecordsSkipped);

        /**
         * <p>
         * The total number of bytes in the log events scanned during the query.
         * </p>
         * 
         * @param bytesScanned
         *        The total number of bytes in the log events scanned during the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesScanned(Double bytesScanned);

        /**
         * <p>
         * An estimate of the number of bytes in the log events that were skipped when processing this query, because
         * the query contained an indexed field. Skipping these entries lowers query costs and improves the query
         * performance time. For more information about field indexes, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
         * >PutIndexPolicy</a>.
         * </p>
         * 
         * @param estimatedBytesSkipped
         *        An estimate of the number of bytes in the log events that were skipped when processing this query,
         *        because the query contained an indexed field. Skipping these entries lowers query costs and improves
         *        the query performance time. For more information about field indexes, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
         *        >PutIndexPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedBytesSkipped(Double estimatedBytesSkipped);

        /**
         * <p>
         * The number of log groups that were scanned by this query.
         * </p>
         * 
         * @param logGroupsScanned
         *        The number of log groups that were scanned by this query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupsScanned(Double logGroupsScanned);
    }

    static final class BuilderImpl implements Builder {
        private Double recordsMatched;

        private Double recordsScanned;

        private Double estimatedRecordsSkipped;

        private Double bytesScanned;

        private Double estimatedBytesSkipped;

        private Double logGroupsScanned;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStatistics model) {
            recordsMatched(model.recordsMatched);
            recordsScanned(model.recordsScanned);
            estimatedRecordsSkipped(model.estimatedRecordsSkipped);
            bytesScanned(model.bytesScanned);
            estimatedBytesSkipped(model.estimatedBytesSkipped);
            logGroupsScanned(model.logGroupsScanned);
        }

        public final Double getRecordsMatched() {
            return recordsMatched;
        }

        public final void setRecordsMatched(Double recordsMatched) {
            this.recordsMatched = recordsMatched;
        }

        @Override
        public final Builder recordsMatched(Double recordsMatched) {
            this.recordsMatched = recordsMatched;
            return this;
        }

        public final Double getRecordsScanned() {
            return recordsScanned;
        }

        public final void setRecordsScanned(Double recordsScanned) {
            this.recordsScanned = recordsScanned;
        }

        @Override
        public final Builder recordsScanned(Double recordsScanned) {
            this.recordsScanned = recordsScanned;
            return this;
        }

        public final Double getEstimatedRecordsSkipped() {
            return estimatedRecordsSkipped;
        }

        public final void setEstimatedRecordsSkipped(Double estimatedRecordsSkipped) {
            this.estimatedRecordsSkipped = estimatedRecordsSkipped;
        }

        @Override
        public final Builder estimatedRecordsSkipped(Double estimatedRecordsSkipped) {
            this.estimatedRecordsSkipped = estimatedRecordsSkipped;
            return this;
        }

        public final Double getBytesScanned() {
            return bytesScanned;
        }

        public final void setBytesScanned(Double bytesScanned) {
            this.bytesScanned = bytesScanned;
        }

        @Override
        public final Builder bytesScanned(Double bytesScanned) {
            this.bytesScanned = bytesScanned;
            return this;
        }

        public final Double getEstimatedBytesSkipped() {
            return estimatedBytesSkipped;
        }

        public final void setEstimatedBytesSkipped(Double estimatedBytesSkipped) {
            this.estimatedBytesSkipped = estimatedBytesSkipped;
        }

        @Override
        public final Builder estimatedBytesSkipped(Double estimatedBytesSkipped) {
            this.estimatedBytesSkipped = estimatedBytesSkipped;
            return this;
        }

        public final Double getLogGroupsScanned() {
            return logGroupsScanned;
        }

        public final void setLogGroupsScanned(Double logGroupsScanned) {
            this.logGroupsScanned = logGroupsScanned;
        }

        @Override
        public final Builder logGroupsScanned(Double logGroupsScanned) {
            this.logGroupsScanned = logGroupsScanned;
            return this;
        }

        @Override
        public QueryStatistics build() {
            return new QueryStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
