/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(PutResourcePolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(PutResourcePolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(PutResourcePolicyRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> EXPECTED_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedRevisionId").getter(getter(PutResourcePolicyRequest::expectedRevisionId))
            .setter(setter(Builder::expectedRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedRevisionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_DOCUMENT_FIELD, RESOURCE_ARN_FIELD, EXPECTED_REVISION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyName;

    private final String policyDocument;

    private final String resourceArn;

    private final String expectedRevisionId;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.resourceArn = builder.resourceArn;
        this.expectedRevisionId = builder.expectedRevisionId;
    }

    /**
     * <p>
     * Name of the new policy. This parameter is required.
     * </p>
     * 
     * @return Name of the new policy. This parameter is required.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * Details of the new policy, including the identity of the principal that is enabled to put logs to this account.
     * This is formatted as a JSON string. This parameter is required.
     * </p>
     * <p>
     * The following example creates a resource policy enabling the Route 53 service to put DNS query logs in to the
     * specified log group. Replace <code>"logArn"</code> with the ARN of your CloudWatch Logs resource, such as a log
     * group or log stream.
     * </p>
     * <p>
     * CloudWatch Logs also supports <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn"
     * >aws:SourceArn</a> and <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount"
     * >aws:SourceAccount</a> condition context keys.
     * </p>
     * <p>
     * In the example resource policy, you would replace the value of <code>SourceArn</code> with the resource making
     * the call from Route 53 to CloudWatch Logs. You would also replace the value of <code>SourceAccount</code> with
     * the Amazon Web Services account ID making that call.
     * </p>
     * <p/>
     * <p>
     * <code>{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }</code>
     * </p>
     * 
     * @return Details of the new policy, including the identity of the principal that is enabled to put logs to this
     *         account. This is formatted as a JSON string. This parameter is required.</p>
     *         <p>
     *         The following example creates a resource policy enabling the Route 53 service to put DNS query logs in to
     *         the specified log group. Replace <code>"logArn"</code> with the ARN of your CloudWatch Logs resource,
     *         such as a log group or log stream.
     *         </p>
     *         <p>
     *         CloudWatch Logs also supports <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn"
     *         >aws:SourceArn</a> and <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount"
     *         >aws:SourceAccount</a> condition context keys.
     *         </p>
     *         <p>
     *         In the example resource policy, you would replace the value of <code>SourceArn</code> with the resource
     *         making the call from Route 53 to CloudWatch Logs. You would also replace the value of
     *         <code>SourceAccount</code> with the Amazon Web Services account ID making that call.
     *         </p>
     *         <p/>
     *         <p>
     *         <code>{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }</code>
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The ARN of the CloudWatch Logs resource to which the resource policy needs to be added or attached. Currently
     * only supports LogGroup ARN.
     * </p>
     * 
     * @return The ARN of the CloudWatch Logs resource to which the resource policy needs to be added or attached.
     *         Currently only supports LogGroup ARN.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The expected revision ID of the resource policy. Required when <code>resourceArn</code> is provided to prevent
     * concurrent modifications. Use <code>null</code> when creating a resource policy for the first time.
     * </p>
     * 
     * @return The expected revision ID of the resource policy. Required when <code>resourceArn</code> is provided to
     *         prevent concurrent modifications. Use <code>null</code> when creating a resource policy for the first
     *         time.
     */
    public final String expectedRevisionId() {
        return expectedRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRevisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(expectedRevisionId(), other.expectedRevisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("PolicyName", policyName())
                .add("PolicyDocument", policyDocument()).add("ResourceArn", resourceArn())
                .add("ExpectedRevisionId", expectedRevisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "expectedRevisionId":
            return Optional.ofNullable(clazz.cast(expectedRevisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("expectedRevisionId", EXPECTED_REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * Name of the new policy. This parameter is required.
         * </p>
         * 
         * @param policyName
         *        Name of the new policy. This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * Details of the new policy, including the identity of the principal that is enabled to put logs to this
         * account. This is formatted as a JSON string. This parameter is required.
         * </p>
         * <p>
         * The following example creates a resource policy enabling the Route 53 service to put DNS query logs in to the
         * specified log group. Replace <code>"logArn"</code> with the ARN of your CloudWatch Logs resource, such as a
         * log group or log stream.
         * </p>
         * <p>
         * CloudWatch Logs also supports <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn"
         * >aws:SourceArn</a> and <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount"
         * >aws:SourceAccount</a> condition context keys.
         * </p>
         * <p>
         * In the example resource policy, you would replace the value of <code>SourceArn</code> with the resource
         * making the call from Route 53 to CloudWatch Logs. You would also replace the value of
         * <code>SourceAccount</code> with the Amazon Web Services account ID making that call.
         * </p>
         * <p/>
         * <p>
         * <code>{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }</code>
         * </p>
         * 
         * @param policyDocument
         *        Details of the new policy, including the identity of the principal that is enabled to put logs to this
         *        account. This is formatted as a JSON string. This parameter is required.</p>
         *        <p>
         *        The following example creates a resource policy enabling the Route 53 service to put DNS query logs in
         *        to the specified log group. Replace <code>"logArn"</code> with the ARN of your CloudWatch Logs
         *        resource, such as a log group or log stream.
         *        </p>
         *        <p>
         *        CloudWatch Logs also supports <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn"
         *        >aws:SourceArn</a> and <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount"
         *        >aws:SourceAccount</a> condition context keys.
         *        </p>
         *        <p>
         *        In the example resource policy, you would replace the value of <code>SourceArn</code> with the
         *        resource making the call from Route 53 to CloudWatch Logs. You would also replace the value of
         *        <code>SourceAccount</code> with the Amazon Web Services account ID making that call.
         *        </p>
         *        <p/>
         *        <p>
         *        <code>{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The ARN of the CloudWatch Logs resource to which the resource policy needs to be added or attached. Currently
         * only supports LogGroup ARN.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the CloudWatch Logs resource to which the resource policy needs to be added or attached.
         *        Currently only supports LogGroup ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The expected revision ID of the resource policy. Required when <code>resourceArn</code> is provided to
         * prevent concurrent modifications. Use <code>null</code> when creating a resource policy for the first time.
         * </p>
         * 
         * @param expectedRevisionId
         *        The expected revision ID of the resource policy. Required when <code>resourceArn</code> is provided to
         *        prevent concurrent modifications. Use <code>null</code> when creating a resource policy for the first
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRevisionId(String expectedRevisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String policyName;

        private String policyDocument;

        private String resourceArn;

        private String expectedRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            policyName(model.policyName);
            policyDocument(model.policyDocument);
            resourceArn(model.resourceArn);
            expectedRevisionId(model.expectedRevisionId);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getExpectedRevisionId() {
            return expectedRevisionId;
        }

        public final void setExpectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
        }

        @Override
        public final Builder expectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
