/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object defines one key that will be renamed with the <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKey"
 * > renameKey</a> processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenameKeyEntry implements SdkPojo, Serializable, ToCopyableBuilder<RenameKeyEntry.Builder, RenameKeyEntry> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(RenameKeyEntry::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> RENAME_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("renameTo").getter(getter(RenameKeyEntry::renameTo)).setter(setter(Builder::renameTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renameTo").build()).build();

    private static final SdkField<Boolean> OVERWRITE_IF_EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overwriteIfExists").getter(getter(RenameKeyEntry::overwriteIfExists))
            .setter(setter(Builder::overwriteIfExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overwriteIfExists").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, RENAME_TO_FIELD,
            OVERWRITE_IF_EXISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String renameTo;

    private final Boolean overwriteIfExists;

    private RenameKeyEntry(BuilderImpl builder) {
        this.key = builder.key;
        this.renameTo = builder.renameTo;
        this.overwriteIfExists = builder.overwriteIfExists;
    }

    /**
     * <p>
     * The key to rename
     * </p>
     * 
     * @return The key to rename
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The string to use for the new key name
     * </p>
     * 
     * @return The string to use for the new key name
     */
    public final String renameTo() {
        return renameTo;
    }

    /**
     * <p>
     * Specifies whether to overwrite the existing value if the destination key already exists. The default is
     * <code>false</code>
     * </p>
     * 
     * @return Specifies whether to overwrite the existing value if the destination key already exists. The default is
     *         <code>false</code>
     */
    public final Boolean overwriteIfExists() {
        return overwriteIfExists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(renameTo());
        hashCode = 31 * hashCode + Objects.hashCode(overwriteIfExists());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameKeyEntry)) {
            return false;
        }
        RenameKeyEntry other = (RenameKeyEntry) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(renameTo(), other.renameTo())
                && Objects.equals(overwriteIfExists(), other.overwriteIfExists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenameKeyEntry").add("Key", key()).add("RenameTo", renameTo())
                .add("OverwriteIfExists", overwriteIfExists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "renameTo":
            return Optional.ofNullable(clazz.cast(renameTo()));
        case "overwriteIfExists":
            return Optional.ofNullable(clazz.cast(overwriteIfExists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("renameTo", RENAME_TO_FIELD);
        map.put("overwriteIfExists", OVERWRITE_IF_EXISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenameKeyEntry, T> g) {
        return obj -> g.apply((RenameKeyEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RenameKeyEntry> {
        /**
         * <p>
         * The key to rename
         * </p>
         * 
         * @param key
         *        The key to rename
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The string to use for the new key name
         * </p>
         * 
         * @param renameTo
         *        The string to use for the new key name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renameTo(String renameTo);

        /**
         * <p>
         * Specifies whether to overwrite the existing value if the destination key already exists. The default is
         * <code>false</code>
         * </p>
         * 
         * @param overwriteIfExists
         *        Specifies whether to overwrite the existing value if the destination key already exists. The default
         *        is <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overwriteIfExists(Boolean overwriteIfExists);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String renameTo;

        private Boolean overwriteIfExists;

        private BuilderImpl() {
        }

        private BuilderImpl(RenameKeyEntry model) {
            key(model.key);
            renameTo(model.renameTo);
            overwriteIfExists(model.overwriteIfExists);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getRenameTo() {
            return renameTo;
        }

        public final void setRenameTo(String renameTo) {
            this.renameTo = renameTo;
        }

        @Override
        public final Builder renameTo(String renameTo) {
            this.renameTo = renameTo;
            return this;
        }

        public final Boolean getOverwriteIfExists() {
            return overwriteIfExists;
        }

        public final void setOverwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
        }

        @Override
        public final Builder overwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        @Override
        public RenameKeyEntry build() {
            return new RenameKeyEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
