/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The fields contained in log events found by a <code>GetLogGroupFields</code> operation, along with the percentage of
 * queried log events in which each field appears.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogGroupField implements SdkPojo, Serializable, ToCopyableBuilder<LogGroupField.Builder, LogGroupField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LogGroupField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("percent").getter(getter(LogGroupField::percent)).setter(setter(Builder::percent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PERCENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer percent;

    private LogGroupField(BuilderImpl builder) {
        this.name = builder.name;
        this.percent = builder.percent;
    }

    /**
     * <p>
     * The name of a log field.
     * </p>
     * 
     * @return The name of a log field.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The percentage of log events queried that contained the field.
     * </p>
     * 
     * @return The percentage of log events queried that contained the field.
     */
    public final Integer percent() {
        return percent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(percent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroupField)) {
            return false;
        }
        LogGroupField other = (LogGroupField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(percent(), other.percent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogGroupField").add("Name", name()).add("Percent", percent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "percent":
            return Optional.ofNullable(clazz.cast(percent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("percent", PERCENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogGroupField, T> g) {
        return obj -> g.apply((LogGroupField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogGroupField> {
        /**
         * <p>
         * The name of a log field.
         * </p>
         * 
         * @param name
         *        The name of a log field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The percentage of log events queried that contained the field.
         * </p>
         * 
         * @param percent
         *        The percentage of log events queried that contained the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percent(Integer percent);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer percent;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroupField model) {
            name(model.name);
            percent(model.percent);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPercent() {
            return percent;
        }

        public final void setPercent(Integer percent) {
            this.percent = percent;
        }

        @Override
        public final Builder percent(Integer percent) {
            this.percent = percent;
            return this;
        }

        @Override
        public LogGroupField build() {
            return new LogGroupField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
