/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFieldIndexesResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeFieldIndexesResponse.Builder, DescribeFieldIndexesResponse> {
    private static final SdkField<List<FieldIndex>> FIELD_INDEXES_FIELD = SdkField
            .<List<FieldIndex>> builder(MarshallingType.LIST)
            .memberName("fieldIndexes")
            .getter(getter(DescribeFieldIndexesResponse::fieldIndexes))
            .setter(setter(Builder::fieldIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeFieldIndexesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_INDEXES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FieldIndex> fieldIndexes;

    private final String nextToken;

    private DescribeFieldIndexesResponse(BuilderImpl builder) {
        super(builder);
        this.fieldIndexes = builder.fieldIndexes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldIndexes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldIndexes() {
        return fieldIndexes != null && !(fieldIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the field index information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldIndexes} method.
     * </p>
     * 
     * @return An array containing the field index information.
     */
    public final List<FieldIndex> fieldIndexes() {
        return fieldIndexes;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldIndexes() ? fieldIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFieldIndexesResponse)) {
            return false;
        }
        DescribeFieldIndexesResponse other = (DescribeFieldIndexesResponse) obj;
        return hasFieldIndexes() == other.hasFieldIndexes() && Objects.equals(fieldIndexes(), other.fieldIndexes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFieldIndexesResponse").add("FieldIndexes", hasFieldIndexes() ? fieldIndexes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldIndexes":
            return Optional.ofNullable(clazz.cast(fieldIndexes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fieldIndexes", FIELD_INDEXES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFieldIndexesResponse, T> g) {
        return obj -> g.apply((DescribeFieldIndexesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFieldIndexesResponse> {
        /**
         * <p>
         * An array containing the field index information.
         * </p>
         * 
         * @param fieldIndexes
         *        An array containing the field index information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldIndexes(Collection<FieldIndex> fieldIndexes);

        /**
         * <p>
         * An array containing the field index information.
         * </p>
         * 
         * @param fieldIndexes
         *        An array containing the field index information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldIndexes(FieldIndex... fieldIndexes);

        /**
         * <p>
         * An array containing the field index information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.FieldIndex.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudwatchlogs.model.FieldIndex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.FieldIndex.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldIndexes(List<FieldIndex>)}.
         * 
         * @param fieldIndexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.FieldIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldIndexes(java.util.Collection<FieldIndex>)
         */
        Builder fieldIndexes(Consumer<FieldIndex.Builder>... fieldIndexes);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<FieldIndex> fieldIndexes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFieldIndexesResponse model) {
            super(model);
            fieldIndexes(model.fieldIndexes);
            nextToken(model.nextToken);
        }

        public final List<FieldIndex.Builder> getFieldIndexes() {
            List<FieldIndex.Builder> result = FieldIndexesCopier.copyToBuilder(this.fieldIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldIndexes(Collection<FieldIndex.BuilderImpl> fieldIndexes) {
            this.fieldIndexes = FieldIndexesCopier.copyFromBuilder(fieldIndexes);
        }

        @Override
        public final Builder fieldIndexes(Collection<FieldIndex> fieldIndexes) {
            this.fieldIndexes = FieldIndexesCopier.copy(fieldIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldIndexes(FieldIndex... fieldIndexes) {
            fieldIndexes(Arrays.asList(fieldIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldIndexes(Consumer<FieldIndex.Builder>... fieldIndexes) {
            fieldIndexes(Stream.of(fieldIndexes).map(c -> FieldIndex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFieldIndexesResponse build() {
            return new DescribeFieldIndexesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
