/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLogGroupsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<ListLogGroupsRequest.Builder, ListLogGroupsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupNamePattern").getter(getter(ListLogGroupsRequest::logGroupNamePattern))
            .setter(setter(Builder::logGroupNamePattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNamePattern").build())
            .build();

    private static final SdkField<String> LOG_GROUP_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupClass").getter(getter(ListLogGroupsRequest::logGroupClassAsString))
            .setter(setter(Builder::logGroupClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupClass").build()).build();

    private static final SdkField<Boolean> INCLUDE_LINKED_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeLinkedAccounts").getter(getter(ListLogGroupsRequest::includeLinkedAccounts))
            .setter(setter(Builder::includeLinkedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeLinkedAccounts").build())
            .build();

    private static final SdkField<List<String>> ACCOUNT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIdentifiers")
            .getter(getter(ListLogGroupsRequest::accountIdentifiers))
            .setter(setter(Builder::accountIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLogGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(ListLogGroupsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_PATTERN_FIELD,
            LOG_GROUP_CLASS_FIELD, INCLUDE_LINKED_ACCOUNTS_FIELD, ACCOUNT_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String logGroupNamePattern;

    private final String logGroupClass;

    private final Boolean includeLinkedAccounts;

    private final List<String> accountIdentifiers;

    private final String nextToken;

    private final Integer limit;

    private ListLogGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupNamePattern = builder.logGroupNamePattern;
        this.logGroupClass = builder.logGroupClass;
        this.includeLinkedAccounts = builder.includeLinkedAccounts;
        this.accountIdentifiers = builder.accountIdentifiers;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * Use this parameter to limit the returned log groups to only those with names that match the pattern that you
     * specify. This parameter is a regular expression that can match prefixes and substrings, and supports wildcard
     * matching and matching multiple patterns, as in the following examples.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>^</code> to match log group names by prefix.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a substring match, specify the string to match. All matches are case sensitive
     * </p>
     * </li>
     * <li>
     * <p>
     * To match multiple patterns, separate them with a <code>|</code> as in the example
     * <code>^/aws/lambda|discovery</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify as many as five different regular expression patterns in this field, each of which must be
     * between 3 and 24 characters. You can include the <code>^</code> symbol as many as five times, and include the
     * <code>|</code> symbol as many as four times.
     * </p>
     * 
     * @return Use this parameter to limit the returned log groups to only those with names that match the pattern that
     *         you specify. This parameter is a regular expression that can match prefixes and substrings, and supports
     *         wildcard matching and matching multiple patterns, as in the following examples. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>^</code> to match log group names by prefix.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a substring match, specify the string to match. All matches are case sensitive
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To match multiple patterns, separate them with a <code>|</code> as in the example
     *         <code>^/aws/lambda|discovery</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can specify as many as five different regular expression patterns in this field, each of which must
     *         be between 3 and 24 characters. You can include the <code>^</code> symbol as many as five times, and
     *         include the <code>|</code> symbol as many as four times.
     */
    public final String logGroupNamePattern() {
        return logGroupNamePattern;
    }

    /**
     * <p>
     * Use this parameter to limit the results to only those log groups in the specified log group class. If you omit
     * this parameter, log groups of all classes can be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logGroupClass}
     * will return {@link LogGroupClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logGroupClassAsString}.
     * </p>
     * 
     * @return Use this parameter to limit the results to only those log groups in the specified log group class. If you
     *         omit this parameter, log groups of all classes can be returned.
     * @see LogGroupClass
     */
    public final LogGroupClass logGroupClass() {
        return LogGroupClass.fromValue(logGroupClass);
    }

    /**
     * <p>
     * Use this parameter to limit the results to only those log groups in the specified log group class. If you omit
     * this parameter, log groups of all classes can be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logGroupClass}
     * will return {@link LogGroupClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logGroupClassAsString}.
     * </p>
     * 
     * @return Use this parameter to limit the results to only those log groups in the specified log group class. If you
     *         omit this parameter, log groups of all classes can be returned.
     * @see LogGroupClass
     */
    public final String logGroupClassAsString() {
        return logGroupClass;
    }

    /**
     * <p>
     * If you are using a monitoring account, set this to <code>true</code> to have the operation return log groups in
     * the accounts listed in <code>accountIdentifiers</code>.
     * </p>
     * <p>
     * If this parameter is set to <code>true</code> and <code>accountIdentifiers</code> contains a null value, the
     * operation returns all log groups in the monitoring account and all log groups in all source accounts that are
     * linked to the monitoring account.
     * </p>
     * <p>
     * The default for this parameter is <code>false</code>.
     * </p>
     * 
     * @return If you are using a monitoring account, set this to <code>true</code> to have the operation return log
     *         groups in the accounts listed in <code>accountIdentifiers</code>.</p>
     *         <p>
     *         If this parameter is set to <code>true</code> and <code>accountIdentifiers</code> contains a null value,
     *         the operation returns all log groups in the monitoring account and all log groups in all source accounts
     *         that are linked to the monitoring account.
     *         </p>
     *         <p>
     *         The default for this parameter is <code>false</code>.
     */
    public final Boolean includeLinkedAccounts() {
        return includeLinkedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountIdentifiers() {
        return accountIdentifiers != null && !(accountIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When <code>includeLinkedAccounts</code> is set to <code>true</code>, use this parameter to specify the list of
     * accounts to search. You can specify as many as 20 account IDs in the array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIdentifiers} method.
     * </p>
     * 
     * @return When <code>includeLinkedAccounts</code> is set to <code>true</code>, use this parameter to specify the
     *         list of accounts to search. You can specify as many as 20 account IDs in the array.
     */
    public final List<String> accountIdentifiers() {
        return accountIdentifiers;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of log groups to return. If you omit this parameter, the default is up to 50 log groups.
     * </p>
     * 
     * @return The maximum number of log groups to return. If you omit this parameter, the default is up to 50 log
     *         groups.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupNamePattern());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeLinkedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdentifiers() ? accountIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogGroupsRequest)) {
            return false;
        }
        ListLogGroupsRequest other = (ListLogGroupsRequest) obj;
        return Objects.equals(logGroupNamePattern(), other.logGroupNamePattern())
                && Objects.equals(logGroupClassAsString(), other.logGroupClassAsString())
                && Objects.equals(includeLinkedAccounts(), other.includeLinkedAccounts())
                && hasAccountIdentifiers() == other.hasAccountIdentifiers()
                && Objects.equals(accountIdentifiers(), other.accountIdentifiers())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLogGroupsRequest").add("LogGroupNamePattern", logGroupNamePattern())
                .add("LogGroupClass", logGroupClassAsString()).add("IncludeLinkedAccounts", includeLinkedAccounts())
                .add("AccountIdentifiers", hasAccountIdentifiers() ? accountIdentifiers() : null).add("NextToken", nextToken())
                .add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupNamePattern":
            return Optional.ofNullable(clazz.cast(logGroupNamePattern()));
        case "logGroupClass":
            return Optional.ofNullable(clazz.cast(logGroupClassAsString()));
        case "includeLinkedAccounts":
            return Optional.ofNullable(clazz.cast(includeLinkedAccounts()));
        case "accountIdentifiers":
            return Optional.ofNullable(clazz.cast(accountIdentifiers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupNamePattern", LOG_GROUP_NAME_PATTERN_FIELD);
        map.put("logGroupClass", LOG_GROUP_CLASS_FIELD);
        map.put("includeLinkedAccounts", INCLUDE_LINKED_ACCOUNTS_FIELD);
        map.put("accountIdentifiers", ACCOUNT_IDENTIFIERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLogGroupsRequest, T> g) {
        return obj -> g.apply((ListLogGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLogGroupsRequest> {
        /**
         * <p>
         * Use this parameter to limit the returned log groups to only those with names that match the pattern that you
         * specify. This parameter is a regular expression that can match prefixes and substrings, and supports wildcard
         * matching and matching multiple patterns, as in the following examples.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>^</code> to match log group names by prefix.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a substring match, specify the string to match. All matches are case sensitive
         * </p>
         * </li>
         * <li>
         * <p>
         * To match multiple patterns, separate them with a <code>|</code> as in the example
         * <code>^/aws/lambda|discovery</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can specify as many as five different regular expression patterns in this field, each of which must be
         * between 3 and 24 characters. You can include the <code>^</code> symbol as many as five times, and include the
         * <code>|</code> symbol as many as four times.
         * </p>
         * 
         * @param logGroupNamePattern
         *        Use this parameter to limit the returned log groups to only those with names that match the pattern
         *        that you specify. This parameter is a regular expression that can match prefixes and substrings, and
         *        supports wildcard matching and matching multiple patterns, as in the following examples. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>^</code> to match log group names by prefix.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a substring match, specify the string to match. All matches are case sensitive
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To match multiple patterns, separate them with a <code>|</code> as in the example
         *        <code>^/aws/lambda|discovery</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can specify as many as five different regular expression patterns in this field, each of which
         *        must be between 3 and 24 characters. You can include the <code>^</code> symbol as many as five times,
         *        and include the <code>|</code> symbol as many as four times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupNamePattern(String logGroupNamePattern);

        /**
         * <p>
         * Use this parameter to limit the results to only those log groups in the specified log group class. If you
         * omit this parameter, log groups of all classes can be returned.
         * </p>
         * 
         * @param logGroupClass
         *        Use this parameter to limit the results to only those log groups in the specified log group class. If
         *        you omit this parameter, log groups of all classes can be returned.
         * @see LogGroupClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogGroupClass
         */
        Builder logGroupClass(String logGroupClass);

        /**
         * <p>
         * Use this parameter to limit the results to only those log groups in the specified log group class. If you
         * omit this parameter, log groups of all classes can be returned.
         * </p>
         * 
         * @param logGroupClass
         *        Use this parameter to limit the results to only those log groups in the specified log group class. If
         *        you omit this parameter, log groups of all classes can be returned.
         * @see LogGroupClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogGroupClass
         */
        Builder logGroupClass(LogGroupClass logGroupClass);

        /**
         * <p>
         * If you are using a monitoring account, set this to <code>true</code> to have the operation return log groups
         * in the accounts listed in <code>accountIdentifiers</code>.
         * </p>
         * <p>
         * If this parameter is set to <code>true</code> and <code>accountIdentifiers</code> contains a null value, the
         * operation returns all log groups in the monitoring account and all log groups in all source accounts that are
         * linked to the monitoring account.
         * </p>
         * <p>
         * The default for this parameter is <code>false</code>.
         * </p>
         * 
         * @param includeLinkedAccounts
         *        If you are using a monitoring account, set this to <code>true</code> to have the operation return log
         *        groups in the accounts listed in <code>accountIdentifiers</code>.</p>
         *        <p>
         *        If this parameter is set to <code>true</code> and <code>accountIdentifiers</code> contains a null
         *        value, the operation returns all log groups in the monitoring account and all log groups in all source
         *        accounts that are linked to the monitoring account.
         *        </p>
         *        <p>
         *        The default for this parameter is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeLinkedAccounts(Boolean includeLinkedAccounts);

        /**
         * <p>
         * When <code>includeLinkedAccounts</code> is set to <code>true</code>, use this parameter to specify the list
         * of accounts to search. You can specify as many as 20 account IDs in the array.
         * </p>
         * 
         * @param accountIdentifiers
         *        When <code>includeLinkedAccounts</code> is set to <code>true</code>, use this parameter to specify the
         *        list of accounts to search. You can specify as many as 20 account IDs in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdentifiers(Collection<String> accountIdentifiers);

        /**
         * <p>
         * When <code>includeLinkedAccounts</code> is set to <code>true</code>, use this parameter to specify the list
         * of accounts to search. You can specify as many as 20 account IDs in the array.
         * </p>
         * 
         * @param accountIdentifiers
         *        When <code>includeLinkedAccounts</code> is set to <code>true</code>, use this parameter to specify the
         *        list of accounts to search. You can specify as many as 20 account IDs in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdentifiers(String... accountIdentifiers);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of log groups to return. If you omit this parameter, the default is up to 50 log groups.
         * </p>
         * 
         * @param limit
         *        The maximum number of log groups to return. If you omit this parameter, the default is up to 50 log
         *        groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupNamePattern;

        private String logGroupClass;

        private Boolean includeLinkedAccounts;

        private List<String> accountIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogGroupsRequest model) {
            super(model);
            logGroupNamePattern(model.logGroupNamePattern);
            logGroupClass(model.logGroupClass);
            includeLinkedAccounts(model.includeLinkedAccounts);
            accountIdentifiers(model.accountIdentifiers);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getLogGroupNamePattern() {
            return logGroupNamePattern;
        }

        public final void setLogGroupNamePattern(String logGroupNamePattern) {
            this.logGroupNamePattern = logGroupNamePattern;
        }

        @Override
        public final Builder logGroupNamePattern(String logGroupNamePattern) {
            this.logGroupNamePattern = logGroupNamePattern;
            return this;
        }

        public final String getLogGroupClass() {
            return logGroupClass;
        }

        public final void setLogGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
        }

        @Override
        public final Builder logGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
            return this;
        }

        @Override
        public final Builder logGroupClass(LogGroupClass logGroupClass) {
            this.logGroupClass(logGroupClass == null ? null : logGroupClass.toString());
            return this;
        }

        public final Boolean getIncludeLinkedAccounts() {
            return includeLinkedAccounts;
        }

        public final void setIncludeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
        }

        @Override
        public final Builder includeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
            return this;
        }

        public final Collection<String> getAccountIdentifiers() {
            if (accountIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIdentifiers;
        }

        public final void setAccountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
        }

        @Override
        public final Builder accountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdentifiers(String... accountIdentifiers) {
            accountIdentifiers(Arrays.asList(accountIdentifiers));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLogGroupsRequest build() {
            return new ListLogGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
