/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.ColumnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CSV
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CSV> {
    private static final SdkField<String> QUOTE_CHARACTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quoteCharacter").getter(CSV.getter(CSV::quoteCharacter)).setter(CSV.setter(Builder::quoteCharacter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quoteCharacter").build()}).build();
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("delimiter").getter(CSV.getter(CSV::delimiter)).setter(CSV.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delimiter").build()}).build();
    private static final SdkField<List<String>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columns").getter(CSV.getter(CSV::columns)).setter(CSV.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(CSV.getter(CSV::source)).setter(CSV.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUOTE_CHARACTER_FIELD, DELIMITER_FIELD, COLUMNS_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CSV.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String quoteCharacter;
    private final String delimiter;
    private final List<String> columns;
    private final String source;

    private CSV(BuilderImpl builder) {
        this.quoteCharacter = builder.quoteCharacter;
        this.delimiter = builder.delimiter;
        this.columns = builder.columns;
        this.source = builder.source;
    }

    public final String quoteCharacter() {
        return this.quoteCharacter;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<String> columns() {
        return this.columns;
    }

    public final String source() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteCharacter());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSV)) {
            return false;
        }
        CSV other = (CSV)obj;
        return Objects.equals(this.quoteCharacter(), other.quoteCharacter()) && Objects.equals(this.delimiter(), other.delimiter()) && this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && Objects.equals(this.source(), other.source());
    }

    public final String toString() {
        return ToString.builder((String)"CSV").add("QuoteCharacter", (Object)this.quoteCharacter()).add("Delimiter", (Object)this.delimiter()).add("Columns", this.hasColumns() ? this.columns() : null).add("Source", (Object)this.source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "quoteCharacter": {
                return Optional.ofNullable(clazz.cast(this.quoteCharacter()));
            }
            case "delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("quoteCharacter", QUOTE_CHARACTER_FIELD);
        map.put("delimiter", DELIMITER_FIELD);
        map.put("columns", COLUMNS_FIELD);
        map.put("source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CSV, T> g) {
        return obj -> g.apply((CSV)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String quoteCharacter;
        private String delimiter;
        private List<String> columns = DefaultSdkAutoConstructList.getInstance();
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(CSV model) {
            this.quoteCharacter(model.quoteCharacter);
            this.delimiter(model.delimiter);
            this.columns(model.columns);
            this.source(model.source);
        }

        public final String getQuoteCharacter() {
            return this.quoteCharacter;
        }

        public final void setQuoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
        }

        @Override
        public final Builder quoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final Collection<String> getColumns() {
            if (this.columns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columns;
        }

        public final void setColumns(Collection<String> columns) {
            this.columns = ColumnsCopier.copy(columns);
        }

        @Override
        public final Builder columns(Collection<String> columns) {
            this.columns = ColumnsCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(String ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public CSV build() {
            return new CSV(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CSV> {
        public Builder quoteCharacter(String var1);

        public Builder delimiter(String var1);

        public Builder columns(Collection<String> var1);

        public Builder columns(String ... var1);

        public Builder source(String var1);
    }
}

