/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutIndexPolicyResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<PutIndexPolicyResponse.Builder, PutIndexPolicyResponse> {
    private static final SdkField<IndexPolicy> INDEX_POLICY_FIELD = SdkField.<IndexPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("indexPolicy").getter(getter(PutIndexPolicyResponse::indexPolicy)).setter(setter(Builder::indexPolicy))
            .constructor(IndexPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IndexPolicy indexPolicy;

    private PutIndexPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.indexPolicy = builder.indexPolicy;
    }

    /**
     * <p>
     * The index policy that you just created or updated.
     * </p>
     * 
     * @return The index policy that you just created or updated.
     */
    public final IndexPolicy indexPolicy() {
        return indexPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIndexPolicyResponse)) {
            return false;
        }
        PutIndexPolicyResponse other = (PutIndexPolicyResponse) obj;
        return Objects.equals(indexPolicy(), other.indexPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutIndexPolicyResponse").add("IndexPolicy", indexPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexPolicy":
            return Optional.ofNullable(clazz.cast(indexPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("indexPolicy", INDEX_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutIndexPolicyResponse, T> g) {
        return obj -> g.apply((PutIndexPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutIndexPolicyResponse> {
        /**
         * <p>
         * The index policy that you just created or updated.
         * </p>
         * 
         * @param indexPolicy
         *        The index policy that you just created or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexPolicy(IndexPolicy indexPolicy);

        /**
         * <p>
         * The index policy that you just created or updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexPolicy.Builder} avoiding the need to
         * create one manually via {@link IndexPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexPolicy.Builder#build()} is called immediately and its result
         * is passed to {@link #indexPolicy(IndexPolicy)}.
         * 
         * @param indexPolicy
         *        a consumer that will call methods on {@link IndexPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexPolicy(IndexPolicy)
         */
        default Builder indexPolicy(Consumer<IndexPolicy.Builder> indexPolicy) {
            return indexPolicy(IndexPolicy.builder().applyMutation(indexPolicy).build());
        }
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private IndexPolicy indexPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIndexPolicyResponse model) {
            super(model);
            indexPolicy(model.indexPolicy);
        }

        public final IndexPolicy.Builder getIndexPolicy() {
            return indexPolicy != null ? indexPolicy.toBuilder() : null;
        }

        public final void setIndexPolicy(IndexPolicy.BuilderImpl indexPolicy) {
            this.indexPolicy = indexPolicy != null ? indexPolicy.build() : null;
        }

        @Override
        public final Builder indexPolicy(IndexPolicy indexPolicy) {
            this.indexPolicy = indexPolicy;
            return this;
        }

        @Override
        public PutIndexPolicyResponse build() {
            return new PutIndexPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
