/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A record of a scheduled query execution, including its status and destination processing information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TriggerHistoryRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<TriggerHistoryRecord.Builder, TriggerHistoryRecord> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryId").getter(getter(TriggerHistoryRecord::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryId").build()).build();

    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionStatus").getter(getter(TriggerHistoryRecord::executionStatusAsString))
            .setter(setter(Builder::executionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()).build();

    private static final SdkField<Long> TRIGGERED_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("triggeredTimestamp").getter(getter(TriggerHistoryRecord::triggeredTimestamp))
            .setter(setter(Builder::triggeredTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggeredTimestamp").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(TriggerHistoryRecord::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<ScheduledQueryDestination>> DESTINATIONS_FIELD = SdkField
            .<List<ScheduledQueryDestination>> builder(MarshallingType.LIST)
            .memberName("destinations")
            .getter(getter(TriggerHistoryRecord::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledQueryDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledQueryDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            EXECUTION_STATUS_FIELD, TRIGGERED_TIMESTAMP_FIELD, ERROR_MESSAGE_FIELD, DESTINATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queryId;

    private final String executionStatus;

    private final Long triggeredTimestamp;

    private final String errorMessage;

    private final List<ScheduledQueryDestination> destinations;

    private TriggerHistoryRecord(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.executionStatus = builder.executionStatus;
        this.triggeredTimestamp = builder.triggeredTimestamp;
        this.errorMessage = builder.errorMessage;
        this.destinations = builder.destinations;
    }

    /**
     * <p>
     * The unique identifier for the query execution.
     * </p>
     * 
     * @return The unique identifier for the query execution.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The status of the query execution (SUCCEEDED, FAILED, TIMEOUT, or INVALID_QUERY).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return The status of the query execution (SUCCEEDED, FAILED, TIMEOUT, or INVALID_QUERY).
     * @see ExecutionStatus
     */
    public final ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(executionStatus);
    }

    /**
     * <p>
     * The status of the query execution (SUCCEEDED, FAILED, TIMEOUT, or INVALID_QUERY).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return The status of the query execution (SUCCEEDED, FAILED, TIMEOUT, or INVALID_QUERY).
     * @see ExecutionStatus
     */
    public final String executionStatusAsString() {
        return executionStatus;
    }

    /**
     * <p>
     * The time when the scheduled query was triggered, in Unix epoch time.
     * </p>
     * 
     * @return The time when the scheduled query was triggered, in Unix epoch time.
     */
    public final Long triggeredTimestamp() {
        return triggeredTimestamp;
    }

    /**
     * <p>
     * The error message if the scheduled query execution failed. This field is only populated when the execution status
     * indicates a failure.
     * </p>
     * 
     * @return The error message if the scheduled query execution failed. This field is only populated when the
     *         execution status indicates a failure.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of destinations where the scheduled query results were delivered for this execution. This includes S3
     * buckets and EventBridge targets configured for the scheduled query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The list of destinations where the scheduled query results were delivered for this execution. This
     *         includes S3 buckets and EventBridge targets configured for the scheduled query.
     */
    public final List<ScheduledQueryDestination> destinations() {
        return destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggeredTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerHistoryRecord)) {
            return false;
        }
        TriggerHistoryRecord other = (TriggerHistoryRecord) obj;
        return Objects.equals(queryId(), other.queryId())
                && Objects.equals(executionStatusAsString(), other.executionStatusAsString())
                && Objects.equals(triggeredTimestamp(), other.triggeredTimestamp())
                && Objects.equals(errorMessage(), other.errorMessage()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TriggerHistoryRecord").add("QueryId", queryId())
                .add("ExecutionStatus", executionStatusAsString()).add("TriggeredTimestamp", triggeredTimestamp())
                .add("ErrorMessage", errorMessage()).add("Destinations", hasDestinations() ? destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "executionStatus":
            return Optional.ofNullable(clazz.cast(executionStatusAsString()));
        case "triggeredTimestamp":
            return Optional.ofNullable(clazz.cast(triggeredTimestamp()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryId", QUERY_ID_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("triggeredTimestamp", TRIGGERED_TIMESTAMP_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TriggerHistoryRecord, T> g) {
        return obj -> g.apply((TriggerHistoryRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TriggerHistoryRecord> {
        /**
         * <p>
         * The unique identifier for the query execution.
         * </p>
         * 
         * @param queryId
         *        The unique identifier for the query execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The status of the query execution (SUCCEEDED, FAILED, TIMEOUT, or INVALID_QUERY).
         * </p>
         * 
         * @param executionStatus
         *        The status of the query execution (SUCCEEDED, FAILED, TIMEOUT, or INVALID_QUERY).
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(String executionStatus);

        /**
         * <p>
         * The status of the query execution (SUCCEEDED, FAILED, TIMEOUT, or INVALID_QUERY).
         * </p>
         * 
         * @param executionStatus
         *        The status of the query execution (SUCCEEDED, FAILED, TIMEOUT, or INVALID_QUERY).
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * The time when the scheduled query was triggered, in Unix epoch time.
         * </p>
         * 
         * @param triggeredTimestamp
         *        The time when the scheduled query was triggered, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggeredTimestamp(Long triggeredTimestamp);

        /**
         * <p>
         * The error message if the scheduled query execution failed. This field is only populated when the execution
         * status indicates a failure.
         * </p>
         * 
         * @param errorMessage
         *        The error message if the scheduled query execution failed. This field is only populated when the
         *        execution status indicates a failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The list of destinations where the scheduled query results were delivered for this execution. This includes
         * S3 buckets and EventBridge targets configured for the scheduled query.
         * </p>
         * 
         * @param destinations
         *        The list of destinations where the scheduled query results were delivered for this execution. This
         *        includes S3 buckets and EventBridge targets configured for the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<ScheduledQueryDestination> destinations);

        /**
         * <p>
         * The list of destinations where the scheduled query results were delivered for this execution. This includes
         * S3 buckets and EventBridge targets configured for the scheduled query.
         * </p>
         * 
         * @param destinations
         *        The list of destinations where the scheduled query results were delivered for this execution. This
         *        includes S3 buckets and EventBridge targets configured for the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(ScheduledQueryDestination... destinations);

        /**
         * <p>
         * The list of destinations where the scheduled query results were delivered for this execution. This includes
         * S3 buckets and EventBridge targets configured for the scheduled query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryDestination.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryDestination.Builder#build()} is
         * called immediately and its result is passed to {@link #destinations(List<ScheduledQueryDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<ScheduledQueryDestination>)
         */
        Builder destinations(Consumer<ScheduledQueryDestination.Builder>... destinations);
    }

    static final class BuilderImpl implements Builder {
        private String queryId;

        private String executionStatus;

        private Long triggeredTimestamp;

        private String errorMessage;

        private List<ScheduledQueryDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerHistoryRecord model) {
            queryId(model.queryId);
            executionStatus(model.executionStatus);
            triggeredTimestamp(model.triggeredTimestamp);
            errorMessage(model.errorMessage);
            destinations(model.destinations);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getExecutionStatus() {
            return executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final Long getTriggeredTimestamp() {
            return triggeredTimestamp;
        }

        public final void setTriggeredTimestamp(Long triggeredTimestamp) {
            this.triggeredTimestamp = triggeredTimestamp;
        }

        @Override
        public final Builder triggeredTimestamp(Long triggeredTimestamp) {
            this.triggeredTimestamp = triggeredTimestamp;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final List<ScheduledQueryDestination.Builder> getDestinations() {
            List<ScheduledQueryDestination.Builder> result = ScheduledQueryDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<ScheduledQueryDestination.BuilderImpl> destinations) {
            this.destinations = ScheduledQueryDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<ScheduledQueryDestination> destinations) {
            this.destinations = ScheduledQueryDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(ScheduledQueryDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<ScheduledQueryDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> ScheduledQueryDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TriggerHistoryRecord build() {
            return new TriggerHistoryRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
