/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduledQueryRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<CreateScheduledQueryRequest.Builder, CreateScheduledQueryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateScheduledQueryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateScheduledQueryRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> QUERY_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryLanguage").getter(getter(CreateScheduledQueryRequest::queryLanguageAsString))
            .setter(setter(Builder::queryLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLanguage").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(CreateScheduledQueryRequest::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<List<String>> LOG_GROUP_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logGroupIdentifiers")
            .getter(getter(CreateScheduledQueryRequest::logGroupIdentifiers))
            .setter(setter(Builder::logGroupIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleExpression").getter(getter(CreateScheduledQueryRequest::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build())
            .build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(CreateScheduledQueryRequest::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final SdkField<Long> START_TIME_OFFSET_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startTimeOffset").getter(getter(CreateScheduledQueryRequest::startTimeOffset))
            .setter(setter(Builder::startTimeOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeOffset").build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(CreateScheduledQueryRequest::destinationConfiguration))
            .setter(setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final SdkField<Long> SCHEDULE_START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduleStartTime").getter(getter(CreateScheduledQueryRequest::scheduleStartTime))
            .setter(setter(Builder::scheduleStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleStartTime").build()).build();

    private static final SdkField<Long> SCHEDULE_END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduleEndTime").getter(getter(CreateScheduledQueryRequest::scheduleEndTime))
            .setter(setter(Builder::scheduleEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleEndTime").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(CreateScheduledQueryRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(CreateScheduledQueryRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateScheduledQueryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            QUERY_LANGUAGE_FIELD, QUERY_STRING_FIELD, LOG_GROUP_IDENTIFIERS_FIELD, SCHEDULE_EXPRESSION_FIELD, TIMEZONE_FIELD,
            START_TIME_OFFSET_FIELD, DESTINATION_CONFIGURATION_FIELD, SCHEDULE_START_TIME_FIELD, SCHEDULE_END_TIME_FIELD,
            EXECUTION_ROLE_ARN_FIELD, STATE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String queryLanguage;

    private final String queryString;

    private final List<String> logGroupIdentifiers;

    private final String scheduleExpression;

    private final String timezone;

    private final Long startTimeOffset;

    private final DestinationConfiguration destinationConfiguration;

    private final Long scheduleStartTime;

    private final Long scheduleEndTime;

    private final String executionRoleArn;

    private final String state;

    private final Map<String, String> tags;

    private CreateScheduledQueryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.queryLanguage = builder.queryLanguage;
        this.queryString = builder.queryString;
        this.logGroupIdentifiers = builder.logGroupIdentifiers;
        this.scheduleExpression = builder.scheduleExpression;
        this.timezone = builder.timezone;
        this.startTimeOffset = builder.startTimeOffset;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.scheduleStartTime = builder.scheduleStartTime;
        this.scheduleEndTime = builder.scheduleEndTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name for the scheduled query within the region for an AWS account. The name can contain letters,
     * numbers, underscores, hyphens, forward slashes, periods, and hash symbols.
     * </p>
     * 
     * @return A unique name for the scheduled query within the region for an AWS account. The name can contain letters,
     *         numbers, underscores, hyphens, forward slashes, periods, and hash symbols.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the scheduled query to help identify its purpose.
     * </p>
     * 
     * @return An optional description for the scheduled query to help identify its purpose.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The query language to use for the scheduled query. Valid values are LogsQL (CloudWatch Logs Insights query
     * language), PPL (OpenSearch Service Piped Processing Language), and SQL (OpenSearch Service Structured Query
     * Language).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLanguage}
     * will return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryLanguageAsString}.
     * </p>
     * 
     * @return The query language to use for the scheduled query. Valid values are LogsQL (CloudWatch Logs Insights
     *         query language), PPL (OpenSearch Service Piped Processing Language), and SQL (OpenSearch Service
     *         Structured Query Language).
     * @see QueryLanguage
     */
    public final QueryLanguage queryLanguage() {
        return QueryLanguage.fromValue(queryLanguage);
    }

    /**
     * <p>
     * The query language to use for the scheduled query. Valid values are LogsQL (CloudWatch Logs Insights query
     * language), PPL (OpenSearch Service Piped Processing Language), and SQL (OpenSearch Service Structured Query
     * Language).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLanguage}
     * will return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryLanguageAsString}.
     * </p>
     * 
     * @return The query language to use for the scheduled query. Valid values are LogsQL (CloudWatch Logs Insights
     *         query language), PPL (OpenSearch Service Piped Processing Language), and SQL (OpenSearch Service
     *         Structured Query Language).
     * @see QueryLanguage
     */
    public final String queryLanguageAsString() {
        return queryLanguage;
    }

    /**
     * <p>
     * The CloudWatch Logs Insights query string to execute. This is the actual query that will be run against your log
     * data on the specified schedule.
     * </p>
     * 
     * @return The CloudWatch Logs Insights query string to execute. This is the actual query that will be run against
     *         your log data on the specified schedule.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroupIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogGroupIdentifiers() {
        return logGroupIdentifiers != null && !(logGroupIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log group identifiers to query. You can specify log group names or log group ARNs. If querying log groups in
     * a source account from a monitoring account, you must specify the ARN of the log group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroupIdentifiers} method.
     * </p>
     * 
     * @return The log group identifiers to query. You can specify log group names or log group ARNs. If querying log
     *         groups in a source account from a monitoring account, you must specify the ARN of the log group.
     */
    public final List<String> logGroupIdentifiers() {
        return logGroupIdentifiers;
    }

    /**
     * <p>
     * A cron expression that defines when the scheduled query runs. The format is cron(fields) where fields consist of
     * six space-separated values: minutes, hours, day_of_month, month, day_of_week, year.
     * </p>
     * 
     * @return A cron expression that defines when the scheduled query runs. The format is cron(fields) where fields
     *         consist of six space-separated values: minutes, hours, day_of_month, month, day_of_week, year.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * The timezone in which the schedule expression is evaluated. If not provided, defaults to UTC.
     * </p>
     * 
     * @return The timezone in which the schedule expression is evaluated. If not provided, defaults to UTC.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Time offset in seconds from the execution time for the start of the query time range. This defines the lookback
     * period for the query (for example, 3600 for the last hour).
     * </p>
     * 
     * @return Time offset in seconds from the execution time for the start of the query time range. This defines the
     *         lookback period for the query (for example, 3600 for the last hour).
     */
    public final Long startTimeOffset() {
        return startTimeOffset;
    }

    /**
     * <p>
     * Configuration for destinations where the query results will be delivered after successful execution. You can
     * configure delivery to S3 buckets or EventBridge event buses.
     * </p>
     * 
     * @return Configuration for destinations where the query results will be delivered after successful execution. You
     *         can configure delivery to S3 buckets or EventBridge event buses.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * <p>
     * The start time for the query schedule in Unix epoch time (seconds since January 1, 1970, 00:00:00 UTC). If not
     * specified, the schedule starts immediately.
     * </p>
     * 
     * @return The start time for the query schedule in Unix epoch time (seconds since January 1, 1970, 00:00:00 UTC).
     *         If not specified, the schedule starts immediately.
     */
    public final Long scheduleStartTime() {
        return scheduleStartTime;
    }

    /**
     * <p>
     * The end time for the query schedule in Unix epoch time (seconds since January 1, 1970, 00:00:00 UTC). If not
     * specified, the schedule runs indefinitely.
     * </p>
     * 
     * @return The end time for the query schedule in Unix epoch time (seconds since January 1, 1970, 00:00:00 UTC). If
     *         not specified, the schedule runs indefinitely.
     */
    public final Long scheduleEndTime() {
        return scheduleEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that CloudWatch Logs will assume to execute the scheduled query
     * and deliver results to the specified destinations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that CloudWatch Logs will assume to execute the scheduled
     *         query and deliver results to the specified destinations.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The initial state of the scheduled query. Valid values are ENABLED (the query will run according to its schedule)
     * and DISABLED (the query is paused and will not run). If not provided, defaults to ENABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The initial state of the scheduled query. Valid values are ENABLED (the query will run according to its
     *         schedule) and DISABLED (the query is paused and will not run). If not provided, defaults to ENABLED.
     * @see ScheduledQueryState
     */
    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(state);
    }

    /**
     * <p>
     * The initial state of the scheduled query. Valid values are ENABLED (the query will run according to its schedule)
     * and DISABLED (the query is paused and will not run). If not provided, defaults to ENABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The initial state of the scheduled query. Valid values are ENABLED (the query will run according to its
     *         schedule) and DISABLED (the query is paused and will not run). If not provided, defaults to ENABLED.
     * @see ScheduledQueryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional list of key-value pairs to associate with the resource.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of key-value pairs to associate with the resource.</p>
     *         <p>
     *         For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(queryLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupIdentifiers() ? logGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledQueryRequest)) {
            return false;
        }
        CreateScheduledQueryRequest other = (CreateScheduledQueryRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(queryLanguageAsString(), other.queryLanguageAsString())
                && Objects.equals(queryString(), other.queryString())
                && hasLogGroupIdentifiers() == other.hasLogGroupIdentifiers()
                && Objects.equals(logGroupIdentifiers(), other.logGroupIdentifiers())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(timezone(), other.timezone()) && Objects.equals(startTimeOffset(), other.startTimeOffset())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration())
                && Objects.equals(scheduleStartTime(), other.scheduleStartTime())
                && Objects.equals(scheduleEndTime(), other.scheduleEndTime())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScheduledQueryRequest").add("Name", name()).add("Description", description())
                .add("QueryLanguage", queryLanguageAsString()).add("QueryString", queryString())
                .add("LogGroupIdentifiers", hasLogGroupIdentifiers() ? logGroupIdentifiers() : null)
                .add("ScheduleExpression", scheduleExpression()).add("Timezone", timezone())
                .add("StartTimeOffset", startTimeOffset()).add("DestinationConfiguration", destinationConfiguration())
                .add("ScheduleStartTime", scheduleStartTime()).add("ScheduleEndTime", scheduleEndTime())
                .add("ExecutionRoleArn", executionRoleArn()).add("State", stateAsString()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "queryLanguage":
            return Optional.ofNullable(clazz.cast(queryLanguageAsString()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "logGroupIdentifiers":
            return Optional.ofNullable(clazz.cast(logGroupIdentifiers()));
        case "scheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "startTimeOffset":
            return Optional.ofNullable(clazz.cast(startTimeOffset()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "scheduleStartTime":
            return Optional.ofNullable(clazz.cast(scheduleStartTime()));
        case "scheduleEndTime":
            return Optional.ofNullable(clazz.cast(scheduleEndTime()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("queryLanguage", QUERY_LANGUAGE_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("logGroupIdentifiers", LOG_GROUP_IDENTIFIERS_FIELD);
        map.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("startTimeOffset", START_TIME_OFFSET_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("scheduleStartTime", SCHEDULE_START_TIME_FIELD);
        map.put("scheduleEndTime", SCHEDULE_END_TIME_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledQueryRequest, T> g) {
        return obj -> g.apply((CreateScheduledQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateScheduledQueryRequest> {
        /**
         * <p>
         * A unique name for the scheduled query within the region for an AWS account. The name can contain letters,
         * numbers, underscores, hyphens, forward slashes, periods, and hash symbols.
         * </p>
         * 
         * @param name
         *        A unique name for the scheduled query within the region for an AWS account. The name can contain
         *        letters, numbers, underscores, hyphens, forward slashes, periods, and hash symbols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the scheduled query to help identify its purpose.
         * </p>
         * 
         * @param description
         *        An optional description for the scheduled query to help identify its purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The query language to use for the scheduled query. Valid values are LogsQL (CloudWatch Logs Insights query
         * language), PPL (OpenSearch Service Piped Processing Language), and SQL (OpenSearch Service Structured Query
         * Language).
         * </p>
         * 
         * @param queryLanguage
         *        The query language to use for the scheduled query. Valid values are LogsQL (CloudWatch Logs Insights
         *        query language), PPL (OpenSearch Service Piped Processing Language), and SQL (OpenSearch Service
         *        Structured Query Language).
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder queryLanguage(String queryLanguage);

        /**
         * <p>
         * The query language to use for the scheduled query. Valid values are LogsQL (CloudWatch Logs Insights query
         * language), PPL (OpenSearch Service Piped Processing Language), and SQL (OpenSearch Service Structured Query
         * Language).
         * </p>
         * 
         * @param queryLanguage
         *        The query language to use for the scheduled query. Valid values are LogsQL (CloudWatch Logs Insights
         *        query language), PPL (OpenSearch Service Piped Processing Language), and SQL (OpenSearch Service
         *        Structured Query Language).
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder queryLanguage(QueryLanguage queryLanguage);

        /**
         * <p>
         * The CloudWatch Logs Insights query string to execute. This is the actual query that will be run against your
         * log data on the specified schedule.
         * </p>
         * 
         * @param queryString
         *        The CloudWatch Logs Insights query string to execute. This is the actual query that will be run
         *        against your log data on the specified schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The log group identifiers to query. You can specify log group names or log group ARNs. If querying log groups
         * in a source account from a monitoring account, you must specify the ARN of the log group.
         * </p>
         * 
         * @param logGroupIdentifiers
         *        The log group identifiers to query. You can specify log group names or log group ARNs. If querying log
         *        groups in a source account from a monitoring account, you must specify the ARN of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers);

        /**
         * <p>
         * The log group identifiers to query. You can specify log group names or log group ARNs. If querying log groups
         * in a source account from a monitoring account, you must specify the ARN of the log group.
         * </p>
         * 
         * @param logGroupIdentifiers
         *        The log group identifiers to query. You can specify log group names or log group ARNs. If querying log
         *        groups in a source account from a monitoring account, you must specify the ARN of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifiers(String... logGroupIdentifiers);

        /**
         * <p>
         * A cron expression that defines when the scheduled query runs. The format is cron(fields) where fields consist
         * of six space-separated values: minutes, hours, day_of_month, month, day_of_week, year.
         * </p>
         * 
         * @param scheduleExpression
         *        A cron expression that defines when the scheduled query runs. The format is cron(fields) where fields
         *        consist of six space-separated values: minutes, hours, day_of_month, month, day_of_week, year.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * The timezone in which the schedule expression is evaluated. If not provided, defaults to UTC.
         * </p>
         * 
         * @param timezone
         *        The timezone in which the schedule expression is evaluated. If not provided, defaults to UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Time offset in seconds from the execution time for the start of the query time range. This defines the
         * lookback period for the query (for example, 3600 for the last hour).
         * </p>
         * 
         * @param startTimeOffset
         *        Time offset in seconds from the execution time for the start of the query time range. This defines the
         *        lookback period for the query (for example, 3600 for the last hour).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeOffset(Long startTimeOffset);

        /**
         * <p>
         * Configuration for destinations where the query results will be delivered after successful execution. You can
         * configure delivery to S3 buckets or EventBridge event buses.
         * </p>
         * 
         * @param destinationConfiguration
         *        Configuration for destinations where the query results will be delivered after successful execution.
         *        You can configure delivery to S3 buckets or EventBridge event buses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * Configuration for destinations where the query results will be delivered after successful execution. You can
         * configure delivery to S3 buckets or EventBridge event buses.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        /**
         * <p>
         * The start time for the query schedule in Unix epoch time (seconds since January 1, 1970, 00:00:00 UTC). If
         * not specified, the schedule starts immediately.
         * </p>
         * 
         * @param scheduleStartTime
         *        The start time for the query schedule in Unix epoch time (seconds since January 1, 1970, 00:00:00
         *        UTC). If not specified, the schedule starts immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleStartTime(Long scheduleStartTime);

        /**
         * <p>
         * The end time for the query schedule in Unix epoch time (seconds since January 1, 1970, 00:00:00 UTC). If not
         * specified, the schedule runs indefinitely.
         * </p>
         * 
         * @param scheduleEndTime
         *        The end time for the query schedule in Unix epoch time (seconds since January 1, 1970, 00:00:00 UTC).
         *        If not specified, the schedule runs indefinitely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleEndTime(Long scheduleEndTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that CloudWatch Logs will assume to execute the scheduled
         * query and deliver results to the specified destinations.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that CloudWatch Logs will assume to execute the
         *        scheduled query and deliver results to the specified destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The initial state of the scheduled query. Valid values are ENABLED (the query will run according to its
         * schedule) and DISABLED (the query is paused and will not run). If not provided, defaults to ENABLED.
         * </p>
         * 
         * @param state
         *        The initial state of the scheduled query. Valid values are ENABLED (the query will run according to
         *        its schedule) and DISABLED (the query is paused and will not run). If not provided, defaults to
         *        ENABLED.
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(String state);

        /**
         * <p>
         * The initial state of the scheduled query. Valid values are ENABLED (the query will run according to its
         * schedule) and DISABLED (the query is paused and will not run). If not provided, defaults to ENABLED.
         * </p>
         * 
         * @param state
         *        The initial state of the scheduled query. Valid values are ENABLED (the query will run according to
         *        its schedule) and DISABLED (the query is paused and will not run). If not provided, defaults to
         *        ENABLED.
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(ScheduledQueryState state);

        /**
         * <p>
         * An optional list of key-value pairs to associate with the resource.
         * </p>
         * <p>
         * For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a>
         * </p>
         * 
         * @param tags
         *        An optional list of key-value pairs to associate with the resource.</p>
         *        <p>
         *        For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String queryLanguage;

        private String queryString;

        private List<String> logGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String scheduleExpression;

        private String timezone;

        private Long startTimeOffset;

        private DestinationConfiguration destinationConfiguration;

        private Long scheduleStartTime;

        private Long scheduleEndTime;

        private String executionRoleArn;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledQueryRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            queryLanguage(model.queryLanguage);
            queryString(model.queryString);
            logGroupIdentifiers(model.logGroupIdentifiers);
            scheduleExpression(model.scheduleExpression);
            timezone(model.timezone);
            startTimeOffset(model.startTimeOffset);
            destinationConfiguration(model.destinationConfiguration);
            scheduleStartTime(model.scheduleStartTime);
            scheduleEndTime(model.scheduleEndTime);
            executionRoleArn(model.executionRoleArn);
            state(model.state);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryLanguage() {
            return queryLanguage;
        }

        public final void setQueryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
        }

        @Override
        public final Builder queryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        @Override
        public final Builder queryLanguage(QueryLanguage queryLanguage) {
            this.queryLanguage(queryLanguage == null ? null : queryLanguage.toString());
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Collection<String> getLogGroupIdentifiers() {
            if (logGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return logGroupIdentifiers;
        }

        public final void setLogGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = ScheduledQueryLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
        }

        @Override
        public final Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = ScheduledQueryLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupIdentifiers(String... logGroupIdentifiers) {
            logGroupIdentifiers(Arrays.asList(logGroupIdentifiers));
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Long getStartTimeOffset() {
            return startTimeOffset;
        }

        public final void setStartTimeOffset(Long startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
        }

        @Override
        public final Builder startTimeOffset(Long startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final Long getScheduleStartTime() {
            return scheduleStartTime;
        }

        public final void setScheduleStartTime(Long scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
        }

        @Override
        public final Builder scheduleStartTime(Long scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
            return this;
        }

        public final Long getScheduleEndTime() {
            return scheduleEndTime;
        }

        public final void setScheduleEndTime(Long scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
        }

        @Override
        public final Builder scheduleEndTime(Long scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduledQueryRequest build() {
            return new CreateScheduledQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
