/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScheduledQueryRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<UpdateScheduledQueryRequest.Builder, UpdateScheduledQueryRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateScheduledQueryRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateScheduledQueryRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> QUERY_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryLanguage").getter(getter(UpdateScheduledQueryRequest::queryLanguageAsString))
            .setter(setter(Builder::queryLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLanguage").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(UpdateScheduledQueryRequest::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<List<String>> LOG_GROUP_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logGroupIdentifiers")
            .getter(getter(UpdateScheduledQueryRequest::logGroupIdentifiers))
            .setter(setter(Builder::logGroupIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleExpression").getter(getter(UpdateScheduledQueryRequest::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build())
            .build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(UpdateScheduledQueryRequest::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final SdkField<Long> START_TIME_OFFSET_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startTimeOffset").getter(getter(UpdateScheduledQueryRequest::startTimeOffset))
            .setter(setter(Builder::startTimeOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeOffset").build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(UpdateScheduledQueryRequest::destinationConfiguration))
            .setter(setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final SdkField<Long> SCHEDULE_START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduleStartTime").getter(getter(UpdateScheduledQueryRequest::scheduleStartTime))
            .setter(setter(Builder::scheduleStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleStartTime").build()).build();

    private static final SdkField<Long> SCHEDULE_END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduleEndTime").getter(getter(UpdateScheduledQueryRequest::scheduleEndTime))
            .setter(setter(Builder::scheduleEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleEndTime").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(UpdateScheduledQueryRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(UpdateScheduledQueryRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, QUERY_LANGUAGE_FIELD, QUERY_STRING_FIELD, LOG_GROUP_IDENTIFIERS_FIELD, SCHEDULE_EXPRESSION_FIELD,
            TIMEZONE_FIELD, START_TIME_OFFSET_FIELD, DESTINATION_CONFIGURATION_FIELD, SCHEDULE_START_TIME_FIELD,
            SCHEDULE_END_TIME_FIELD, EXECUTION_ROLE_ARN_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String description;

    private final String queryLanguage;

    private final String queryString;

    private final List<String> logGroupIdentifiers;

    private final String scheduleExpression;

    private final String timezone;

    private final Long startTimeOffset;

    private final DestinationConfiguration destinationConfiguration;

    private final Long scheduleStartTime;

    private final Long scheduleEndTime;

    private final String executionRoleArn;

    private final String state;

    private UpdateScheduledQueryRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.queryLanguage = builder.queryLanguage;
        this.queryString = builder.queryString;
        this.logGroupIdentifiers = builder.logGroupIdentifiers;
        this.scheduleExpression = builder.scheduleExpression;
        this.timezone = builder.timezone;
        this.startTimeOffset = builder.startTimeOffset;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.scheduleStartTime = builder.scheduleStartTime;
        this.scheduleEndTime = builder.scheduleEndTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name or ARN of the scheduled query to update.
     * </p>
     * 
     * @return The name or ARN of the scheduled query to update.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Updated description for the scheduled query.
     * </p>
     * 
     * @return Updated description for the scheduled query.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Updated query language to use (LogsQL, PPL, or SQL).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLanguage}
     * will return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryLanguageAsString}.
     * </p>
     * 
     * @return Updated query language to use (LogsQL, PPL, or SQL).
     * @see QueryLanguage
     */
    public final QueryLanguage queryLanguage() {
        return QueryLanguage.fromValue(queryLanguage);
    }

    /**
     * <p>
     * Updated query language to use (LogsQL, PPL, or SQL).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLanguage}
     * will return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryLanguageAsString}.
     * </p>
     * 
     * @return Updated query language to use (LogsQL, PPL, or SQL).
     * @see QueryLanguage
     */
    public final String queryLanguageAsString() {
        return queryLanguage;
    }

    /**
     * <p>
     * Updated CloudWatch Logs Insights query string to execute.
     * </p>
     * 
     * @return Updated CloudWatch Logs Insights query string to execute.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroupIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogGroupIdentifiers() {
        return logGroupIdentifiers != null && !(logGroupIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updated log group identifiers to query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroupIdentifiers} method.
     * </p>
     * 
     * @return Updated log group identifiers to query.
     */
    public final List<String> logGroupIdentifiers() {
        return logGroupIdentifiers;
    }

    /**
     * <p>
     * Updated cron expression that defines when the scheduled query runs.
     * </p>
     * 
     * @return Updated cron expression that defines when the scheduled query runs.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Updated timezone in which the schedule expression is evaluated.
     * </p>
     * 
     * @return Updated timezone in which the schedule expression is evaluated.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Updated time offset in seconds from the execution time for the start of the query time range.
     * </p>
     * 
     * @return Updated time offset in seconds from the execution time for the start of the query time range.
     */
    public final Long startTimeOffset() {
        return startTimeOffset;
    }

    /**
     * <p>
     * Updated configuration for destinations where the query results will be delivered.
     * </p>
     * 
     * @return Updated configuration for destinations where the query results will be delivered.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * <p>
     * Updated start time for the query schedule in Unix epoch time.
     * </p>
     * 
     * @return Updated start time for the query schedule in Unix epoch time.
     */
    public final Long scheduleStartTime() {
        return scheduleStartTime;
    }

    /**
     * <p>
     * Updated end time for the query schedule in Unix epoch time.
     * </p>
     * 
     * @return Updated end time for the query schedule in Unix epoch time.
     */
    public final Long scheduleEndTime() {
        return scheduleEndTime;
    }

    /**
     * <p>
     * Updated ARN of the IAM role that CloudWatch Logs will assume to execute the scheduled query.
     * </p>
     * 
     * @return Updated ARN of the IAM role that CloudWatch Logs will assume to execute the scheduled query.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Updated state of the scheduled query (ENABLED or DISABLED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Updated state of the scheduled query (ENABLED or DISABLED).
     * @see ScheduledQueryState
     */
    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(state);
    }

    /**
     * <p>
     * Updated state of the scheduled query (ENABLED or DISABLED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Updated state of the scheduled query (ENABLED or DISABLED).
     * @see ScheduledQueryState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(queryLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupIdentifiers() ? logGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScheduledQueryRequest)) {
            return false;
        }
        UpdateScheduledQueryRequest other = (UpdateScheduledQueryRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(description(), other.description())
                && Objects.equals(queryLanguageAsString(), other.queryLanguageAsString())
                && Objects.equals(queryString(), other.queryString())
                && hasLogGroupIdentifiers() == other.hasLogGroupIdentifiers()
                && Objects.equals(logGroupIdentifiers(), other.logGroupIdentifiers())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(timezone(), other.timezone()) && Objects.equals(startTimeOffset(), other.startTimeOffset())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration())
                && Objects.equals(scheduleStartTime(), other.scheduleStartTime())
                && Objects.equals(scheduleEndTime(), other.scheduleEndTime())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateScheduledQueryRequest").add("Identifier", identifier()).add("Description", description())
                .add("QueryLanguage", queryLanguageAsString()).add("QueryString", queryString())
                .add("LogGroupIdentifiers", hasLogGroupIdentifiers() ? logGroupIdentifiers() : null)
                .add("ScheduleExpression", scheduleExpression()).add("Timezone", timezone())
                .add("StartTimeOffset", startTimeOffset()).add("DestinationConfiguration", destinationConfiguration())
                .add("ScheduleStartTime", scheduleStartTime()).add("ScheduleEndTime", scheduleEndTime())
                .add("ExecutionRoleArn", executionRoleArn()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "queryLanguage":
            return Optional.ofNullable(clazz.cast(queryLanguageAsString()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "logGroupIdentifiers":
            return Optional.ofNullable(clazz.cast(logGroupIdentifiers()));
        case "scheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "startTimeOffset":
            return Optional.ofNullable(clazz.cast(startTimeOffset()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "scheduleStartTime":
            return Optional.ofNullable(clazz.cast(scheduleStartTime()));
        case "scheduleEndTime":
            return Optional.ofNullable(clazz.cast(scheduleEndTime()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("queryLanguage", QUERY_LANGUAGE_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("logGroupIdentifiers", LOG_GROUP_IDENTIFIERS_FIELD);
        map.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("startTimeOffset", START_TIME_OFFSET_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("scheduleStartTime", SCHEDULE_START_TIME_FIELD);
        map.put("scheduleEndTime", SCHEDULE_END_TIME_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScheduledQueryRequest, T> g) {
        return obj -> g.apply((UpdateScheduledQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateScheduledQueryRequest> {
        /**
         * <p>
         * The name or ARN of the scheduled query to update.
         * </p>
         * 
         * @param identifier
         *        The name or ARN of the scheduled query to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Updated description for the scheduled query.
         * </p>
         * 
         * @param description
         *        Updated description for the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Updated query language to use (LogsQL, PPL, or SQL).
         * </p>
         * 
         * @param queryLanguage
         *        Updated query language to use (LogsQL, PPL, or SQL).
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder queryLanguage(String queryLanguage);

        /**
         * <p>
         * Updated query language to use (LogsQL, PPL, or SQL).
         * </p>
         * 
         * @param queryLanguage
         *        Updated query language to use (LogsQL, PPL, or SQL).
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder queryLanguage(QueryLanguage queryLanguage);

        /**
         * <p>
         * Updated CloudWatch Logs Insights query string to execute.
         * </p>
         * 
         * @param queryString
         *        Updated CloudWatch Logs Insights query string to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * Updated log group identifiers to query.
         * </p>
         * 
         * @param logGroupIdentifiers
         *        Updated log group identifiers to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers);

        /**
         * <p>
         * Updated log group identifiers to query.
         * </p>
         * 
         * @param logGroupIdentifiers
         *        Updated log group identifiers to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifiers(String... logGroupIdentifiers);

        /**
         * <p>
         * Updated cron expression that defines when the scheduled query runs.
         * </p>
         * 
         * @param scheduleExpression
         *        Updated cron expression that defines when the scheduled query runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Updated timezone in which the schedule expression is evaluated.
         * </p>
         * 
         * @param timezone
         *        Updated timezone in which the schedule expression is evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Updated time offset in seconds from the execution time for the start of the query time range.
         * </p>
         * 
         * @param startTimeOffset
         *        Updated time offset in seconds from the execution time for the start of the query time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeOffset(Long startTimeOffset);

        /**
         * <p>
         * Updated configuration for destinations where the query results will be delivered.
         * </p>
         * 
         * @param destinationConfiguration
         *        Updated configuration for destinations where the query results will be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * Updated configuration for destinations where the query results will be delivered.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        /**
         * <p>
         * Updated start time for the query schedule in Unix epoch time.
         * </p>
         * 
         * @param scheduleStartTime
         *        Updated start time for the query schedule in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleStartTime(Long scheduleStartTime);

        /**
         * <p>
         * Updated end time for the query schedule in Unix epoch time.
         * </p>
         * 
         * @param scheduleEndTime
         *        Updated end time for the query schedule in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleEndTime(Long scheduleEndTime);

        /**
         * <p>
         * Updated ARN of the IAM role that CloudWatch Logs will assume to execute the scheduled query.
         * </p>
         * 
         * @param executionRoleArn
         *        Updated ARN of the IAM role that CloudWatch Logs will assume to execute the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Updated state of the scheduled query (ENABLED or DISABLED).
         * </p>
         * 
         * @param state
         *        Updated state of the scheduled query (ENABLED or DISABLED).
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(String state);

        /**
         * <p>
         * Updated state of the scheduled query (ENABLED or DISABLED).
         * </p>
         * 
         * @param state
         *        Updated state of the scheduled query (ENABLED or DISABLED).
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(ScheduledQueryState state);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String identifier;

        private String description;

        private String queryLanguage;

        private String queryString;

        private List<String> logGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String scheduleExpression;

        private String timezone;

        private Long startTimeOffset;

        private DestinationConfiguration destinationConfiguration;

        private Long scheduleStartTime;

        private Long scheduleEndTime;

        private String executionRoleArn;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScheduledQueryRequest model) {
            super(model);
            identifier(model.identifier);
            description(model.description);
            queryLanguage(model.queryLanguage);
            queryString(model.queryString);
            logGroupIdentifiers(model.logGroupIdentifiers);
            scheduleExpression(model.scheduleExpression);
            timezone(model.timezone);
            startTimeOffset(model.startTimeOffset);
            destinationConfiguration(model.destinationConfiguration);
            scheduleStartTime(model.scheduleStartTime);
            scheduleEndTime(model.scheduleEndTime);
            executionRoleArn(model.executionRoleArn);
            state(model.state);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryLanguage() {
            return queryLanguage;
        }

        public final void setQueryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
        }

        @Override
        public final Builder queryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        @Override
        public final Builder queryLanguage(QueryLanguage queryLanguage) {
            this.queryLanguage(queryLanguage == null ? null : queryLanguage.toString());
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Collection<String> getLogGroupIdentifiers() {
            if (logGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return logGroupIdentifiers;
        }

        public final void setLogGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = ScheduledQueryLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
        }

        @Override
        public final Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = ScheduledQueryLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupIdentifiers(String... logGroupIdentifiers) {
            logGroupIdentifiers(Arrays.asList(logGroupIdentifiers));
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Long getStartTimeOffset() {
            return startTimeOffset;
        }

        public final void setStartTimeOffset(Long startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
        }

        @Override
        public final Builder startTimeOffset(Long startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final Long getScheduleStartTime() {
            return scheduleStartTime;
        }

        public final void setScheduleStartTime(Long scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
        }

        @Override
        public final Builder scheduleStartTime(Long scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
            return this;
        }

        public final Long getScheduleEndTime() {
            return scheduleEndTime;
        }

        public final void setScheduleEndTime(Long scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
        }

        @Override
        public final Builder scheduleEndTime(Long scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScheduledQueryRequest build() {
            return new UpdateScheduledQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
