/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScheduledQueryHistoryResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetScheduledQueryHistoryResponse.Builder, GetScheduledQueryHistoryResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetScheduledQueryHistoryResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SCHEDULED_QUERY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledQueryArn").getter(getter(GetScheduledQueryHistoryResponse::scheduledQueryArn))
            .setter(setter(Builder::scheduledQueryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledQueryArn").build()).build();

    private static final SdkField<List<TriggerHistoryRecord>> TRIGGER_HISTORY_FIELD = SdkField
            .<List<TriggerHistoryRecord>> builder(MarshallingType.LIST)
            .memberName("triggerHistory")
            .getter(getter(GetScheduledQueryHistoryResponse::triggerHistory))
            .setter(setter(Builder::triggerHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerHistory").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TriggerHistoryRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(TriggerHistoryRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetScheduledQueryHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SCHEDULED_QUERY_ARN_FIELD, TRIGGER_HISTORY_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String scheduledQueryArn;

    private final List<TriggerHistoryRecord> triggerHistory;

    private final String nextToken;

    private GetScheduledQueryHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scheduledQueryArn = builder.scheduledQueryArn;
        this.triggerHistory = builder.triggerHistory;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the scheduled query.
     * </p>
     * 
     * @return The name of the scheduled query.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the scheduled query.
     * </p>
     * 
     * @return The ARN of the scheduled query.
     */
    public final String scheduledQueryArn() {
        return scheduledQueryArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TriggerHistory property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTriggerHistory() {
        return triggerHistory != null && !(triggerHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of execution history records for the scheduled query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggerHistory} method.
     * </p>
     * 
     * @return The list of execution history records for the scheduled query.
     */
    public final List<TriggerHistoryRecord> triggerHistory() {
        return triggerHistory;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledQueryArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggerHistory() ? triggerHistory() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScheduledQueryHistoryResponse)) {
            return false;
        }
        GetScheduledQueryHistoryResponse other = (GetScheduledQueryHistoryResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scheduledQueryArn(), other.scheduledQueryArn())
                && hasTriggerHistory() == other.hasTriggerHistory() && Objects.equals(triggerHistory(), other.triggerHistory())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScheduledQueryHistoryResponse").add("Name", name())
                .add("ScheduledQueryArn", scheduledQueryArn())
                .add("TriggerHistory", hasTriggerHistory() ? triggerHistory() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "scheduledQueryArn":
            return Optional.ofNullable(clazz.cast(scheduledQueryArn()));
        case "triggerHistory":
            return Optional.ofNullable(clazz.cast(triggerHistory()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("scheduledQueryArn", SCHEDULED_QUERY_ARN_FIELD);
        map.put("triggerHistory", TRIGGER_HISTORY_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScheduledQueryHistoryResponse, T> g) {
        return obj -> g.apply((GetScheduledQueryHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetScheduledQueryHistoryResponse> {
        /**
         * <p>
         * The name of the scheduled query.
         * </p>
         * 
         * @param name
         *        The name of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the scheduled query.
         * </p>
         * 
         * @param scheduledQueryArn
         *        The ARN of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQueryArn(String scheduledQueryArn);

        /**
         * <p>
         * The list of execution history records for the scheduled query.
         * </p>
         * 
         * @param triggerHistory
         *        The list of execution history records for the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerHistory(Collection<TriggerHistoryRecord> triggerHistory);

        /**
         * <p>
         * The list of execution history records for the scheduled query.
         * </p>
         * 
         * @param triggerHistory
         *        The list of execution history records for the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerHistory(TriggerHistoryRecord... triggerHistory);

        /**
         * <p>
         * The list of execution history records for the scheduled query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TriggerHistoryRecord.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TriggerHistoryRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TriggerHistoryRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #triggerHistory(List<TriggerHistoryRecord>)}.
         * 
         * @param triggerHistory
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.TriggerHistoryRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerHistory(java.util.Collection<TriggerHistoryRecord>)
         */
        Builder triggerHistory(Consumer<TriggerHistoryRecord.Builder>... triggerHistory);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String name;

        private String scheduledQueryArn;

        private List<TriggerHistoryRecord> triggerHistory = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScheduledQueryHistoryResponse model) {
            super(model);
            name(model.name);
            scheduledQueryArn(model.scheduledQueryArn);
            triggerHistory(model.triggerHistory);
            nextToken(model.nextToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScheduledQueryArn() {
            return scheduledQueryArn;
        }

        public final void setScheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
        }

        @Override
        public final Builder scheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        public final List<TriggerHistoryRecord.Builder> getTriggerHistory() {
            List<TriggerHistoryRecord.Builder> result = TriggerHistoryRecordListCopier.copyToBuilder(this.triggerHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggerHistory(Collection<TriggerHistoryRecord.BuilderImpl> triggerHistory) {
            this.triggerHistory = TriggerHistoryRecordListCopier.copyFromBuilder(triggerHistory);
        }

        @Override
        public final Builder triggerHistory(Collection<TriggerHistoryRecord> triggerHistory) {
            this.triggerHistory = TriggerHistoryRecordListCopier.copy(triggerHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerHistory(TriggerHistoryRecord... triggerHistory) {
            triggerHistory(Arrays.asList(triggerHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerHistory(Consumer<TriggerHistoryRecord.Builder>... triggerHistory) {
            triggerHistory(Stream.of(triggerHistory).map(c -> TriggerHistoryRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetScheduledQueryHistoryResponse build() {
            return new GetScheduledQueryHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
