/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScheduledQueryResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetScheduledQueryResponse.Builder, GetScheduledQueryResponse> {
    private static final SdkField<String> SCHEDULED_QUERY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledQueryArn").getter(getter(GetScheduledQueryResponse::scheduledQueryArn))
            .setter(setter(Builder::scheduledQueryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledQueryArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetScheduledQueryResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetScheduledQueryResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> QUERY_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryLanguage").getter(getter(GetScheduledQueryResponse::queryLanguageAsString))
            .setter(setter(Builder::queryLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLanguage").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(GetScheduledQueryResponse::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<List<String>> LOG_GROUP_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logGroupIdentifiers")
            .getter(getter(GetScheduledQueryResponse::logGroupIdentifiers))
            .setter(setter(Builder::logGroupIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleExpression").getter(getter(GetScheduledQueryResponse::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build())
            .build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(GetScheduledQueryResponse::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final SdkField<Long> START_TIME_OFFSET_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startTimeOffset").getter(getter(GetScheduledQueryResponse::startTimeOffset))
            .setter(setter(Builder::startTimeOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeOffset").build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(GetScheduledQueryResponse::destinationConfiguration))
            .setter(setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(GetScheduledQueryResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Long> LAST_TRIGGERED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastTriggeredTime").getter(getter(GetScheduledQueryResponse::lastTriggeredTime))
            .setter(setter(Builder::lastTriggeredTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTriggeredTime").build()).build();

    private static final SdkField<String> LAST_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastExecutionStatus").getter(getter(GetScheduledQueryResponse::lastExecutionStatusAsString))
            .setter(setter(Builder::lastExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastExecutionStatus").build())
            .build();

    private static final SdkField<Long> SCHEDULE_START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduleStartTime").getter(getter(GetScheduledQueryResponse::scheduleStartTime))
            .setter(setter(Builder::scheduleStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleStartTime").build()).build();

    private static final SdkField<Long> SCHEDULE_END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduleEndTime").getter(getter(GetScheduledQueryResponse::scheduleEndTime))
            .setter(setter(Builder::scheduleEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleEndTime").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(GetScheduledQueryResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("creationTime").getter(getter(GetScheduledQueryResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastUpdatedTime").getter(getter(GetScheduledQueryResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERY_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, QUERY_LANGUAGE_FIELD, QUERY_STRING_FIELD, LOG_GROUP_IDENTIFIERS_FIELD,
            SCHEDULE_EXPRESSION_FIELD, TIMEZONE_FIELD, START_TIME_OFFSET_FIELD, DESTINATION_CONFIGURATION_FIELD, STATE_FIELD,
            LAST_TRIGGERED_TIME_FIELD, LAST_EXECUTION_STATUS_FIELD, SCHEDULE_START_TIME_FIELD, SCHEDULE_END_TIME_FIELD,
            EXECUTION_ROLE_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scheduledQueryArn;

    private final String name;

    private final String description;

    private final String queryLanguage;

    private final String queryString;

    private final List<String> logGroupIdentifiers;

    private final String scheduleExpression;

    private final String timezone;

    private final Long startTimeOffset;

    private final DestinationConfiguration destinationConfiguration;

    private final String state;

    private final Long lastTriggeredTime;

    private final String lastExecutionStatus;

    private final Long scheduleStartTime;

    private final Long scheduleEndTime;

    private final String executionRoleArn;

    private final Long creationTime;

    private final Long lastUpdatedTime;

    private GetScheduledQueryResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledQueryArn = builder.scheduledQueryArn;
        this.name = builder.name;
        this.description = builder.description;
        this.queryLanguage = builder.queryLanguage;
        this.queryString = builder.queryString;
        this.logGroupIdentifiers = builder.logGroupIdentifiers;
        this.scheduleExpression = builder.scheduleExpression;
        this.timezone = builder.timezone;
        this.startTimeOffset = builder.startTimeOffset;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.state = builder.state;
        this.lastTriggeredTime = builder.lastTriggeredTime;
        this.lastExecutionStatus = builder.lastExecutionStatus;
        this.scheduleStartTime = builder.scheduleStartTime;
        this.scheduleEndTime = builder.scheduleEndTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scheduled query.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scheduled query.
     */
    public final String scheduledQueryArn() {
        return scheduledQueryArn;
    }

    /**
     * <p>
     * The name of the scheduled query.
     * </p>
     * 
     * @return The name of the scheduled query.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the scheduled query.
     * </p>
     * 
     * @return The description of the scheduled query.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The query language used by the scheduled query (LogsQL, PPL, or SQL).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLanguage}
     * will return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryLanguageAsString}.
     * </p>
     * 
     * @return The query language used by the scheduled query (LogsQL, PPL, or SQL).
     * @see QueryLanguage
     */
    public final QueryLanguage queryLanguage() {
        return QueryLanguage.fromValue(queryLanguage);
    }

    /**
     * <p>
     * The query language used by the scheduled query (LogsQL, PPL, or SQL).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLanguage}
     * will return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryLanguageAsString}.
     * </p>
     * 
     * @return The query language used by the scheduled query (LogsQL, PPL, or SQL).
     * @see QueryLanguage
     */
    public final String queryLanguageAsString() {
        return queryLanguage;
    }

    /**
     * <p>
     * The CloudWatch Logs Insights query string being executed.
     * </p>
     * 
     * @return The CloudWatch Logs Insights query string being executed.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroupIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogGroupIdentifiers() {
        return logGroupIdentifiers != null && !(logGroupIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log group identifiers being queried by the scheduled query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroupIdentifiers} method.
     * </p>
     * 
     * @return The log group identifiers being queried by the scheduled query.
     */
    public final List<String> logGroupIdentifiers() {
        return logGroupIdentifiers;
    }

    /**
     * <p>
     * The cron expression that defines when the scheduled query runs.
     * </p>
     * 
     * @return The cron expression that defines when the scheduled query runs.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * The timezone in which the schedule expression is evaluated.
     * </p>
     * 
     * @return The timezone in which the schedule expression is evaluated.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Time offset in seconds from the execution time for the start of the query time range.
     * </p>
     * 
     * @return Time offset in seconds from the execution time for the start of the query time range.
     */
    public final Long startTimeOffset() {
        return startTimeOffset;
    }

    /**
     * <p>
     * Configuration for destinations where the query results are delivered.
     * </p>
     * 
     * @return Configuration for destinations where the query results are delivered.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * <p>
     * The current state of the scheduled query (ENABLED or DISABLED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the scheduled query (ENABLED or DISABLED).
     * @see ScheduledQueryState
     */
    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the scheduled query (ENABLED or DISABLED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the scheduled query (ENABLED or DISABLED).
     * @see ScheduledQueryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time when the scheduled query was last executed, in Unix epoch time.
     * </p>
     * 
     * @return The time when the scheduled query was last executed, in Unix epoch time.
     */
    public final Long lastTriggeredTime() {
        return lastTriggeredTime;
    }

    /**
     * <p>
     * The status of the last executed query (Running, Complete, Failed, Timeout, or InvalidQuery).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastExecutionStatus} will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #lastExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the last executed query (Running, Complete, Failed, Timeout, or InvalidQuery).
     * @see ExecutionStatus
     */
    public final ExecutionStatus lastExecutionStatus() {
        return ExecutionStatus.fromValue(lastExecutionStatus);
    }

    /**
     * <p>
     * The status of the last executed query (Running, Complete, Failed, Timeout, or InvalidQuery).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastExecutionStatus} will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #lastExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the last executed query (Running, Complete, Failed, Timeout, or InvalidQuery).
     * @see ExecutionStatus
     */
    public final String lastExecutionStatusAsString() {
        return lastExecutionStatus;
    }

    /**
     * <p>
     * The start time for the query schedule in Unix epoch time.
     * </p>
     * 
     * @return The start time for the query schedule in Unix epoch time.
     */
    public final Long scheduleStartTime() {
        return scheduleStartTime;
    }

    /**
     * <p>
     * The end time for the query schedule in Unix epoch time.
     * </p>
     * 
     * @return The end time for the query schedule in Unix epoch time.
     */
    public final Long scheduleEndTime() {
        return scheduleEndTime;
    }

    /**
     * <p>
     * The ARN of the IAM role used to execute the scheduled query.
     * </p>
     * 
     * @return The ARN of the IAM role used to execute the scheduled query.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The time when the scheduled query was created, in Unix epoch time.
     * </p>
     * 
     * @return The time when the scheduled query was created, in Unix epoch time.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the scheduled query was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The time when the scheduled query was last updated, in Unix epoch time.
     */
    public final Long lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledQueryArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(queryLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupIdentifiers() ? logGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastTriggeredTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScheduledQueryResponse)) {
            return false;
        }
        GetScheduledQueryResponse other = (GetScheduledQueryResponse) obj;
        return Objects.equals(scheduledQueryArn(), other.scheduledQueryArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(queryLanguageAsString(), other.queryLanguageAsString())
                && Objects.equals(queryString(), other.queryString())
                && hasLogGroupIdentifiers() == other.hasLogGroupIdentifiers()
                && Objects.equals(logGroupIdentifiers(), other.logGroupIdentifiers())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(timezone(), other.timezone()) && Objects.equals(startTimeOffset(), other.startTimeOffset())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(lastTriggeredTime(), other.lastTriggeredTime())
                && Objects.equals(lastExecutionStatusAsString(), other.lastExecutionStatusAsString())
                && Objects.equals(scheduleStartTime(), other.scheduleStartTime())
                && Objects.equals(scheduleEndTime(), other.scheduleEndTime())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScheduledQueryResponse").add("ScheduledQueryArn", scheduledQueryArn()).add("Name", name())
                .add("Description", description()).add("QueryLanguage", queryLanguageAsString())
                .add("QueryString", queryString())
                .add("LogGroupIdentifiers", hasLogGroupIdentifiers() ? logGroupIdentifiers() : null)
                .add("ScheduleExpression", scheduleExpression()).add("Timezone", timezone())
                .add("StartTimeOffset", startTimeOffset()).add("DestinationConfiguration", destinationConfiguration())
                .add("State", stateAsString()).add("LastTriggeredTime", lastTriggeredTime())
                .add("LastExecutionStatus", lastExecutionStatusAsString()).add("ScheduleStartTime", scheduleStartTime())
                .add("ScheduleEndTime", scheduleEndTime()).add("ExecutionRoleArn", executionRoleArn())
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledQueryArn":
            return Optional.ofNullable(clazz.cast(scheduledQueryArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "queryLanguage":
            return Optional.ofNullable(clazz.cast(queryLanguageAsString()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "logGroupIdentifiers":
            return Optional.ofNullable(clazz.cast(logGroupIdentifiers()));
        case "scheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "startTimeOffset":
            return Optional.ofNullable(clazz.cast(startTimeOffset()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "lastTriggeredTime":
            return Optional.ofNullable(clazz.cast(lastTriggeredTime()));
        case "lastExecutionStatus":
            return Optional.ofNullable(clazz.cast(lastExecutionStatusAsString()));
        case "scheduleStartTime":
            return Optional.ofNullable(clazz.cast(scheduleStartTime()));
        case "scheduleEndTime":
            return Optional.ofNullable(clazz.cast(scheduleEndTime()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scheduledQueryArn", SCHEDULED_QUERY_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("queryLanguage", QUERY_LANGUAGE_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("logGroupIdentifiers", LOG_GROUP_IDENTIFIERS_FIELD);
        map.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("startTimeOffset", START_TIME_OFFSET_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("state", STATE_FIELD);
        map.put("lastTriggeredTime", LAST_TRIGGERED_TIME_FIELD);
        map.put("lastExecutionStatus", LAST_EXECUTION_STATUS_FIELD);
        map.put("scheduleStartTime", SCHEDULE_START_TIME_FIELD);
        map.put("scheduleEndTime", SCHEDULE_END_TIME_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScheduledQueryResponse, T> g) {
        return obj -> g.apply((GetScheduledQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetScheduledQueryResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scheduled query.
         * </p>
         * 
         * @param scheduledQueryArn
         *        The Amazon Resource Name (ARN) of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQueryArn(String scheduledQueryArn);

        /**
         * <p>
         * The name of the scheduled query.
         * </p>
         * 
         * @param name
         *        The name of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the scheduled query.
         * </p>
         * 
         * @param description
         *        The description of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The query language used by the scheduled query (LogsQL, PPL, or SQL).
         * </p>
         * 
         * @param queryLanguage
         *        The query language used by the scheduled query (LogsQL, PPL, or SQL).
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder queryLanguage(String queryLanguage);

        /**
         * <p>
         * The query language used by the scheduled query (LogsQL, PPL, or SQL).
         * </p>
         * 
         * @param queryLanguage
         *        The query language used by the scheduled query (LogsQL, PPL, or SQL).
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder queryLanguage(QueryLanguage queryLanguage);

        /**
         * <p>
         * The CloudWatch Logs Insights query string being executed.
         * </p>
         * 
         * @param queryString
         *        The CloudWatch Logs Insights query string being executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The log group identifiers being queried by the scheduled query.
         * </p>
         * 
         * @param logGroupIdentifiers
         *        The log group identifiers being queried by the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers);

        /**
         * <p>
         * The log group identifiers being queried by the scheduled query.
         * </p>
         * 
         * @param logGroupIdentifiers
         *        The log group identifiers being queried by the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifiers(String... logGroupIdentifiers);

        /**
         * <p>
         * The cron expression that defines when the scheduled query runs.
         * </p>
         * 
         * @param scheduleExpression
         *        The cron expression that defines when the scheduled query runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * The timezone in which the schedule expression is evaluated.
         * </p>
         * 
         * @param timezone
         *        The timezone in which the schedule expression is evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Time offset in seconds from the execution time for the start of the query time range.
         * </p>
         * 
         * @param startTimeOffset
         *        Time offset in seconds from the execution time for the start of the query time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeOffset(Long startTimeOffset);

        /**
         * <p>
         * Configuration for destinations where the query results are delivered.
         * </p>
         * 
         * @param destinationConfiguration
         *        Configuration for destinations where the query results are delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * Configuration for destinations where the query results are delivered.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        /**
         * <p>
         * The current state of the scheduled query (ENABLED or DISABLED).
         * </p>
         * 
         * @param state
         *        The current state of the scheduled query (ENABLED or DISABLED).
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the scheduled query (ENABLED or DISABLED).
         * </p>
         * 
         * @param state
         *        The current state of the scheduled query (ENABLED or DISABLED).
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(ScheduledQueryState state);

        /**
         * <p>
         * The time when the scheduled query was last executed, in Unix epoch time.
         * </p>
         * 
         * @param lastTriggeredTime
         *        The time when the scheduled query was last executed, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastTriggeredTime(Long lastTriggeredTime);

        /**
         * <p>
         * The status of the last executed query (Running, Complete, Failed, Timeout, or InvalidQuery).
         * </p>
         * 
         * @param lastExecutionStatus
         *        The status of the last executed query (Running, Complete, Failed, Timeout, or InvalidQuery).
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder lastExecutionStatus(String lastExecutionStatus);

        /**
         * <p>
         * The status of the last executed query (Running, Complete, Failed, Timeout, or InvalidQuery).
         * </p>
         * 
         * @param lastExecutionStatus
         *        The status of the last executed query (Running, Complete, Failed, Timeout, or InvalidQuery).
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder lastExecutionStatus(ExecutionStatus lastExecutionStatus);

        /**
         * <p>
         * The start time for the query schedule in Unix epoch time.
         * </p>
         * 
         * @param scheduleStartTime
         *        The start time for the query schedule in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleStartTime(Long scheduleStartTime);

        /**
         * <p>
         * The end time for the query schedule in Unix epoch time.
         * </p>
         * 
         * @param scheduleEndTime
         *        The end time for the query schedule in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleEndTime(Long scheduleEndTime);

        /**
         * <p>
         * The ARN of the IAM role used to execute the scheduled query.
         * </p>
         * 
         * @param executionRoleArn
         *        The ARN of the IAM role used to execute the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The time when the scheduled query was created, in Unix epoch time.
         * </p>
         * 
         * @param creationTime
         *        The time when the scheduled query was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The time when the scheduled query was last updated, in Unix epoch time.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the scheduled query was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Long lastUpdatedTime);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String scheduledQueryArn;

        private String name;

        private String description;

        private String queryLanguage;

        private String queryString;

        private List<String> logGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String scheduleExpression;

        private String timezone;

        private Long startTimeOffset;

        private DestinationConfiguration destinationConfiguration;

        private String state;

        private Long lastTriggeredTime;

        private String lastExecutionStatus;

        private Long scheduleStartTime;

        private Long scheduleEndTime;

        private String executionRoleArn;

        private Long creationTime;

        private Long lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScheduledQueryResponse model) {
            super(model);
            scheduledQueryArn(model.scheduledQueryArn);
            name(model.name);
            description(model.description);
            queryLanguage(model.queryLanguage);
            queryString(model.queryString);
            logGroupIdentifiers(model.logGroupIdentifiers);
            scheduleExpression(model.scheduleExpression);
            timezone(model.timezone);
            startTimeOffset(model.startTimeOffset);
            destinationConfiguration(model.destinationConfiguration);
            state(model.state);
            lastTriggeredTime(model.lastTriggeredTime);
            lastExecutionStatus(model.lastExecutionStatus);
            scheduleStartTime(model.scheduleStartTime);
            scheduleEndTime(model.scheduleEndTime);
            executionRoleArn(model.executionRoleArn);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getScheduledQueryArn() {
            return scheduledQueryArn;
        }

        public final void setScheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
        }

        @Override
        public final Builder scheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryLanguage() {
            return queryLanguage;
        }

        public final void setQueryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
        }

        @Override
        public final Builder queryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        @Override
        public final Builder queryLanguage(QueryLanguage queryLanguage) {
            this.queryLanguage(queryLanguage == null ? null : queryLanguage.toString());
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Collection<String> getLogGroupIdentifiers() {
            if (logGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return logGroupIdentifiers;
        }

        public final void setLogGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = ScheduledQueryLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
        }

        @Override
        public final Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = ScheduledQueryLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupIdentifiers(String... logGroupIdentifiers) {
            logGroupIdentifiers(Arrays.asList(logGroupIdentifiers));
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Long getStartTimeOffset() {
            return startTimeOffset;
        }

        public final void setStartTimeOffset(Long startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
        }

        @Override
        public final Builder startTimeOffset(Long startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Long getLastTriggeredTime() {
            return lastTriggeredTime;
        }

        public final void setLastTriggeredTime(Long lastTriggeredTime) {
            this.lastTriggeredTime = lastTriggeredTime;
        }

        @Override
        public final Builder lastTriggeredTime(Long lastTriggeredTime) {
            this.lastTriggeredTime = lastTriggeredTime;
            return this;
        }

        public final String getLastExecutionStatus() {
            return lastExecutionStatus;
        }

        public final void setLastExecutionStatus(String lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus;
        }

        @Override
        public final Builder lastExecutionStatus(String lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus;
            return this;
        }

        @Override
        public final Builder lastExecutionStatus(ExecutionStatus lastExecutionStatus) {
            this.lastExecutionStatus(lastExecutionStatus == null ? null : lastExecutionStatus.toString());
            return this;
        }

        public final Long getScheduleStartTime() {
            return scheduleStartTime;
        }

        public final void setScheduleStartTime(Long scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
        }

        @Override
        public final Builder scheduleStartTime(Long scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
            return this;
        }

        public final Long getScheduleEndTime() {
            return scheduleEndTime;
        }

        public final void setScheduleEndTime(Long scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
        }

        @Override
        public final Builder scheduleEndTime(Long scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public GetScheduledQueryResponse build() {
            return new GetScheduledQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
