/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a scheduled query, used in list operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledQuerySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledQuerySummary.Builder, ScheduledQuerySummary> {
    private static final SdkField<String> SCHEDULED_QUERY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledQueryArn").getter(getter(ScheduledQuerySummary::scheduledQueryArn))
            .setter(setter(Builder::scheduledQueryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledQueryArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ScheduledQuerySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ScheduledQuerySummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Long> LAST_TRIGGERED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastTriggeredTime").getter(getter(ScheduledQuerySummary::lastTriggeredTime))
            .setter(setter(Builder::lastTriggeredTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTriggeredTime").build()).build();

    private static final SdkField<String> LAST_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastExecutionStatus").getter(getter(ScheduledQuerySummary::lastExecutionStatusAsString))
            .setter(setter(Builder::lastExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastExecutionStatus").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleExpression").getter(getter(ScheduledQuerySummary::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build())
            .build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(ScheduledQuerySummary::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(ScheduledQuerySummary::destinationConfiguration)).setter(setter(Builder::destinationConfiguration))
            .constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("creationTime").getter(getter(ScheduledQuerySummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastUpdatedTime").getter(getter(ScheduledQuerySummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERY_ARN_FIELD,
            NAME_FIELD, STATE_FIELD, LAST_TRIGGERED_TIME_FIELD, LAST_EXECUTION_STATUS_FIELD, SCHEDULE_EXPRESSION_FIELD,
            TIMEZONE_FIELD, DESTINATION_CONFIGURATION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scheduledQueryArn;

    private final String name;

    private final String state;

    private final Long lastTriggeredTime;

    private final String lastExecutionStatus;

    private final String scheduleExpression;

    private final String timezone;

    private final DestinationConfiguration destinationConfiguration;

    private final Long creationTime;

    private final Long lastUpdatedTime;

    private ScheduledQuerySummary(BuilderImpl builder) {
        this.scheduledQueryArn = builder.scheduledQueryArn;
        this.name = builder.name;
        this.state = builder.state;
        this.lastTriggeredTime = builder.lastTriggeredTime;
        this.lastExecutionStatus = builder.lastExecutionStatus;
        this.scheduleExpression = builder.scheduleExpression;
        this.timezone = builder.timezone;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The ARN of the scheduled query.
     * </p>
     * 
     * @return The ARN of the scheduled query.
     */
    public final String scheduledQueryArn() {
        return scheduledQueryArn;
    }

    /**
     * <p>
     * The name of the scheduled query.
     * </p>
     * 
     * @return The name of the scheduled query.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current state of the scheduled query (ENABLED or DISABLED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the scheduled query (ENABLED or DISABLED).
     * @see ScheduledQueryState
     */
    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the scheduled query (ENABLED or DISABLED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the scheduled query (ENABLED or DISABLED).
     * @see ScheduledQueryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time when the scheduled query was last executed.
     * </p>
     * 
     * @return The time when the scheduled query was last executed.
     */
    public final Long lastTriggeredTime() {
        return lastTriggeredTime;
    }

    /**
     * <p>
     * The status of the last execution (Running, Complete, Failed, Timeout, or InvalidQuery).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastExecutionStatus} will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #lastExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the last execution (Running, Complete, Failed, Timeout, or InvalidQuery).
     * @see ExecutionStatus
     */
    public final ExecutionStatus lastExecutionStatus() {
        return ExecutionStatus.fromValue(lastExecutionStatus);
    }

    /**
     * <p>
     * The status of the last execution (Running, Complete, Failed, Timeout, or InvalidQuery).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastExecutionStatus} will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #lastExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the last execution (Running, Complete, Failed, Timeout, or InvalidQuery).
     * @see ExecutionStatus
     */
    public final String lastExecutionStatusAsString() {
        return lastExecutionStatus;
    }

    /**
     * <p>
     * The cron expression that defines when the scheduled query runs.
     * </p>
     * 
     * @return The cron expression that defines when the scheduled query runs.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * The timezone in which the schedule expression is evaluated.
     * </p>
     * 
     * @return The timezone in which the schedule expression is evaluated.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Configuration for destinations where the query results are delivered.
     * </p>
     * 
     * @return Configuration for destinations where the query results are delivered.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * <p>
     * The time when the scheduled query was created.
     * </p>
     * 
     * @return The time when the scheduled query was created.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the scheduled query was last updated.
     * </p>
     * 
     * @return The time when the scheduled query was last updated.
     */
    public final Long lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledQueryArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastTriggeredTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQuerySummary)) {
            return false;
        }
        ScheduledQuerySummary other = (ScheduledQuerySummary) obj;
        return Objects.equals(scheduledQueryArn(), other.scheduledQueryArn()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(lastTriggeredTime(), other.lastTriggeredTime())
                && Objects.equals(lastExecutionStatusAsString(), other.lastExecutionStatusAsString())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(timezone(), other.timezone())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledQuerySummary").add("ScheduledQueryArn", scheduledQueryArn()).add("Name", name())
                .add("State", stateAsString()).add("LastTriggeredTime", lastTriggeredTime())
                .add("LastExecutionStatus", lastExecutionStatusAsString()).add("ScheduleExpression", scheduleExpression())
                .add("Timezone", timezone()).add("DestinationConfiguration", destinationConfiguration())
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledQueryArn":
            return Optional.ofNullable(clazz.cast(scheduledQueryArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "lastTriggeredTime":
            return Optional.ofNullable(clazz.cast(lastTriggeredTime()));
        case "lastExecutionStatus":
            return Optional.ofNullable(clazz.cast(lastExecutionStatusAsString()));
        case "scheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scheduledQueryArn", SCHEDULED_QUERY_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("state", STATE_FIELD);
        map.put("lastTriggeredTime", LAST_TRIGGERED_TIME_FIELD);
        map.put("lastExecutionStatus", LAST_EXECUTION_STATUS_FIELD);
        map.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQuerySummary, T> g) {
        return obj -> g.apply((ScheduledQuerySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledQuerySummary> {
        /**
         * <p>
         * The ARN of the scheduled query.
         * </p>
         * 
         * @param scheduledQueryArn
         *        The ARN of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQueryArn(String scheduledQueryArn);

        /**
         * <p>
         * The name of the scheduled query.
         * </p>
         * 
         * @param name
         *        The name of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current state of the scheduled query (ENABLED or DISABLED).
         * </p>
         * 
         * @param state
         *        The current state of the scheduled query (ENABLED or DISABLED).
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the scheduled query (ENABLED or DISABLED).
         * </p>
         * 
         * @param state
         *        The current state of the scheduled query (ENABLED or DISABLED).
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(ScheduledQueryState state);

        /**
         * <p>
         * The time when the scheduled query was last executed.
         * </p>
         * 
         * @param lastTriggeredTime
         *        The time when the scheduled query was last executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastTriggeredTime(Long lastTriggeredTime);

        /**
         * <p>
         * The status of the last execution (Running, Complete, Failed, Timeout, or InvalidQuery).
         * </p>
         * 
         * @param lastExecutionStatus
         *        The status of the last execution (Running, Complete, Failed, Timeout, or InvalidQuery).
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder lastExecutionStatus(String lastExecutionStatus);

        /**
         * <p>
         * The status of the last execution (Running, Complete, Failed, Timeout, or InvalidQuery).
         * </p>
         * 
         * @param lastExecutionStatus
         *        The status of the last execution (Running, Complete, Failed, Timeout, or InvalidQuery).
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder lastExecutionStatus(ExecutionStatus lastExecutionStatus);

        /**
         * <p>
         * The cron expression that defines when the scheduled query runs.
         * </p>
         * 
         * @param scheduleExpression
         *        The cron expression that defines when the scheduled query runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * The timezone in which the schedule expression is evaluated.
         * </p>
         * 
         * @param timezone
         *        The timezone in which the schedule expression is evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Configuration for destinations where the query results are delivered.
         * </p>
         * 
         * @param destinationConfiguration
         *        Configuration for destinations where the query results are delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * Configuration for destinations where the query results are delivered.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        /**
         * <p>
         * The time when the scheduled query was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the scheduled query was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The time when the scheduled query was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the scheduled query was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Long lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String scheduledQueryArn;

        private String name;

        private String state;

        private Long lastTriggeredTime;

        private String lastExecutionStatus;

        private String scheduleExpression;

        private String timezone;

        private DestinationConfiguration destinationConfiguration;

        private Long creationTime;

        private Long lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQuerySummary model) {
            scheduledQueryArn(model.scheduledQueryArn);
            name(model.name);
            state(model.state);
            lastTriggeredTime(model.lastTriggeredTime);
            lastExecutionStatus(model.lastExecutionStatus);
            scheduleExpression(model.scheduleExpression);
            timezone(model.timezone);
            destinationConfiguration(model.destinationConfiguration);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getScheduledQueryArn() {
            return scheduledQueryArn;
        }

        public final void setScheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
        }

        @Override
        public final Builder scheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Long getLastTriggeredTime() {
            return lastTriggeredTime;
        }

        public final void setLastTriggeredTime(Long lastTriggeredTime) {
            this.lastTriggeredTime = lastTriggeredTime;
        }

        @Override
        public final Builder lastTriggeredTime(Long lastTriggeredTime) {
            this.lastTriggeredTime = lastTriggeredTime;
            return this;
        }

        public final String getLastExecutionStatus() {
            return lastExecutionStatus;
        }

        public final void setLastExecutionStatus(String lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus;
        }

        @Override
        public final Builder lastExecutionStatus(String lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus;
            return this;
        }

        @Override
        public final Builder lastExecutionStatus(ExecutionStatus lastExecutionStatus) {
            this.lastExecutionStatus(lastExecutionStatus == null ? null : lastExecutionStatus.toString());
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public ScheduledQuerySummary build() {
            return new ScheduledQuerySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
