/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a destination where scheduled query results are processed and delivered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledQueryDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledQueryDestination.Builder, ScheduledQueryDestination> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationType").getter(getter(ScheduledQueryDestination::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()).build();

    private static final SdkField<String> DESTINATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationIdentifier").getter(getter(ScheduledQueryDestination::destinationIdentifier))
            .setter(setter(Builder::destinationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ScheduledQueryDestination::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> PROCESSED_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("processedIdentifier").getter(getter(ScheduledQueryDestination::processedIdentifier))
            .setter(setter(Builder::processedIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processedIdentifier").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(ScheduledQueryDestination::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD,
            DESTINATION_IDENTIFIER_FIELD, STATUS_FIELD, PROCESSED_IDENTIFIER_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationType;

    private final String destinationIdentifier;

    private final String status;

    private final String processedIdentifier;

    private final String errorMessage;

    private ScheduledQueryDestination(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.destinationIdentifier = builder.destinationIdentifier;
        this.status = builder.status;
        this.processedIdentifier = builder.processedIdentifier;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The type of destination (S3).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link ScheduledQueryDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of destination (S3).
     * @see ScheduledQueryDestinationType
     */
    public final ScheduledQueryDestinationType destinationType() {
        return ScheduledQueryDestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * The type of destination (S3).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link ScheduledQueryDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of destination (S3).
     * @see ScheduledQueryDestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * The destination identifier (S3 URI).
     * </p>
     * 
     * @return The destination identifier (S3 URI).
     */
    public final String destinationIdentifier() {
        return destinationIdentifier;
    }

    /**
     * <p>
     * The processing status for this destination (IN_PROGRESS, ERROR, FAILED, or COMPLETE).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The processing status for this destination (IN_PROGRESS, ERROR, FAILED, or COMPLETE).
     * @see ActionStatus
     */
    public final ActionStatus status() {
        return ActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The processing status for this destination (IN_PROGRESS, ERROR, FAILED, or COMPLETE).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The processing status for this destination (IN_PROGRESS, ERROR, FAILED, or COMPLETE).
     * @see ActionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The processed identifier returned for the destination (S3 key).
     * </p>
     * 
     * @return The processed identifier returned for the destination (S3 key).
     */
    public final String processedIdentifier() {
        return processedIdentifier;
    }

    /**
     * <p>
     * Error message if the destination processing failed.
     * </p>
     * 
     * @return Error message if the destination processing failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(processedIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQueryDestination)) {
            return false;
        }
        ScheduledQueryDestination other = (ScheduledQueryDestination) obj;
        return Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(destinationIdentifier(), other.destinationIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(processedIdentifier(), other.processedIdentifier())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledQueryDestination").add("DestinationType", destinationTypeAsString())
                .add("DestinationIdentifier", destinationIdentifier()).add("Status", statusAsString())
                .add("ProcessedIdentifier", processedIdentifier()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "destinationIdentifier":
            return Optional.ofNullable(clazz.cast(destinationIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "processedIdentifier":
            return Optional.ofNullable(clazz.cast(processedIdentifier()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationType", DESTINATION_TYPE_FIELD);
        map.put("destinationIdentifier", DESTINATION_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("processedIdentifier", PROCESSED_IDENTIFIER_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQueryDestination, T> g) {
        return obj -> g.apply((ScheduledQueryDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledQueryDestination> {
        /**
         * <p>
         * The type of destination (S3).
         * </p>
         * 
         * @param destinationType
         *        The type of destination (S3).
         * @see ScheduledQueryDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryDestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * The type of destination (S3).
         * </p>
         * 
         * @param destinationType
         *        The type of destination (S3).
         * @see ScheduledQueryDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryDestinationType
         */
        Builder destinationType(ScheduledQueryDestinationType destinationType);

        /**
         * <p>
         * The destination identifier (S3 URI).
         * </p>
         * 
         * @param destinationIdentifier
         *        The destination identifier (S3 URI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIdentifier(String destinationIdentifier);

        /**
         * <p>
         * The processing status for this destination (IN_PROGRESS, ERROR, FAILED, or COMPLETE).
         * </p>
         * 
         * @param status
         *        The processing status for this destination (IN_PROGRESS, ERROR, FAILED, or COMPLETE).
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The processing status for this destination (IN_PROGRESS, ERROR, FAILED, or COMPLETE).
         * </p>
         * 
         * @param status
         *        The processing status for this destination (IN_PROGRESS, ERROR, FAILED, or COMPLETE).
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(ActionStatus status);

        /**
         * <p>
         * The processed identifier returned for the destination (S3 key).
         * </p>
         * 
         * @param processedIdentifier
         *        The processed identifier returned for the destination (S3 key).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedIdentifier(String processedIdentifier);

        /**
         * <p>
         * Error message if the destination processing failed.
         * </p>
         * 
         * @param errorMessage
         *        Error message if the destination processing failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String destinationType;

        private String destinationIdentifier;

        private String status;

        private String processedIdentifier;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQueryDestination model) {
            destinationType(model.destinationType);
            destinationIdentifier(model.destinationIdentifier);
            status(model.status);
            processedIdentifier(model.processedIdentifier);
            errorMessage(model.errorMessage);
        }

        public final String getDestinationType() {
            return destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(ScheduledQueryDestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getDestinationIdentifier() {
            return destinationIdentifier;
        }

        public final void setDestinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
        }

        @Override
        public final Builder destinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getProcessedIdentifier() {
            return processedIdentifier;
        }

        public final void setProcessedIdentifier(String processedIdentifier) {
            this.processedIdentifier = processedIdentifier;
        }

        @Override
        public final Builder processedIdentifier(String processedIdentifier) {
            this.processedIdentifier = processedIdentifier;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public ScheduledQueryDestination build() {
            return new ScheduledQueryDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
