/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScheduledQueryHistoryRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<GetScheduledQueryHistoryRequest.Builder, GetScheduledQueryHistoryRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(GetScheduledQueryHistoryRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<Long> START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startTime")
            .getter(getter(GetScheduledQueryHistoryRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Long> END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("endTime")
            .getter(getter(GetScheduledQueryHistoryRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<List<String>> EXECUTION_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("executionStatuses")
            .getter(getter(GetScheduledQueryHistoryRequest::executionStatusesAsStrings))
            .setter(setter(Builder::executionStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetScheduledQueryHistoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetScheduledQueryHistoryRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, EXECUTION_STATUSES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final Long startTime;

    private final Long endTime;

    private final List<String> executionStatuses;

    private final Integer maxResults;

    private final String nextToken;

    private GetScheduledQueryHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.executionStatuses = builder.executionStatuses;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name or ARN of the scheduled query to retrieve history for.
     * </p>
     * 
     * @return The name or ARN of the scheduled query to retrieve history for.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The start time for the history retrieval window in Unix epoch time.
     * </p>
     * 
     * @return The start time for the history retrieval window in Unix epoch time.
     */
    public final Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the history retrieval window in Unix epoch time.
     * </p>
     * 
     * @return The end time for the history retrieval window in Unix epoch time.
     */
    public final Long endTime() {
        return endTime;
    }

    /**
     * <p>
     * Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionStatuses} method.
     * </p>
     * 
     * @return Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
     */
    public final List<ExecutionStatus> executionStatuses() {
        return ExecutionStatusListCopier.copyStringToEnum(executionStatuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionStatuses() {
        return executionStatuses != null && !(executionStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionStatuses} method.
     * </p>
     * 
     * @return Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
     */
    public final List<String> executionStatusesAsStrings() {
        return executionStatuses;
    }

    /**
     * <p>
     * The maximum number of history records to return in a single call.
     * </p>
     * 
     * @return The maximum number of history records to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionStatuses() ? executionStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScheduledQueryHistoryRequest)) {
            return false;
        }
        GetScheduledQueryHistoryRequest other = (GetScheduledQueryHistoryRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && hasExecutionStatuses() == other.hasExecutionStatuses()
                && Objects.equals(executionStatusesAsStrings(), other.executionStatusesAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScheduledQueryHistoryRequest").add("Identifier", identifier()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("ExecutionStatuses", hasExecutionStatuses() ? executionStatusesAsStrings() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "executionStatuses":
            return Optional.ofNullable(clazz.cast(executionStatusesAsStrings()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("executionStatuses", EXECUTION_STATUSES_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScheduledQueryHistoryRequest, T> g) {
        return obj -> g.apply((GetScheduledQueryHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetScheduledQueryHistoryRequest> {
        /**
         * <p>
         * The name or ARN of the scheduled query to retrieve history for.
         * </p>
         * 
         * @param identifier
         *        The name or ARN of the scheduled query to retrieve history for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The start time for the history retrieval window in Unix epoch time.
         * </p>
         * 
         * @param startTime
         *        The start time for the history retrieval window in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * The end time for the history retrieval window in Unix epoch time.
         * </p>
         * 
         * @param endTime
         *        The end time for the history retrieval window in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Long endTime);

        /**
         * <p>
         * Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
         * </p>
         * 
         * @param executionStatuses
         *        Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatusesWithStrings(Collection<String> executionStatuses);

        /**
         * <p>
         * Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
         * </p>
         * 
         * @param executionStatuses
         *        Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatusesWithStrings(String... executionStatuses);

        /**
         * <p>
         * Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
         * </p>
         * 
         * @param executionStatuses
         *        Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatuses(Collection<ExecutionStatus> executionStatuses);

        /**
         * <p>
         * Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
         * </p>
         * 
         * @param executionStatuses
         *        Filter results by execution status (Running, Complete, Failed, Timeout, or InvalidQuery).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatuses(ExecutionStatus... executionStatuses);

        /**
         * <p>
         * The maximum number of history records to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of history records to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String identifier;

        private Long startTime;

        private Long endTime;

        private List<String> executionStatuses = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScheduledQueryHistoryRequest model) {
            super(model);
            identifier(model.identifier);
            startTime(model.startTime);
            endTime(model.endTime);
            executionStatusesWithStrings(model.executionStatuses);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Long getStartTime() {
            return startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getExecutionStatuses() {
            if (executionStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return executionStatuses;
        }

        public final void setExecutionStatuses(Collection<String> executionStatuses) {
            this.executionStatuses = ExecutionStatusListCopier.copy(executionStatuses);
        }

        @Override
        public final Builder executionStatusesWithStrings(Collection<String> executionStatuses) {
            this.executionStatuses = ExecutionStatusListCopier.copy(executionStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionStatusesWithStrings(String... executionStatuses) {
            executionStatusesWithStrings(Arrays.asList(executionStatuses));
            return this;
        }

        @Override
        public final Builder executionStatuses(Collection<ExecutionStatus> executionStatuses) {
            this.executionStatuses = ExecutionStatusListCopier.copyEnumToString(executionStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionStatuses(ExecutionStatus... executionStatuses) {
            executionStatuses(Arrays.asList(executionStatuses));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetScheduledQueryHistoryRequest build() {
            return new GetScheduledQueryHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
