/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTask implements SdkPojo, Serializable, ToCopyableBuilder<ExportTask.Builder, ExportTask> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportTask::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportTask::taskName)).setter(setter(Builder::taskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskName").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportTask::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Long> FROM_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ExportTask::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final SdkField<Long> TO_FIELD = SdkField.<Long> builder(MarshallingType.LONG).getter(getter(ExportTask::to))
            .setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportTask::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> DESTINATION_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportTask::destinationPrefix)).setter(setter(Builder::destinationPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPrefix").build()).build();

    private static final SdkField<ExportTaskStatus> STATUS_FIELD = SdkField.<ExportTaskStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExportTask::status)).setter(setter(Builder::status)).constructor(ExportTaskStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ExportTaskExecutionInfo> EXECUTION_INFO_FIELD = SdkField
            .<ExportTaskExecutionInfo> builder(MarshallingType.SDK_POJO).getter(getter(ExportTask::executionInfo))
            .setter(setter(Builder::executionInfo)).constructor(ExportTaskExecutionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            TASK_NAME_FIELD, LOG_GROUP_NAME_FIELD, FROM_FIELD, TO_FIELD, DESTINATION_FIELD, DESTINATION_PREFIX_FIELD,
            STATUS_FIELD, EXECUTION_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String taskName;

    private final String logGroupName;

    private final Long from;

    private final Long to;

    private final String destination;

    private final String destinationPrefix;

    private final ExportTaskStatus status;

    private final ExportTaskExecutionInfo executionInfo;

    private ExportTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskName = builder.taskName;
        this.logGroupName = builder.logGroupName;
        this.from = builder.from;
        this.to = builder.to;
        this.destination = builder.destination;
        this.destinationPrefix = builder.destinationPrefix;
        this.status = builder.status;
        this.executionInfo = builder.executionInfo;
    }

    /**
     * <p>
     * The ID of the export task.
     * </p>
     * 
     * @return The ID of the export task.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The name of the export task.
     * </p>
     * 
     * @return The name of the export task.
     */
    public String taskName() {
        return taskName;
    }

    /**
     * <p>
     * The name of the log group from which logs data was exported.
     * </p>
     * 
     * @return The name of the log group from which logs data was exported.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp
     * before this time are not exported.
     * </p>
     * 
     * @return The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a
     *         timestamp before this time are not exported.
     */
    public Long from() {
        return from;
    }

    /**
     * <p>
     * The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp
     * later than this time are not exported.
     * </p>
     * 
     * @return The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a
     *         timestamp later than this time are not exported.
     */
    public Long to() {
        return to;
    }

    /**
     * <p>
     * The name of Amazon S3 bucket to which the log data was exported.
     * </p>
     * 
     * @return The name of Amazon S3 bucket to which the log data was exported.
     */
    public String destination() {
        return destination;
    }

    /**
     * <p>
     * The prefix that was used as the start of Amazon S3 key for every object exported.
     * </p>
     * 
     * @return The prefix that was used as the start of Amazon S3 key for every object exported.
     */
    public String destinationPrefix() {
        return destinationPrefix;
    }

    /**
     * <p>
     * The status of the export task.
     * </p>
     * 
     * @return The status of the export task.
     */
    public ExportTaskStatus status() {
        return status;
    }

    /**
     * <p>
     * Execution info about the export task.
     * </p>
     * 
     * @return Execution info about the export task.
     */
    public ExportTaskExecutionInfo executionInfo() {
        return executionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(taskName());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(executionInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(taskName(), other.taskName())
                && Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(from(), other.from())
                && Objects.equals(to(), other.to()) && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationPrefix(), other.destinationPrefix()) && Objects.equals(status(), other.status())
                && Objects.equals(executionInfo(), other.executionInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportTask").add("TaskId", taskId()).add("TaskName", taskName())
                .add("LogGroupName", logGroupName()).add("From", from()).add("To", to()).add("Destination", destination())
                .add("DestinationPrefix", destinationPrefix()).add("Status", status()).add("ExecutionInfo", executionInfo())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "taskName":
            return Optional.ofNullable(clazz.cast(taskName()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        case "to":
            return Optional.ofNullable(clazz.cast(to()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "destinationPrefix":
            return Optional.ofNullable(clazz.cast(destinationPrefix()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "executionInfo":
            return Optional.ofNullable(clazz.cast(executionInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTask, T> g) {
        return obj -> g.apply((ExportTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportTask> {
        /**
         * <p>
         * The ID of the export task.
         * </p>
         * 
         * @param taskId
         *        The ID of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The name of the export task.
         * </p>
         * 
         * @param taskName
         *        The name of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskName(String taskName);

        /**
         * <p>
         * The name of the log group from which logs data was exported.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group from which logs data was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a
         * timestamp before this time are not exported.
         * </p>
         * 
         * @param from
         *        The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a
         *        timestamp before this time are not exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(Long from);

        /**
         * <p>
         * The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp
         * later than this time are not exported.
         * </p>
         * 
         * @param to
         *        The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a
         *        timestamp later than this time are not exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Long to);

        /**
         * <p>
         * The name of Amazon S3 bucket to which the log data was exported.
         * </p>
         * 
         * @param destination
         *        The name of Amazon S3 bucket to which the log data was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The prefix that was used as the start of Amazon S3 key for every object exported.
         * </p>
         * 
         * @param destinationPrefix
         *        The prefix that was used as the start of Amazon S3 key for every object exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefix(String destinationPrefix);

        /**
         * <p>
         * The status of the export task.
         * </p>
         * 
         * @param status
         *        The status of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ExportTaskStatus status);

        /**
         * <p>
         * The status of the export task.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportTaskStatus.Builder} avoiding the need to
         * create one manually via {@link ExportTaskStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportTaskStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ExportTaskStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ExportTaskStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ExportTaskStatus)
         */
        default Builder status(Consumer<ExportTaskStatus.Builder> status) {
            return status(ExportTaskStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Execution info about the export task.
         * </p>
         * 
         * @param executionInfo
         *        Execution info about the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfo(ExportTaskExecutionInfo executionInfo);

        /**
         * <p>
         * Execution info about the export task.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportTaskExecutionInfo.Builder} avoiding the
         * need to create one manually via {@link ExportTaskExecutionInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportTaskExecutionInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #executionInfo(ExportTaskExecutionInfo)}.
         * 
         * @param executionInfo
         *        a consumer that will call methods on {@link ExportTaskExecutionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionInfo(ExportTaskExecutionInfo)
         */
        default Builder executionInfo(Consumer<ExportTaskExecutionInfo.Builder> executionInfo) {
            return executionInfo(ExportTaskExecutionInfo.builder().applyMutation(executionInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String taskName;

        private String logGroupName;

        private Long from;

        private Long to;

        private String destination;

        private String destinationPrefix;

        private ExportTaskStatus status;

        private ExportTaskExecutionInfo executionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            taskId(model.taskId);
            taskName(model.taskName);
            logGroupName(model.logGroupName);
            from(model.from);
            to(model.to);
            destination(model.destination);
            destinationPrefix(model.destinationPrefix);
            status(model.status);
            executionInfo(model.executionInfo);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskName() {
            return taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getFrom() {
            return from;
        }

        @Override
        public final Builder from(Long from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Long from) {
            this.from = from;
        }

        public final Long getTo() {
            return to;
        }

        @Override
        public final Builder to(Long to) {
            this.to = to;
            return this;
        }

        public final void setTo(Long to) {
            this.to = to;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDestinationPrefix() {
            return destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        public final ExportTaskStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(ExportTaskStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ExportTaskStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final ExportTaskExecutionInfo.Builder getExecutionInfo() {
            return executionInfo != null ? executionInfo.toBuilder() : null;
        }

        @Override
        public final Builder executionInfo(ExportTaskExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public final void setExecutionInfo(ExportTaskExecutionInfo.BuilderImpl executionInfo) {
            this.executionInfo = executionInfo != null ? executionInfo.build() : null;
        }

        @Override
        public ExportTask build() {
            return new ExportTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
