/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetricFiltersResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeMetricFiltersResponse.Builder, DescribeMetricFiltersResponse> {
    private static final SdkField<List<MetricFilter>> METRIC_FILTERS_FIELD = SdkField
            .<List<MetricFilter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeMetricFiltersResponse::metricFilters))
            .setter(setter(Builder::metricFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMetricFiltersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FILTERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MetricFilter> metricFilters;

    private final String nextToken;

    private DescribeMetricFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.metricFilters = builder.metricFilters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The metric filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The metric filters.
     */
    public List<MetricFilter> metricFilters() {
        return metricFilters;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricFilters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricFiltersResponse)) {
            return false;
        }
        DescribeMetricFiltersResponse other = (DescribeMetricFiltersResponse) obj;
        return Objects.equals(metricFilters(), other.metricFilters()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMetricFiltersResponse").add("MetricFilters", metricFilters())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricFilters":
            return Optional.ofNullable(clazz.cast(metricFilters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricFiltersResponse, T> g) {
        return obj -> g.apply((DescribeMetricFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetricFiltersResponse> {
        /**
         * <p>
         * The metric filters.
         * </p>
         * 
         * @param metricFilters
         *        The metric filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricFilters(Collection<MetricFilter> metricFilters);

        /**
         * <p>
         * The metric filters.
         * </p>
         * 
         * @param metricFilters
         *        The metric filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricFilters(MetricFilter... metricFilters);

        /**
         * <p>
         * The metric filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricFilter>.Builder} avoiding the need to
         * create one manually via {@link List<MetricFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricFilters(List<MetricFilter>)}.
         * 
         * @param metricFilters
         *        a consumer that will call methods on {@link List<MetricFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricFilters(List<MetricFilter>)
         */
        Builder metricFilters(Consumer<MetricFilter.Builder>... metricFilters);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<MetricFilter> metricFilters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricFiltersResponse model) {
            super(model);
            metricFilters(model.metricFilters);
            nextToken(model.nextToken);
        }

        public final Collection<MetricFilter.Builder> getMetricFilters() {
            return metricFilters != null ? metricFilters.stream().map(MetricFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder metricFilters(Collection<MetricFilter> metricFilters) {
            this.metricFilters = MetricFiltersCopier.copy(metricFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(MetricFilter... metricFilters) {
            metricFilters(Arrays.asList(metricFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(Consumer<MetricFilter.Builder>... metricFilters) {
            metricFilters(Stream.of(metricFilters).map(c -> MetricFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricFilters(Collection<MetricFilter.BuilderImpl> metricFilters) {
            this.metricFilters = MetricFiltersCopier.copyFromBuilder(metricFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMetricFiltersResponse build() {
            return new DescribeMetricFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
