/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartQueryRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<StartQueryRequest.Builder, StartQueryRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartQueryRequest::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Long> START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(StartQueryRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Long> END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(StartQueryRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartQueryRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StartQueryRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, QUERY_STRING_FIELD, LIMIT_FIELD));

    private final String logGroupName;

    private final Long startTime;

    private final Long endTime;

    private final String queryString;

    private final Integer limit;

    private StartQueryRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.queryString = builder.queryString;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The log group on which to perform the query.
     * </p>
     * 
     * @return The log group on which to perform the query.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The beginning of the time range to query. The range is inclusive, so the specified start time is included in the
     * query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The beginning of the time range to query. The range is inclusive, so the specified start time is included
     *         in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
     */
    public Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time range to query. The range is inclusive, so the specified end time is included in the query.
     * Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The end of the time range to query. The range is inclusive, so the specified end time is included in the
     *         query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
     */
    public Long endTime() {
        return endTime;
    }

    /**
     * <p>
     * The query string to use. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights
     * Query Syntax</a>.
     * </p>
     * 
     * @return The query string to use. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs
     *         Insights Query Syntax</a>.
     */
    public String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The maximum number of log events to return in the query. If the query string uses the <code>fields</code>
     * command, only the specified fields and their values are returned.
     * </p>
     * 
     * @return The maximum number of log events to return in the query. If the query string uses the <code>fields</code>
     *         command, only the specified fields and their values are returned.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryRequest)) {
            return false;
        }
        StartQueryRequest other = (StartQueryRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartQueryRequest").add("LogGroupName", logGroupName()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("QueryString", queryString()).add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartQueryRequest, T> g) {
        return obj -> g.apply((StartQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartQueryRequest> {
        /**
         * <p>
         * The log group on which to perform the query.
         * </p>
         * 
         * @param logGroupName
         *        The log group on which to perform the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The beginning of the time range to query. The range is inclusive, so the specified start time is included in
         * the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param startTime
         *        The beginning of the time range to query. The range is inclusive, so the specified start time is
         *        included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00
         *        UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * The end of the time range to query. The range is inclusive, so the specified end time is included in the
         * query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param endTime
         *        The end of the time range to query. The range is inclusive, so the specified end time is included in
         *        the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Long endTime);

        /**
         * <p>
         * The query string to use. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights
         * Query Syntax</a>.
         * </p>
         * 
         * @param queryString
         *        The query string to use. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs
         *        Insights Query Syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The maximum number of log events to return in the query. If the query string uses the <code>fields</code>
         * command, only the specified fields and their values are returned.
         * </p>
         * 
         * @param limit
         *        The maximum number of log events to return in the query. If the query string uses the
         *        <code>fields</code> command, only the specified fields and their values are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private Long startTime;

        private Long endTime;

        private String queryString;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            startTime(model.startTime);
            endTime(model.endTime);
            queryString(model.queryString);
            limit(model.limit);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public final Long getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryRequest build() {
            return new StartQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
