/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutLogEventsRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutLogEventsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutLogEventsRequest.getter(PutLogEventsRequest::logGroupName)).setter(PutLogEventsRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutLogEventsRequest.getter(PutLogEventsRequest::logStreamName)).setter(PutLogEventsRequest.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()}).build();
    private static final SdkField<List<InputLogEvent>> LOG_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutLogEventsRequest.getter(PutLogEventsRequest::logEvents)).setter(PutLogEventsRequest.setter(Builder::logEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputLogEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SEQUENCE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutLogEventsRequest.getter(PutLogEventsRequest::sequenceToken)).setter(PutLogEventsRequest.setter(Builder::sequenceToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, LOG_STREAM_NAME_FIELD, LOG_EVENTS_FIELD, SEQUENCE_TOKEN_FIELD));
    private final String logGroupName;
    private final String logStreamName;
    private final List<InputLogEvent> logEvents;
    private final String sequenceToken;

    private PutLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
        this.logEvents = builder.logEvents;
        this.sequenceToken = builder.sequenceToken;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public List<InputLogEvent> logEvents() {
        return this.logEvents;
    }

    public String sequenceToken() {
        return this.sequenceToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsRequest)) {
            return false;
        }
        PutLogEventsRequest other = (PutLogEventsRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.logEvents(), other.logEvents()) && Objects.equals(this.sequenceToken(), other.sequenceToken());
    }

    public String toString() {
        return ToString.builder((String)"PutLogEventsRequest").add("LogGroupName", (Object)this.logGroupName()).add("LogStreamName", (Object)this.logStreamName()).add("LogEvents", this.logEvents()).add("SequenceToken", (Object)this.sequenceToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "logEvents": {
                return Optional.ofNullable(clazz.cast(this.logEvents()));
            }
            case "sequenceToken": {
                return Optional.ofNullable(clazz.cast(this.sequenceToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLogEventsRequest, T> g) {
        return obj -> g.apply((PutLogEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logStreamName;
        private List<InputLogEvent> logEvents = DefaultSdkAutoConstructList.getInstance();
        private String sequenceToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLogEventsRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.logStreamName(model.logStreamName);
            this.logEvents(model.logEvents);
            this.sequenceToken(model.sequenceToken);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Collection<InputLogEvent.Builder> getLogEvents() {
            return this.logEvents != null ? (Collection)this.logEvents.stream().map(InputLogEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logEvents(Collection<InputLogEvent> logEvents) {
            this.logEvents = InputLogEventsCopier.copy(logEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEvents(InputLogEvent ... logEvents) {
            this.logEvents(Arrays.asList(logEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEvents(Consumer<InputLogEvent.Builder> ... logEvents) {
            this.logEvents(Stream.of(logEvents).map(c -> (InputLogEvent)((InputLogEvent.Builder)InputLogEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogEvents(Collection<InputLogEvent.BuilderImpl> logEvents) {
            this.logEvents = InputLogEventsCopier.copyFromBuilder(logEvents);
        }

        public final String getSequenceToken() {
            return this.sequenceToken;
        }

        @Override
        public final Builder sequenceToken(String sequenceToken) {
            this.sequenceToken = sequenceToken;
            return this;
        }

        public final void setSequenceToken(String sequenceToken) {
            this.sequenceToken = sequenceToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLogEventsRequest build() {
            return new PutLogEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutLogEventsRequest> {
        public Builder logGroupName(String var1);

        public Builder logStreamName(String var1);

        public Builder logEvents(Collection<InputLogEvent> var1);

        public Builder logEvents(InputLogEvent ... var1);

        public Builder logEvents(Consumer<InputLogEvent.Builder> ... var1);

        public Builder sequenceToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

