/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the rejected events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectedLogEventsInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<RejectedLogEventsInfo.Builder, RejectedLogEventsInfo> {
    private static final SdkField<Integer> TOO_NEW_LOG_EVENT_START_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(RejectedLogEventsInfo::tooNewLogEventStartIndex))
            .setter(setter(Builder::tooNewLogEventStartIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tooNewLogEventStartIndex").build())
            .build();

    private static final SdkField<Integer> TOO_OLD_LOG_EVENT_END_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(RejectedLogEventsInfo::tooOldLogEventEndIndex))
            .setter(setter(Builder::tooOldLogEventEndIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tooOldLogEventEndIndex").build())
            .build();

    private static final SdkField<Integer> EXPIRED_LOG_EVENT_END_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(RejectedLogEventsInfo::expiredLogEventEndIndex))
            .setter(setter(Builder::expiredLogEventEndIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiredLogEventEndIndex").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOO_NEW_LOG_EVENT_START_INDEX_FIELD, TOO_OLD_LOG_EVENT_END_INDEX_FIELD, EXPIRED_LOG_EVENT_END_INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer tooNewLogEventStartIndex;

    private final Integer tooOldLogEventEndIndex;

    private final Integer expiredLogEventEndIndex;

    private RejectedLogEventsInfo(BuilderImpl builder) {
        this.tooNewLogEventStartIndex = builder.tooNewLogEventStartIndex;
        this.tooOldLogEventEndIndex = builder.tooOldLogEventEndIndex;
        this.expiredLogEventEndIndex = builder.expiredLogEventEndIndex;
    }

    /**
     * <p>
     * The log events that are too new.
     * </p>
     * 
     * @return The log events that are too new.
     */
    public Integer tooNewLogEventStartIndex() {
        return tooNewLogEventStartIndex;
    }

    /**
     * <p>
     * The log events that are too old.
     * </p>
     * 
     * @return The log events that are too old.
     */
    public Integer tooOldLogEventEndIndex() {
        return tooOldLogEventEndIndex;
    }

    /**
     * <p>
     * The expired log events.
     * </p>
     * 
     * @return The expired log events.
     */
    public Integer expiredLogEventEndIndex() {
        return expiredLogEventEndIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tooNewLogEventStartIndex());
        hashCode = 31 * hashCode + Objects.hashCode(tooOldLogEventEndIndex());
        hashCode = 31 * hashCode + Objects.hashCode(expiredLogEventEndIndex());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectedLogEventsInfo)) {
            return false;
        }
        RejectedLogEventsInfo other = (RejectedLogEventsInfo) obj;
        return Objects.equals(tooNewLogEventStartIndex(), other.tooNewLogEventStartIndex())
                && Objects.equals(tooOldLogEventEndIndex(), other.tooOldLogEventEndIndex())
                && Objects.equals(expiredLogEventEndIndex(), other.expiredLogEventEndIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RejectedLogEventsInfo").add("TooNewLogEventStartIndex", tooNewLogEventStartIndex())
                .add("TooOldLogEventEndIndex", tooOldLogEventEndIndex())
                .add("ExpiredLogEventEndIndex", expiredLogEventEndIndex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tooNewLogEventStartIndex":
            return Optional.ofNullable(clazz.cast(tooNewLogEventStartIndex()));
        case "tooOldLogEventEndIndex":
            return Optional.ofNullable(clazz.cast(tooOldLogEventEndIndex()));
        case "expiredLogEventEndIndex":
            return Optional.ofNullable(clazz.cast(expiredLogEventEndIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectedLogEventsInfo, T> g) {
        return obj -> g.apply((RejectedLogEventsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RejectedLogEventsInfo> {
        /**
         * <p>
         * The log events that are too new.
         * </p>
         * 
         * @param tooNewLogEventStartIndex
         *        The log events that are too new.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooNewLogEventStartIndex(Integer tooNewLogEventStartIndex);

        /**
         * <p>
         * The log events that are too old.
         * </p>
         * 
         * @param tooOldLogEventEndIndex
         *        The log events that are too old.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooOldLogEventEndIndex(Integer tooOldLogEventEndIndex);

        /**
         * <p>
         * The expired log events.
         * </p>
         * 
         * @param expiredLogEventEndIndex
         *        The expired log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiredLogEventEndIndex(Integer expiredLogEventEndIndex);
    }

    static final class BuilderImpl implements Builder {
        private Integer tooNewLogEventStartIndex;

        private Integer tooOldLogEventEndIndex;

        private Integer expiredLogEventEndIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectedLogEventsInfo model) {
            tooNewLogEventStartIndex(model.tooNewLogEventStartIndex);
            tooOldLogEventEndIndex(model.tooOldLogEventEndIndex);
            expiredLogEventEndIndex(model.expiredLogEventEndIndex);
        }

        public final Integer getTooNewLogEventStartIndex() {
            return tooNewLogEventStartIndex;
        }

        @Override
        public final Builder tooNewLogEventStartIndex(Integer tooNewLogEventStartIndex) {
            this.tooNewLogEventStartIndex = tooNewLogEventStartIndex;
            return this;
        }

        public final void setTooNewLogEventStartIndex(Integer tooNewLogEventStartIndex) {
            this.tooNewLogEventStartIndex = tooNewLogEventStartIndex;
        }

        public final Integer getTooOldLogEventEndIndex() {
            return tooOldLogEventEndIndex;
        }

        @Override
        public final Builder tooOldLogEventEndIndex(Integer tooOldLogEventEndIndex) {
            this.tooOldLogEventEndIndex = tooOldLogEventEndIndex;
            return this;
        }

        public final void setTooOldLogEventEndIndex(Integer tooOldLogEventEndIndex) {
            this.tooOldLogEventEndIndex = tooOldLogEventEndIndex;
        }

        public final Integer getExpiredLogEventEndIndex() {
            return expiredLogEventEndIndex;
        }

        @Override
        public final Builder expiredLogEventEndIndex(Integer expiredLogEventEndIndex) {
            this.expiredLogEventEndIndex = expiredLogEventEndIndex;
            return this;
        }

        public final void setExpiredLogEventEndIndex(Integer expiredLogEventEndIndex) {
            this.expiredLogEventEndIndex = expiredLogEventEndIndex;
        }

        @Override
        public RejectedLogEventsInfo build() {
            return new RejectedLogEventsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
