/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a subscription filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscriptionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscriptionFilter.Builder, SubscriptionFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscriptionFilter::filterName)).setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscriptionFilter::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscriptionFilter::filterPattern)).setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscriptionFilter::destinationArn)).setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscriptionFilter::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DISTRIBUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscriptionFilter::distributionAsString)).setter(setter(Builder::distribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()).build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(SubscriptionFilter::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD,
            LOG_GROUP_NAME_FIELD, FILTER_PATTERN_FIELD, DESTINATION_ARN_FIELD, ROLE_ARN_FIELD, DISTRIBUTION_FIELD,
            CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterName;

    private final String logGroupName;

    private final String filterPattern;

    private final String destinationArn;

    private final String roleArn;

    private final String distribution;

    private final Long creationTime;

    private SubscriptionFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.logGroupName = builder.logGroupName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the subscription filter.
     * </p>
     * 
     * @return The name of the subscription filter.
     */
    public String filterName() {
        return filterName;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * Returns the value of the FilterPattern property for this object.
     * 
     * @return The value of the FilterPattern property for this object.
     */
    public String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination.
     */
    public String destinationArn() {
        return destinationArn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the Distribution property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distribution} will
     * return {@link Distribution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distributionAsString}.
     * </p>
     * 
     * @return The value of the Distribution property for this object.
     * @see Distribution
     */
    public Distribution distribution() {
        return Distribution.fromValue(distribution);
    }

    /**
     * Returns the value of the Distribution property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distribution} will
     * return {@link Distribution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distributionAsString}.
     * </p>
     * 
     * @return The value of the Distribution property for this object.
     * @see Distribution
     */
    public String distributionAsString() {
        return distribution;
    }

    /**
     * <p>
     * The creation time of the subscription filter, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
     * UTC.
     * </p>
     * 
     * @return The creation time of the subscription filter, expressed as the number of milliseconds after Jan 1, 1970
     *         00:00:00 UTC.
     */
    public Long creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionFilter)) {
            return false;
        }
        SubscriptionFilter other = (SubscriptionFilter) obj;
        return Objects.equals(filterName(), other.filterName()) && Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(filterPattern(), other.filterPattern())
                && Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(distributionAsString(), other.distributionAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubscriptionFilter").add("FilterName", filterName()).add("LogGroupName", logGroupName())
                .add("FilterPattern", filterPattern()).add("DestinationArn", destinationArn()).add("RoleArn", roleArn())
                .add("Distribution", distributionAsString()).add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "distribution":
            return Optional.ofNullable(clazz.cast(distributionAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionFilter, T> g) {
        return obj -> g.apply((SubscriptionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscriptionFilter> {
        /**
         * <p>
         * The name of the subscription filter.
         * </p>
         * 
         * @param filterName
         *        The name of the subscription filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * Sets the value of the FilterPattern property for this object.
         *
         * @param filterPattern
         *        The new value for the FilterPattern property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p/>
         * 
         * @param roleArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the Distribution property for this object.
         *
         * @param distribution
         *        The new value for the Distribution property for this object.
         * @see Distribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(String distribution);

        /**
         * Sets the value of the Distribution property for this object.
         *
         * @param distribution
         *        The new value for the Distribution property for this object.
         * @see Distribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * The creation time of the subscription filter, expressed as the number of milliseconds after Jan 1, 1970
         * 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the subscription filter, expressed as the number of milliseconds after Jan 1,
         *        1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String filterName;

        private String logGroupName;

        private String filterPattern;

        private String destinationArn;

        private String roleArn;

        private String distribution;

        private Long creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionFilter model) {
            filterName(model.filterName);
            logGroupName(model.logGroupName);
            filterPattern(model.filterPattern);
            destinationArn(model.destinationArn);
            roleArn(model.roleArn);
            distribution(model.distribution);
            creationTime(model.creationTime);
        }

        public final String getFilterName() {
            return filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDistributionAsString() {
            return distribution;
        }

        @Override
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution.toString());
            return this;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public SubscriptionFilter build() {
            return new SubscriptionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
