/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about one CloudWatch Logs Insights query that matches the request in a <code>DescribeQueries</code>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryInfo implements SdkPojo, Serializable, ToCopyableBuilder<QueryInfo.Builder, QueryInfo> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryInfo::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryId").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryInfo::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(QueryInfo::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryInfo::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_STRING_FIELD, STATUS_FIELD, CREATE_TIME_FIELD, LOG_GROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String queryId;

    private final String queryString;

    private final String status;

    private final Long createTime;

    private final String logGroupName;

    private QueryInfo(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryString = builder.queryString;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.logGroupName = builder.logGroupName;
    }

    /**
     * <p>
     * The unique ID number of this query.
     * </p>
     * 
     * @return The unique ID number of this query.
     */
    public String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The query string used in this query.
     * </p>
     * 
     * @return The query string used in this query.
     */
    public String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>,
     * <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>,
     *         <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.
     * @see QueryStatus
     */
    public QueryStatus status() {
        return QueryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>,
     * <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>,
     *         <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.
     * @see QueryStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that this query was created.
     * </p>
     * 
     * @return The date and time that this query was created.
     */
    public Long createTime() {
        return createTime;
    }

    /**
     * <p>
     * The name of the log group scanned by this query.
     * </p>
     * 
     * @return The name of the log group scanned by this query.
     */
    public String logGroupName() {
        return logGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInfo)) {
            return false;
        }
        QueryInfo other = (QueryInfo) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(logGroupName(), other.logGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryInfo").add("QueryId", queryId()).add("QueryString", queryString())
                .add("Status", statusAsString()).add("CreateTime", createTime()).add("LogGroupName", logGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryInfo, T> g) {
        return obj -> g.apply((QueryInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryInfo> {
        /**
         * <p>
         * The unique ID number of this query.
         * </p>
         * 
         * @param queryId
         *        The unique ID number of this query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The query string used in this query.
         * </p>
         * 
         * @param queryString
         *        The query string used in this query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>,
         * <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.
         * </p>
         * 
         * @param status
         *        The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>,
         *        <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>,
         * <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.
         * </p>
         * 
         * @param status
         *        The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>,
         *        <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder status(QueryStatus status);

        /**
         * <p>
         * The date and time that this query was created.
         * </p>
         * 
         * @param createTime
         *        The date and time that this query was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Long createTime);

        /**
         * <p>
         * The name of the log group scanned by this query.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group scanned by this query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String queryId;

        private String queryString;

        private String status;

        private Long createTime;

        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryInfo model) {
            queryId(model.queryId);
            queryString(model.queryString);
            status(model.status);
            createTime(model.createTime);
            logGroupName(model.logGroupName);
        }

        public final String getQueryId() {
            return queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public QueryInfo build() {
            return new QueryInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
