/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportTasksResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeExportTasksResponse.Builder, DescribeExportTasksResponse> {
    private static final SdkField<List<ExportTask>> EXPORT_TASKS_FIELD = SdkField
            .<List<ExportTask>> builder(MarshallingType.LIST)
            .getter(getter(DescribeExportTasksResponse::exportTasks))
            .setter(setter(Builder::exportTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeExportTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ExportTask> exportTasks;

    private final String nextToken;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportTasks = builder.exportTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The export tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The export tasks.
     */
    public List<ExportTask> exportTasks() {
        return exportTasks;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportTasks());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse) obj;
        return Objects.equals(exportTasks(), other.exportTasks()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeExportTasksResponse").add("ExportTasks", exportTasks()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportTasks":
            return Optional.ofNullable(clazz.cast(exportTasks()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeExportTasksResponse> {
        /**
         * <p>
         * The export tasks.
         * </p>
         * 
         * @param exportTasks
         *        The export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(Collection<ExportTask> exportTasks);

        /**
         * <p>
         * The export tasks.
         * </p>
         * 
         * @param exportTasks
         *        The export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(ExportTask... exportTasks);

        /**
         * <p>
         * The export tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExportTask>.Builder} avoiding the need to
         * create one manually via {@link List<ExportTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExportTask>.Builder#build()} is called immediately and its
         * result is passed to {@link #exportTasks(List<ExportTask>)}.
         * 
         * @param exportTasks
         *        a consumer that will call methods on {@link List<ExportTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportTasks(List<ExportTask>)
         */
        Builder exportTasks(Consumer<ExportTask.Builder>... exportTasks);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<ExportTask> exportTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            super(model);
            exportTasks(model.exportTasks);
            nextToken(model.nextToken);
        }

        public final Collection<ExportTask.Builder> getExportTasks() {
            return exportTasks != null ? exportTasks.stream().map(ExportTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTasksCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask... exportTasks) {
            exportTasks(Arrays.asList(exportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(Consumer<ExportTask.Builder>... exportTasks) {
            exportTasks(Stream.of(exportTasks).map(c -> ExportTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExportTasks(Collection<ExportTask.BuilderImpl> exportTasks) {
            this.exportTasks = ExportTasksCopier.copyFromBuilder(exportTasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
