/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import software.amazon.awssdk.metrics.internal.cloudwatch.DimensionComparator;
import software.amazon.awssdk.metrics.internal.cloudwatch.MachineMetric;
import software.amazon.awssdk.metrics.internal.cloudwatch.MachineMetricFactory;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.Dimensions;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.awssdk.util.AwsHostNameUtils;

class BlockingRequestBuilder {
    private static final String OS_METRIC_NAME = MachineMetric.getOsMetricName();
    private final MachineMetricFactory machineMetricFactory = new MachineMetricFactory();
    private final BlockingQueue<MetricDatum> queue;
    private final long timeoutNano;

    BlockingRequestBuilder(CloudWatchMetricConfig config, BlockingQueue<MetricDatum> queue) {
        this.queue = queue;
        this.timeoutNano = TimeUnit.MILLISECONDS.toNanos(config.getQueuePollTimeoutMilli());
    }

    Iterable<PutMetricDataRequest> nextUploadUnits() throws InterruptedException {
        HashMap<String, MetricDatum> uniqueMetrics = new HashMap<String, MetricDatum>();
        long startNano = System.nanoTime();
        long elapsedNano;
        while ((elapsedNano = System.nanoTime() - startNano) < this.timeoutNano) {
            MetricDatum datum = this.queue.poll(this.timeoutNano - elapsedNano, TimeUnit.NANOSECONDS);
            if (datum == null) {
                if (uniqueMetrics.size() > 0) {
                    return this.toPutMetricDataRequests(uniqueMetrics);
                }
                if (AwsSdkMetrics.isMachineMetricExcluded()) {
                    datum = this.queue.take();
                    startNano = System.nanoTime();
                }
            }
            if (datum == null) continue;
            this.summarize(datum, uniqueMetrics);
        }
        return this.toPutMetricDataRequests(uniqueMetrics);
    }

    private void summarize(MetricDatum datum, Map<String, MetricDatum> uniqueMetrics) {
        Double value = datum.value();
        if (value == null) {
            return;
        }
        ArrayList dims = new ArrayList(datum.dimensions());
        Collections.sort(dims, DimensionComparator.INSTANCE);
        String metricName = datum.metricName();
        String key = metricName + dims;
        MetricDatum statDatum = uniqueMetrics.get(key);
        if (statDatum == null) {
            statDatum = (MetricDatum)MetricDatum.builder().dimensions((Collection)datum.dimensions()).metricName(metricName).unit(datum.unit()).statisticValues((StatisticSet)StatisticSet.builder().maximum(value).minimum(value).sampleCount(Double.valueOf(0.0)).sum(Double.valueOf(0.0)).build()).build();
            uniqueMetrics.put(key, statDatum);
        }
        StatisticSet stat = statDatum.statisticValues();
        StatisticSet.Builder newStatBuilder = stat.toBuilder().sampleCount(Double.valueOf(stat.sampleCount() + 1.0)).sum(Double.valueOf(stat.sum() + value));
        if (value > stat.maximum()) {
            newStatBuilder.maximum(value);
        } else if (value < stat.minimum()) {
            newStatBuilder.minimum(value);
        }
        uniqueMetrics.put(key, (MetricDatum)statDatum.toBuilder().statisticValues((StatisticSet)newStatBuilder.build()).build());
    }

    private Iterable<PutMetricDataRequest> toPutMetricDataRequests(Map<String, MetricDatum> uniqueMetrics) {
        for (MetricDatum datum : this.machineMetricFactory.generateMetrics()) {
            this.summarize(datum, uniqueMetrics);
        }
        ArrayList<PutMetricDataRequest> list = new ArrayList<PutMetricDataRequest>();
        ArrayList<MetricDatum> data = new ArrayList<MetricDatum>();
        for (MetricDatum m : uniqueMetrics.values()) {
            data.add(m);
            if (data.size() != 20) continue;
            list.addAll(this.newPutMetricDataRequests(data));
            data.clear();
        }
        if (data.size() > 0) {
            list.addAll(this.newPutMetricDataRequests(data));
        }
        return list;
    }

    private List<PutMetricDataRequest> newPutMetricDataRequests(Collection<MetricDatum> data) {
        String jvmMetricName;
        ArrayList<PutMetricDataRequest> list = new ArrayList<PutMetricDataRequest>();
        String ns = AwsSdkMetrics.getMetricNameSpace();
        PutMetricDataRequest req = this.newPutMetricDataRequest(data, ns, new Dimension[0]);
        list.add(req);
        boolean perHost = AwsSdkMetrics.isPerHostMetricEnabled();
        String perHostNameSpace = null;
        String hostName = null;
        Dimension hostDim = null;
        boolean singleNamespace = AwsSdkMetrics.isSingleMetricNamespace();
        if (perHost) {
            hostName = AwsSdkMetrics.getHostMetricName();
            String string = hostName = hostName == null ? "" : hostName.trim();
            if (hostName.length() == 0) {
                hostName = AwsHostNameUtils.localHostName();
            }
            hostDim = this.dimension(Dimensions.Host, hostName);
            if (singleNamespace) {
                req = this.newPutMetricDataRequest(data, ns, hostDim);
            } else {
                perHostNameSpace = ns + "/" + hostName;
                req = this.newPutMetricDataRequest(data, perHostNameSpace, new Dimension[0]);
            }
            list.add(req);
        }
        if ((jvmMetricName = AwsSdkMetrics.getJvmMetricName()) != null && (jvmMetricName = jvmMetricName.trim()).length() > 0) {
            if (singleNamespace) {
                Dimension jvmDim = this.dimension(Dimensions.JVM, jvmMetricName);
                req = perHost ? this.newPutMetricDataRequest(this.filterOsMetrics(data), ns, hostDim, jvmDim) : this.newPutMetricDataRequest(data, ns, jvmDim);
            } else {
                String perJvmNameSpace = perHostNameSpace == null ? ns + "/" + jvmMetricName : perHostNameSpace + "/" + jvmMetricName;
                req = this.newPutMetricDataRequest(perHost ? this.filterOsMetrics(data) : data, perJvmNameSpace, new Dimension[0]);
            }
            list.add(req);
        }
        return list;
    }

    private Collection<MetricDatum> filterOsMetrics(Collection<MetricDatum> data) {
        ArrayList<MetricDatum> output = new ArrayList<MetricDatum>(data.size());
        for (MetricDatum datum : data) {
            if (OS_METRIC_NAME.equals(datum.metricName())) continue;
            output.add(datum);
        }
        return output;
    }

    private PutMetricDataRequest newPutMetricDataRequest(Collection<MetricDatum> data, String namespace, Dimension ... extraDims) {
        if (extraDims != null) {
            ArrayList<MetricDatum> newData = new ArrayList<MetricDatum>(data.size());
            for (MetricDatum md : data) {
                MetricDatum.Builder newMdBuilder = this.cloneMetricDatum(md).toBuilder();
                for (Dimension dim : extraDims) {
                    newMdBuilder.dimensions(new Dimension[]{dim});
                }
                newData.add((MetricDatum)newMdBuilder.build());
            }
            data = newData;
        }
        return (PutMetricDataRequest)((PutMetricDataRequest)PutMetricDataRequest.builder().namespace(namespace).metricData(data).build()).withRequestMetricCollector(RequestMetricCollector.NONE);
    }

    final MetricDatum cloneMetricDatum(MetricDatum md) {
        return (MetricDatum)MetricDatum.builder().dimensions((Collection)md.dimensions()).metricName(md.metricName()).statisticValues(md.statisticValues()).timestamp(md.timestamp()).unit(md.unit()).value(md.value()).build();
    }

    private Dimension dimension(Dimensions name, String value) {
        return (Dimension)Dimension.builder().name(name.toString()).value(value).build();
    }
}

