/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;

@NotThreadSafe
public class CloudWatchMetricConfig {
    public static final int DEFAULT_METRICS_QSIZE = 1000;
    public static final int DEFAULT_QUEUE_POLL_TIMEOUT_MILLI = (int)TimeUnit.MINUTES.toMillis(1L);
    static final String NAMESPACE_DELIMITER = "/";
    static final int MAX_METRICS_DATUM_SIZE = 20;
    private long queuePollTimeoutMilli = DEFAULT_QUEUE_POLL_TIMEOUT_MILLI;
    private int metricQueueSize = 1000;
    private CloudWatchClient cloudWatchClient;

    public long getQueuePollTimeoutMilli() {
        return this.queuePollTimeoutMilli;
    }

    public void setQueuePollTimeoutMilli(long queuePollTimeoutMilli) {
        this.queuePollTimeoutMilli = queuePollTimeoutMilli;
    }

    public CloudWatchMetricConfig withQueuePollTimeoutMilli(long queuePollTimeoutMilli) {
        this.setQueuePollTimeoutMilli(queuePollTimeoutMilli);
        return this;
    }

    public int getMetricQueueSize() {
        return this.metricQueueSize;
    }

    public void setMetricQueueSize(int metricQueueSize) {
        if (metricQueueSize < 1) {
            throw new IllegalArgumentException();
        }
        this.metricQueueSize = metricQueueSize;
    }

    public CloudWatchMetricConfig withMetricQueueSize(int metricQueueSize) {
        this.setMetricQueueSize(metricQueueSize);
        return this;
    }

    public CloudWatchClient getCloudWatchClient() {
        return this.cloudWatchClient;
    }

    public void setCloudWatchClient(CloudWatchClient cloudWatchClient) {
        this.cloudWatchClient = cloudWatchClient;
    }

    public CloudWatchMetricConfig withCloudWatchClient(CloudWatchClient cloudWatchClient) {
        this.setCloudWatchClient(cloudWatchClient);
        return this;
    }
}

