/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.jmx.spi.JmxInfoProvider;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.internal.cloudwatch.MachineMetric;
import software.amazon.awssdk.metrics.spi.MetricType;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

class MachineMetricFactory {
    private static final List<MachineMetric> MEMORY_METRICS = Arrays.asList(MachineMetric.TotalMemory, MachineMetric.FreeMemory, MachineMetric.UsedMemory, MachineMetric.SpareMemory);
    private static final List<MachineMetric> THREAD_METRICS = Arrays.asList(MachineMetric.ThreadCount, MachineMetric.DeadLockThreadCount, MachineMetric.DaemonThreadCount, MachineMetric.PeakThreadCount, MachineMetric.TotalStartedThreadCount);
    private static final List<MachineMetric> FD_METRICS = Arrays.asList(MachineMetric.OpenFileDescriptorCount, MachineMetric.SpareFileDescriptorCount);
    private final JmxInfoProvider jmxInfoProvider = JmxInfoProvider.Factory.getJmxInfoProvider();

    MachineMetricFactory() {
    }

    private void addMetrics(List<MetricDatum> list, MetricValues metricValues, StandardUnit unit) {
        List<MachineMetric> machineMetrics = metricValues.getMetrics();
        List<Long> values = metricValues.getValues();
        for (int i = 0; i < machineMetrics.size(); ++i) {
            MachineMetric metric = machineMetrics.get(i);
            long val = values.get(i);
            if (val == 0L && !metric.includeZeroValue()) continue;
            MetricDatum datum = (MetricDatum)MetricDatum.builder().metricName(metric.getMetricName()).dimensions(new Dimension[]{(Dimension)Dimension.builder().name(metric.getDimensionName()).value(metric.name()).build()}).unit(unit).value(Double.valueOf(val)).build();
            list.add(datum);
        }
    }

    private Set<MachineMetric> customMachineMetrics() {
        HashSet<MachineMetric> customized = new HashSet<MachineMetric>();
        for (MetricType m : AwsSdkMetrics.getPredefinedMetrics()) {
            if (!(m instanceof MachineMetric)) continue;
            customized.add((MachineMetric)m);
        }
        return customized;
    }

    private MetricValues metricValues(Set<MachineMetric> customSet, List<MachineMetric> defaults, List<Long> values) {
        List<MachineMetric> actualMetrics = defaults;
        List<Long> actualValues = values;
        if (customSet.size() > 0) {
            actualMetrics = new ArrayList<MachineMetric>();
            actualValues = new ArrayList<Long>();
            for (int i = 0; i < defaults.size(); ++i) {
                MachineMetric mm = defaults.get(i);
                if (!customSet.contains((Object)mm)) continue;
                actualMetrics.add(mm);
                actualValues.add(values.get(i));
            }
        }
        return new MetricValues(actualMetrics, actualValues);
    }

    List<MetricDatum> generateMetrics() {
        if (AwsSdkMetrics.isMachineMetricExcluded()) {
            return Collections.emptyList();
        }
        Set<MachineMetric> customSet = this.customMachineMetrics();
        ArrayList<MetricDatum> targetList = new ArrayList<MetricDatum>(MachineMetric.values().length);
        this.addMemoryMetrics(targetList, customSet);
        try {
            this.addThreadMetrics(targetList, customSet);
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).debug("Ignoring thread metrics", t);
        }
        try {
            this.addFileDescriptorMetrics(targetList, customSet);
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).debug("Ignoring file descriptor metrics", t);
        }
        return targetList;
    }

    private void addMemoryMetrics(List<MetricDatum> targetList, Set<MachineMetric> customSet) {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        long usedMem = totalMem - freeMem;
        long spareMem = rt.maxMemory() - usedMem;
        List<Long> values = Arrays.asList(totalMem, freeMem, usedMem, spareMem);
        MetricValues metricValues = this.memoryMetricValues(customSet, values);
        this.addMetrics(targetList, metricValues, StandardUnit.Bytes);
    }

    private void addFileDescriptorMetrics(List<MetricDatum> targetList, Set<MachineMetric> customSet) {
        JmxInfoProvider provider = JmxInfoProvider.Factory.getJmxInfoProvider();
        long[] fdInfo = provider.getFileDecriptorInfo();
        if (fdInfo != null) {
            long openFdCount = fdInfo[0];
            long maxFdCount = fdInfo[1];
            List<Long> values = Arrays.asList(openFdCount, maxFdCount - openFdCount);
            MetricValues metricValues = this.fdMetricValues(customSet, values);
            this.addMetrics(targetList, metricValues, StandardUnit.Count);
        }
    }

    private void addThreadMetrics(List<MetricDatum> targetList, Set<MachineMetric> customSet) {
        long threadCount = this.jmxInfoProvider.getThreadCount();
        long[] ids = this.jmxInfoProvider.findDeadlockedThreads();
        long deadLockThreadCount = ids == null ? 0L : (long)ids.length;
        long daemonThreadCount = this.jmxInfoProvider.getDaemonThreadCount();
        long peakThreadCount = this.jmxInfoProvider.getPeakThreadCount();
        long totalStartedThreadCount = this.jmxInfoProvider.getTotalStartedThreadCount();
        List<Long> values = Arrays.asList(threadCount, deadLockThreadCount, daemonThreadCount, peakThreadCount, totalStartedThreadCount);
        MetricValues metricValues = this.threadMetricValues(customSet, values);
        this.addMetrics(targetList, metricValues, StandardUnit.Count);
    }

    private MetricValues memoryMetricValues(Set<MachineMetric> customSet, List<Long> values) {
        return this.metricValues(customSet, MEMORY_METRICS, values);
    }

    private MetricValues fdMetricValues(Set<MachineMetric> customSet, List<Long> values) {
        return this.metricValues(customSet, FD_METRICS, values);
    }

    private MetricValues threadMetricValues(Set<MachineMetric> customSet, List<Long> values) {
        return this.metricValues(customSet, THREAD_METRICS, values);
    }

    private static class MetricValues {
        private final List<MachineMetric> metrics;
        private final List<Long> values;

        MetricValues(List<MachineMetric> metrics, List<Long> values) {
            this.metrics = metrics;
            this.values = values;
        }

        List<MachineMetric> getMetrics() {
            return this.metrics;
        }

        List<Long> getValues() {
            return this.values;
        }
    }
}

