/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.metrics.internal.cloudwatch.PredefinedMetricTransformer;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.metrics.spi.MetricType;
import software.amazon.awssdk.metrics.spi.RequestMetricType;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;

@ThreadSafe
public class RequestMetricCollectorSupport
extends RequestMetricCollector {
    protected static final Logger log = LoggerFactory.getLogger(RequestMetricCollectorSupport.class);
    private final BlockingQueue<MetricDatum> queue;
    private final PredefinedMetricTransformer transformer = new PredefinedMetricTransformer();

    protected RequestMetricCollectorSupport(BlockingQueue<MetricDatum> queue) {
        this.queue = queue;
    }

    public void collectMetrics(Request<?> request, Object response) {
        block2: {
            try {
                this.collectMetrics0(request, response);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Ignoring unexpected failure", (Throwable)ex);
            }
        }
    }

    private void collectMetrics0(Request<?> request, Object response) {
        AwsRequestMetrics arm = request.getAwsRequestMetrics();
        if (arm == null || !arm.isEnabled()) {
            return;
        }
        for (MetricType type : AwsSdkMetrics.getPredefinedMetrics()) {
            if (!(type instanceof RequestMetricType)) continue;
            PredefinedMetricTransformer transformer = this.getTransformer();
            for (MetricDatum datum : transformer.toMetricData(type, request, response)) {
                try {
                    if (this.addMetricsToQueue(datum) || !log.isDebugEnabled()) continue;
                    log.debug("Failed to add to the metrics queue (due to no space available) for " + type.name() + ":" + request.getServiceName());
                }
                catch (RuntimeException ex) {
                    log.warn("Failed to add to the metrics queue for " + type.name() + ":" + request.getServiceName(), (Throwable)ex);
                }
            }
        }
    }

    protected boolean addMetricsToQueue(MetricDatum metric) {
        return this.queue.offer(metric);
    }

    protected PredefinedMetricTransformer getTransformer() {
        return this.transformer;
    }
}

