/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRepositoryResponse extends CodeartifactResponse implements
        ToCopyableBuilder<CreateRepositoryResponse.Builder, CreateRepositoryResponse> {
    private static final SdkField<RepositoryDescription> REPOSITORY_FIELD = SdkField
            .<RepositoryDescription> builder(MarshallingType.SDK_POJO).getter(getter(CreateRepositoryResponse::repository))
            .setter(setter(Builder::repository)).constructor(RepositoryDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_FIELD));

    private final RepositoryDescription repository;

    private CreateRepositoryResponse(BuilderImpl builder) {
        super(builder);
        this.repository = builder.repository;
    }

    /**
     * <p>
     * Information about the created repository after processing the request.
     * </p>
     * 
     * @return Information about the created repository after processing the request.
     */
    public RepositoryDescription repository() {
        return repository;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryResponse)) {
            return false;
        }
        CreateRepositoryResponse other = (CreateRepositoryResponse) obj;
        return Objects.equals(repository(), other.repository());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRepositoryResponse").add("Repository", repository()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryResponse, T> g) {
        return obj -> g.apply((CreateRepositoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRepositoryResponse> {
        /**
         * <p>
         * Information about the created repository after processing the request.
         * </p>
         * 
         * @param repository
         *        Information about the created repository after processing the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(RepositoryDescription repository);

        /**
         * <p>
         * Information about the created repository after processing the request.
         * </p>
         * This is a convenience that creates an instance of the {@link RepositoryDescription.Builder} avoiding the need
         * to create one manually via {@link RepositoryDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #repository(RepositoryDescription)}.
         * 
         * @param repository
         *        a consumer that will call methods on {@link RepositoryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repository(RepositoryDescription)
         */
        default Builder repository(Consumer<RepositoryDescription.Builder> repository) {
            return repository(RepositoryDescription.builder().applyMutation(repository).build());
        }
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private RepositoryDescription repository;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryResponse model) {
            super(model);
            repository(model.repository);
        }

        public final RepositoryDescription.Builder getRepository() {
            return repository != null ? repository.toBuilder() : null;
        }

        @Override
        public final Builder repository(RepositoryDescription repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(RepositoryDescription.BuilderImpl repository) {
            this.repository = repository != null ? repository.build() : null;
        }

        @Override
        public CreateRepositoryResponse build() {
            return new CreateRepositoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
