/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRepositoryEndpointResponse extends CodeartifactResponse implements
        ToCopyableBuilder<GetRepositoryEndpointResponse.Builder, GetRepositoryEndpointResponse> {
    private static final SdkField<String> REPOSITORY_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRepositoryEndpointResponse::repositoryEndpoint)).setter(setter(Builder::repositoryEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ENDPOINT_FIELD));

    private final String repositoryEndpoint;

    private GetRepositoryEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryEndpoint = builder.repositoryEndpoint;
    }

    /**
     * <p>
     * A string that specifies the URL of the returned endpoint.
     * </p>
     * 
     * @return A string that specifies the URL of the returned endpoint.
     */
    public String repositoryEndpoint() {
        return repositoryEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryEndpoint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRepositoryEndpointResponse)) {
            return false;
        }
        GetRepositoryEndpointResponse other = (GetRepositoryEndpointResponse) obj;
        return Objects.equals(repositoryEndpoint(), other.repositoryEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRepositoryEndpointResponse").add("RepositoryEndpoint", repositoryEndpoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryEndpoint":
            return Optional.ofNullable(clazz.cast(repositoryEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRepositoryEndpointResponse, T> g) {
        return obj -> g.apply((GetRepositoryEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRepositoryEndpointResponse> {
        /**
         * <p>
         * A string that specifies the URL of the returned endpoint.
         * </p>
         * 
         * @param repositoryEndpoint
         *        A string that specifies the URL of the returned endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryEndpoint(String repositoryEndpoint);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private String repositoryEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRepositoryEndpointResponse model) {
            super(model);
            repositoryEndpoint(model.repositoryEndpoint);
        }

        public final String getRepositoryEndpoint() {
            return repositoryEndpoint;
        }

        @Override
        public final Builder repositoryEndpoint(String repositoryEndpoint) {
            this.repositoryEndpoint = repositoryEndpoint;
            return this;
        }

        public final void setRepositoryEndpoint(String repositoryEndpoint) {
            this.repositoryEndpoint = repositoryEndpoint;
        }

        @Override
        public GetRepositoryEndpointResponse build() {
            return new GetRepositoryEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
