/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPackageVersionAssetResponse extends CodeartifactResponse implements
        ToCopyableBuilder<GetPackageVersionAssetResponse.Builder, GetPackageVersionAssetResponse> {
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPackageVersionAssetResponse::assetName)).setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-AssetName").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPackageVersionAssetResponse::packageVersion)).setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-PackageVersion").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPackageVersionAssetResponse::packageVersionRevision))
            .setter(setter(Builder::packageVersionRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-PackageVersionRevision").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_NAME_FIELD,
            PACKAGE_VERSION_FIELD, PACKAGE_VERSION_REVISION_FIELD));

    private final String assetName;

    private final String packageVersion;

    private final String packageVersionRevision;

    private GetPackageVersionAssetResponse(BuilderImpl builder) {
        super(builder);
        this.assetName = builder.assetName;
        this.packageVersion = builder.packageVersion;
        this.packageVersionRevision = builder.packageVersionRevision;
    }

    /**
     * <p>
     * The name of the asset that is downloaded.
     * </p>
     * 
     * @return The name of the asset that is downloaded.
     */
    public String assetName() {
        return assetName;
    }

    /**
     * <p>
     * A string that contains the package version (for example, <code>3.5.2</code>).
     * </p>
     * 
     * @return A string that contains the package version (for example, <code>3.5.2</code>).
     */
    public String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The name of the package version revision that contains the downloaded asset.
     * </p>
     * 
     * @return The name of the package version revision that contains the downloaded asset.
     */
    public String packageVersionRevision() {
        return packageVersionRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersionRevision());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionAssetResponse)) {
            return false;
        }
        GetPackageVersionAssetResponse other = (GetPackageVersionAssetResponse) obj;
        return Objects.equals(assetName(), other.assetName()) && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(packageVersionRevision(), other.packageVersionRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPackageVersionAssetResponse").add("AssetName", assetName())
                .add("PackageVersion", packageVersion()).add("PackageVersionRevision", packageVersionRevision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "packageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "packageVersionRevision":
            return Optional.ofNullable(clazz.cast(packageVersionRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageVersionAssetResponse, T> g) {
        return obj -> g.apply((GetPackageVersionAssetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPackageVersionAssetResponse> {
        /**
         * <p>
         * The name of the asset that is downloaded.
         * </p>
         * 
         * @param assetName
         *        The name of the asset that is downloaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * <p>
         * A string that contains the package version (for example, <code>3.5.2</code>).
         * </p>
         * 
         * @param packageVersion
         *        A string that contains the package version (for example, <code>3.5.2</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The name of the package version revision that contains the downloaded asset.
         * </p>
         * 
         * @param packageVersionRevision
         *        The name of the package version revision that contains the downloaded asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersionRevision(String packageVersionRevision);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private String assetName;

        private String packageVersion;

        private String packageVersionRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageVersionAssetResponse model) {
            super(model);
            assetName(model.assetName);
            packageVersion(model.packageVersion);
            packageVersionRevision(model.packageVersionRevision);
        }

        public final String getAssetName() {
            return assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        public final String getPackageVersionRevision() {
            return packageVersionRevision;
        }

        @Override
        public final Builder packageVersionRevision(String packageVersionRevision) {
            this.packageVersionRevision = packageVersionRevision;
            return this;
        }

        public final void setPackageVersionRevision(String packageVersionRevision) {
            this.packageVersionRevision = packageVersionRevision;
        }

        @Override
        public GetPackageVersionAssetResponse build() {
            return new GetPackageVersionAssetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
