/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackagesResponse extends CodeartifactResponse implements
        ToCopyableBuilder<ListPackagesResponse.Builder, ListPackagesResponse> {
    private static final SdkField<List<PackageSummary>> PACKAGES_FIELD = SdkField
            .<List<PackageSummary>> builder(MarshallingType.LIST)
            .memberName("packages")
            .getter(getter(ListPackagesResponse::packages))
            .setter(setter(Builder::packages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPackagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PackageSummary> packages;

    private final String nextToken;

    private ListPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.packages = builder.packages;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Packages property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPackages() {
        return packages != null && !(packages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of returned <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">
     * <code>PackageSummary</code> </a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPackages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of returned <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">
     *         <code>PackageSummary</code> </a> objects.
     */
    public List<PackageSummary> packages() {
        return packages;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packages());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackagesResponse)) {
            return false;
        }
        ListPackagesResponse other = (ListPackagesResponse) obj;
        return Objects.equals(packages(), other.packages()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPackagesResponse").add("Packages", packages()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packages":
            return Optional.ofNullable(clazz.cast(packages()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackagesResponse, T> g) {
        return obj -> g.apply((ListPackagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPackagesResponse> {
        /**
         * <p>
         * The list of returned <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">
         * <code>PackageSummary</code> </a> objects.
         * </p>
         * 
         * @param packages
         *        The list of returned <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">
         *        <code>PackageSummary</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(Collection<PackageSummary> packages);

        /**
         * <p>
         * The list of returned <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">
         * <code>PackageSummary</code> </a> objects.
         * </p>
         * 
         * @param packages
         *        The list of returned <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">
         *        <code>PackageSummary</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(PackageSummary... packages);

        /**
         * <p>
         * The list of returned <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">
         * <code>PackageSummary</code> </a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PackageSummary>.Builder} avoiding the need
         * to create one manually via {@link List<PackageSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackageSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #packages(List<PackageSummary>)}.
         * 
         * @param packages
         *        a consumer that will call methods on {@link List<PackageSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packages(List<PackageSummary>)
         */
        Builder packages(Consumer<PackageSummary.Builder>... packages);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private List<PackageSummary> packages = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackagesResponse model) {
            super(model);
            packages(model.packages);
            nextToken(model.nextToken);
        }

        public final Collection<PackageSummary.Builder> getPackages() {
            return packages != null ? packages.stream().map(PackageSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder packages(Collection<PackageSummary> packages) {
            this.packages = PackageSummaryListCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(PackageSummary... packages) {
            packages(Arrays.asList(packages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(Consumer<PackageSummary.Builder>... packages) {
            packages(Stream.of(packages).map(c -> PackageSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPackages(Collection<PackageSummary.BuilderImpl> packages) {
            this.packages = PackageSummaryListCopier.copyFromBuilder(packages);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPackagesResponse build() {
            return new ListPackagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
