/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageVersionsStatusRequest extends CodeartifactRequest implements
        ToCopyableBuilder<UpdatePackageVersionsStatusRequest.Builder, UpdatePackageVersionsStatusRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(UpdatePackageVersionsStatusRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(UpdatePackageVersionsStatusRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(UpdatePackageVersionsStatusRequest::repository))
            .setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(UpdatePackageVersionsStatusRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(UpdatePackageVersionsStatusRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(UpdatePackageVersionsStatusRequest::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package").build()).build();

    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("versions")
            .getter(getter(UpdatePackageVersionsStatusRequest::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VERSION_REVISIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("versionRevisions")
            .getter(getter(UpdatePackageVersionsStatusRequest::versionRevisions))
            .setter(setter(Builder::versionRevisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevisions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EXPECTED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedStatus").getter(getter(UpdatePackageVersionsStatusRequest::expectedStatusAsString))
            .setter(setter(Builder::expectedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedStatus").build()).build();

    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetStatus").getter(getter(UpdatePackageVersionsStatusRequest::targetStatusAsString))
            .setter(setter(Builder::targetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, VERSIONS_FIELD,
            VERSION_REVISIONS_FIELD, EXPECTED_STATUS_FIELD, TARGET_STATUS_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final List<String> versions;

    private final Map<String, String> versionRevisions;

    private final String expectedStatus;

    private final String targetStatus;

    private UpdatePackageVersionsStatusRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.versions = builder.versions;
        this.versionRevisions = builder.versionRevisions;
        this.expectedStatus = builder.expectedStatus;
        this.targetStatus = builder.targetStatus;
    }

    /**
     * <p>
     * The domain that contains the repository that contains the package versions with a status to be updated.
     * </p>
     * 
     * @return The domain that contains the repository that contains the package versions with a status to be updated.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The repository that contains the package versions with the status you want to update.
     * </p>
     * 
     * @return The repository that contains the package versions with the status you want to update.
     */
    public String repository() {
        return repository;
    }

    /**
     * <p>
     * A format that specifies the type of the package with the statuses to update. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package with the statuses to update. The valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * A format that specifies the type of the package with the statuses to update. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package with the statuses to update. The valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package. The package component that specifies its namespace depends on its type. For
     * example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm package is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package. The package component that specifies its namespace depends on its type. For
     *         example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm package is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     *         </p>
     *         </li>
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package with the version statuses to update.
     * </p>
     * 
     * @return The name of the package with the version statuses to update.
     */
    public String packageValue() {
        return packageValue;
    }

    /**
     * Returns true if the Versions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that specify the versions of the package with the statuses to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings that specify the versions of the package with the statuses to update.
     */
    public List<String> versions() {
        return versions;
    }

    /**
     * Returns true if the VersionRevisions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVersionRevisions() {
        return versionRevisions != null && !(versionRevisions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of package versions and package version revisions. The map <code>key</code> is the package version (for
     * example, <code>3.5.2</code>), and the map <code>value</code> is the package version revision.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersionRevisions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of package versions and package version revisions. The map <code>key</code> is the package version
     *         (for example, <code>3.5.2</code>), and the map <code>value</code> is the package version revision.
     */
    public Map<String, String> versionRevisions() {
        return versionRevisions;
    }

    /**
     * <p>
     * The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided, the
     * package version's status is updated only if its status at the time <code>UpdatePackageVersionsStatus</code> is
     * called matches <code>expectedStatus</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #expectedStatus}
     * will return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #expectedStatusAsString}.
     * </p>
     * 
     * @return The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided,
     *         the package version's status is updated only if its status at the time
     *         <code>UpdatePackageVersionsStatus</code> is called matches <code>expectedStatus</code>.
     * @see PackageVersionStatus
     */
    public PackageVersionStatus expectedStatus() {
        return PackageVersionStatus.fromValue(expectedStatus);
    }

    /**
     * <p>
     * The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided, the
     * package version's status is updated only if its status at the time <code>UpdatePackageVersionsStatus</code> is
     * called matches <code>expectedStatus</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #expectedStatus}
     * will return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #expectedStatusAsString}.
     * </p>
     * 
     * @return The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided,
     *         the package version's status is updated only if its status at the time
     *         <code>UpdatePackageVersionsStatus</code> is called matches <code>expectedStatus</code>.
     * @see PackageVersionStatus
     */
    public String expectedStatusAsString() {
        return expectedStatus;
    }

    /**
     * <p>
     * The status you want to change the package version status to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The status you want to change the package version status to.
     * @see PackageVersionStatus
     */
    public PackageVersionStatus targetStatus() {
        return PackageVersionStatus.fromValue(targetStatus);
    }

    /**
     * <p>
     * The status you want to change the package version status to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The status you want to change the package version status to.
     * @see PackageVersionStatus
     */
    public String targetStatusAsString() {
        return targetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasVersions() ? versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVersionRevisions() ? versionRevisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expectedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageVersionsStatusRequest)) {
            return false;
        }
        UpdatePackageVersionsStatusRequest other = (UpdatePackageVersionsStatusRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(packageValue(), other.packageValue())
                && hasVersions() == other.hasVersions() && Objects.equals(versions(), other.versions())
                && hasVersionRevisions() == other.hasVersionRevisions()
                && Objects.equals(versionRevisions(), other.versionRevisions())
                && Objects.equals(expectedStatusAsString(), other.expectedStatusAsString())
                && Objects.equals(targetStatusAsString(), other.targetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdatePackageVersionsStatusRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("Repository", repository()).add("Format", formatAsString()).add("Namespace", namespace())
                .add("Package", packageValue()).add("Versions", hasVersions() ? versions() : null)
                .add("VersionRevisions", hasVersionRevisions() ? versionRevisions() : null)
                .add("ExpectedStatus", expectedStatusAsString()).add("TargetStatus", targetStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "versionRevisions":
            return Optional.ofNullable(clazz.cast(versionRevisions()));
        case "expectedStatus":
            return Optional.ofNullable(clazz.cast(expectedStatusAsString()));
        case "targetStatus":
            return Optional.ofNullable(clazz.cast(targetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageVersionsStatusRequest, T> g) {
        return obj -> g.apply((UpdatePackageVersionsStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePackageVersionsStatusRequest> {
        /**
         * <p>
         * The domain that contains the repository that contains the package versions with a status to be updated.
         * </p>
         * 
         * @param domain
         *        The domain that contains the repository that contains the package versions with a status to be
         *        updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The repository that contains the package versions with the status you want to update.
         * </p>
         * 
         * @param repository
         *        The repository that contains the package versions with the status you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * A format that specifies the type of the package with the statuses to update. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        A format that specifies the type of the package with the statuses to update. The valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * A format that specifies the type of the package with the statuses to update. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        A format that specifies the type of the package with the statuses to update. The valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package. The package component that specifies its namespace depends on its type. For
         * example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm package is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package. The package component that specifies its namespace depends on its type.
         *        For example: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm package is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A Python package does not contain a corresponding component, so Python packages do not have a
         *        namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package with the version statuses to update.
         * </p>
         * 
         * @param packageValue
         *        The name of the package with the version statuses to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * An array of strings that specify the versions of the package with the statuses to update.
         * </p>
         * 
         * @param versions
         *        An array of strings that specify the versions of the package with the statuses to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<String> versions);

        /**
         * <p>
         * An array of strings that specify the versions of the package with the statuses to update.
         * </p>
         * 
         * @param versions
         *        An array of strings that specify the versions of the package with the statuses to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(String... versions);

        /**
         * <p>
         * A map of package versions and package version revisions. The map <code>key</code> is the package version (for
         * example, <code>3.5.2</code>), and the map <code>value</code> is the package version revision.
         * </p>
         * 
         * @param versionRevisions
         *        A map of package versions and package version revisions. The map <code>key</code> is the package
         *        version (for example, <code>3.5.2</code>), and the map <code>value</code> is the package version
         *        revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionRevisions(Map<String, String> versionRevisions);

        /**
         * <p>
         * The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided, the
         * package version's status is updated only if its status at the time <code>UpdatePackageVersionsStatus</code>
         * is called matches <code>expectedStatus</code>.
         * </p>
         * 
         * @param expectedStatus
         *        The package version’s expected status before it is updated. If <code>expectedStatus</code> is
         *        provided, the package version's status is updated only if its status at the time
         *        <code>UpdatePackageVersionsStatus</code> is called matches <code>expectedStatus</code>.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder expectedStatus(String expectedStatus);

        /**
         * <p>
         * The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided, the
         * package version's status is updated only if its status at the time <code>UpdatePackageVersionsStatus</code>
         * is called matches <code>expectedStatus</code>.
         * </p>
         * 
         * @param expectedStatus
         *        The package version’s expected status before it is updated. If <code>expectedStatus</code> is
         *        provided, the package version's status is updated only if its status at the time
         *        <code>UpdatePackageVersionsStatus</code> is called matches <code>expectedStatus</code>.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder expectedStatus(PackageVersionStatus expectedStatus);

        /**
         * <p>
         * The status you want to change the package version status to.
         * </p>
         * 
         * @param targetStatus
         *        The status you want to change the package version status to.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder targetStatus(String targetStatus);

        /**
         * <p>
         * The status you want to change the package version status to.
         * </p>
         * 
         * @param targetStatus
         *        The status you want to change the package version status to.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder targetStatus(PackageVersionStatus targetStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String format;

        private String namespace;

        private String packageValue;

        private List<String> versions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> versionRevisions = DefaultSdkAutoConstructMap.getInstance();

        private String expectedStatus;

        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageVersionsStatusRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            versions(model.versions);
            versionRevisions(model.versionRevisions);
            expectedStatus(model.expectedStatus);
            targetStatus(model.targetStatus);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        public final Collection<String> getVersions() {
            if (versions instanceof SdkAutoConstructList) {
                return null;
            }
            return versions;
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = PackageVersionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = PackageVersionListCopier.copy(versions);
        }

        public final Map<String, String> getVersionRevisions() {
            if (versionRevisions instanceof SdkAutoConstructMap) {
                return null;
            }
            return versionRevisions;
        }

        @Override
        public final Builder versionRevisions(Map<String, String> versionRevisions) {
            this.versionRevisions = PackageVersionRevisionMapCopier.copy(versionRevisions);
            return this;
        }

        public final void setVersionRevisions(Map<String, String> versionRevisions) {
            this.versionRevisions = PackageVersionRevisionMapCopier.copy(versionRevisions);
        }

        public final String getExpectedStatus() {
            return expectedStatus;
        }

        @Override
        public final Builder expectedStatus(String expectedStatus) {
            this.expectedStatus = expectedStatus;
            return this;
        }

        @Override
        public final Builder expectedStatus(PackageVersionStatus expectedStatus) {
            this.expectedStatus(expectedStatus == null ? null : expectedStatus.toString());
            return this;
        }

        public final void setExpectedStatus(String expectedStatus) {
            this.expectedStatus = expectedStatus;
        }

        public final String getTargetStatus() {
            return targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(PackageVersionStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageVersionsStatusRequest build() {
            return new UpdatePackageVersionsStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
