/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRepositoryPermissionsPolicyRequest extends CodeartifactRequest implements
        ToCopyableBuilder<DeleteRepositoryPermissionsPolicyRequest.Builder, DeleteRepositoryPermissionsPolicyRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(DeleteRepositoryPermissionsPolicyRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(DeleteRepositoryPermissionsPolicyRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(DeleteRepositoryPermissionsPolicyRequest::repository))
            .setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> POLICY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyRevision").getter(getter(DeleteRepositoryPermissionsPolicyRequest::policyRevision))
            .setter(setter(Builder::policyRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("policy-revision").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, POLICY_REVISION_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String policyRevision;

    private DeleteRepositoryPermissionsPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.policyRevision = builder.policyRevision;
    }

    /**
     * <p>
     * The name of the domain that contains the repository associated with the resource policy to be deleted.
     * </p>
     * 
     * @return The name of the domain that contains the repository associated with the resource policy to be deleted.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The name of the repository that is associated with the resource policy to be deleted
     * </p>
     * 
     * @return The name of the repository that is associated with the resource policy to be deleted
     */
    public String repository() {
        return repository;
    }

    /**
     * <p>
     * The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking,
     * which prevents others from accidentally overwriting your changes to the repository's resource policy.
     * </p>
     * 
     * @return The revision of the repository's resource policy to be deleted. This revision is used for optimistic
     *         locking, which prevents others from accidentally overwriting your changes to the repository's resource
     *         policy.
     */
    public String policyRevision() {
        return policyRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(policyRevision());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRepositoryPermissionsPolicyRequest)) {
            return false;
        }
        DeleteRepositoryPermissionsPolicyRequest other = (DeleteRepositoryPermissionsPolicyRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository()) && Objects.equals(policyRevision(), other.policyRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteRepositoryPermissionsPolicyRequest").add("Domain", domain())
                .add("DomainOwner", domainOwner()).add("Repository", repository()).add("PolicyRevision", policyRevision())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "policyRevision":
            return Optional.ofNullable(clazz.cast(policyRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRepositoryPermissionsPolicyRequest, T> g) {
        return obj -> g.apply((DeleteRepositoryPermissionsPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRepositoryPermissionsPolicyRequest> {
        /**
         * <p>
         * The name of the domain that contains the repository associated with the resource policy to be deleted.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the repository associated with the resource policy to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The name of the repository that is associated with the resource policy to be deleted
         * </p>
         * 
         * @param repository
         *        The name of the repository that is associated with the resource policy to be deleted
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking,
         * which prevents others from accidentally overwriting your changes to the repository's resource policy.
         * </p>
         * 
         * @param policyRevision
         *        The revision of the repository's resource policy to be deleted. This revision is used for optimistic
         *        locking, which prevents others from accidentally overwriting your changes to the repository's resource
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRevision(String policyRevision);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String policyRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRepositoryPermissionsPolicyRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            policyRevision(model.policyRevision);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getPolicyRevision() {
            return policyRevision;
        }

        @Override
        public final Builder policyRevision(String policyRevision) {
            this.policyRevision = policyRevision;
            return this;
        }

        public final void setPolicyRevision(String policyRevision) {
            this.policyRevision = policyRevision;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRepositoryPermissionsPolicyRequest build() {
            return new DeleteRepositoryPermissionsPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
