/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackageVersionAssetsResponse extends CodeartifactResponse implements
        ToCopyableBuilder<ListPackageVersionAssetsResponse.Builder, ListPackageVersionAssetsResponse> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ListPackageVersionAssetsResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListPackageVersionAssetsResponse::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(ListPackageVersionAssetsResponse::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ListPackageVersionAssetsResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> VERSION_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionRevision").getter(getter(ListPackageVersionAssetsResponse::versionRevision))
            .setter(setter(Builder::versionRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevision").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPackageVersionAssetsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AssetSummary>> ASSETS_FIELD = SdkField
            .<List<AssetSummary>> builder(MarshallingType.LIST)
            .memberName("assets")
            .getter(getter(ListPackageVersionAssetsResponse::assets))
            .setter(setter(Builder::assets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD,
            PACKAGE_FIELD, VERSION_FIELD, VERSION_REVISION_FIELD, NEXT_TOKEN_FIELD, ASSETS_FIELD));

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final String version;

    private final String versionRevision;

    private final String nextToken;

    private final List<AssetSummary> assets;

    private ListPackageVersionAssetsResponse(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.version = builder.version;
        this.versionRevision = builder.versionRevision;
        this.nextToken = builder.nextToken;
        this.assets = builder.assets;
    }

    /**
     * <p>
     * The format of the package that contains the returned package version assets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the package that contains the returned package version assets.
     * @see PackageFormat
     */
    public PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the package that contains the returned package version assets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the package that contains the returned package version assets.
     * @see PackageFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package. The package component that specifies its namespace depends on its type. For
     * example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm package is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package. The package component that specifies its namespace depends on its type. For
     *         example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm package is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     *         </p>
     *         </li>
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package that contains the returned package version assets.
     * </p>
     * 
     * @return The name of the package that contains the returned package version assets.
     */
    public String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * The version of the package associated with the returned assets.
     * </p>
     * 
     * @return The version of the package associated with the returned assets.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The current revision associated with the package version.
     * </p>
     * 
     * @return The current revision associated with the package version.
     */
    public String versionRevision() {
        return versionRevision;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Assets property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAssets() {
        return assets != null && !(assets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">
     * <code>AssetSummary</code> </a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The returned list of <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">
     *         <code>AssetSummary</code> </a> objects.
     */
    public List<AssetSummary> assets() {
        return assets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionRevision());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssets() ? assets() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionAssetsResponse)) {
            return false;
        }
        ListPackageVersionAssetsResponse other = (ListPackageVersionAssetsResponse) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(packageValue(), other.packageValue()) && Objects.equals(version(), other.version())
                && Objects.equals(versionRevision(), other.versionRevision()) && Objects.equals(nextToken(), other.nextToken())
                && hasAssets() == other.hasAssets() && Objects.equals(assets(), other.assets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPackageVersionAssetsResponse").add("Format", formatAsString()).add("Namespace", namespace())
                .add("Package", packageValue()).add("Version", version()).add("VersionRevision", versionRevision())
                .add("NextToken", nextToken()).add("Assets", hasAssets() ? assets() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "versionRevision":
            return Optional.ofNullable(clazz.cast(versionRevision()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "assets":
            return Optional.ofNullable(clazz.cast(assets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageVersionAssetsResponse, T> g) {
        return obj -> g.apply((ListPackageVersionAssetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPackageVersionAssetsResponse> {
        /**
         * <p>
         * The format of the package that contains the returned package version assets.
         * </p>
         * 
         * @param format
         *        The format of the package that contains the returned package version assets.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the package that contains the returned package version assets.
         * </p>
         * 
         * @param format
         *        The format of the package that contains the returned package version assets.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package. The package component that specifies its namespace depends on its type. For
         * example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm package is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package. The package component that specifies its namespace depends on its type.
         *        For example: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm package is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A Python package does not contain a corresponding component, so Python packages do not have a
         *        namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package that contains the returned package version assets.
         * </p>
         * 
         * @param packageValue
         *        The name of the package that contains the returned package version assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * The version of the package associated with the returned assets.
         * </p>
         * 
         * @param version
         *        The version of the package associated with the returned assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The current revision associated with the package version.
         * </p>
         * 
         * @param versionRevision
         *        The current revision associated with the package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionRevision(String versionRevision);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">
         * <code>AssetSummary</code> </a> objects.
         * </p>
         * 
         * @param assets
         *        The returned list of <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">
         *        <code>AssetSummary</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(Collection<AssetSummary> assets);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">
         * <code>AssetSummary</code> </a> objects.
         * </p>
         * 
         * @param assets
         *        The returned list of <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">
         *        <code>AssetSummary</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(AssetSummary... assets);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">
         * <code>AssetSummary</code> </a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetSummary>.Builder} avoiding the need to
         * create one manually via {@link List<AssetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #assets(List<AssetSummary>)}.
         * 
         * @param assets
         *        a consumer that will call methods on {@link List<AssetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assets(List<AssetSummary>)
         */
        Builder assets(Consumer<AssetSummary.Builder>... assets);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private String format;

        private String namespace;

        private String packageValue;

        private String version;

        private String versionRevision;

        private String nextToken;

        private List<AssetSummary> assets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageVersionAssetsResponse model) {
            super(model);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            version(model.version);
            versionRevision(model.versionRevision);
            nextToken(model.nextToken);
            assets(model.assets);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getVersionRevision() {
            return versionRevision;
        }

        @Override
        public final Builder versionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
            return this;
        }

        public final void setVersionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<AssetSummary.Builder> getAssets() {
            if (assets instanceof SdkAutoConstructList) {
                return null;
            }
            return assets != null ? assets.stream().map(AssetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assets(Collection<AssetSummary> assets) {
            this.assets = AssetSummaryListCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(AssetSummary... assets) {
            assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<AssetSummary.Builder>... assets) {
            assets(Stream.of(assets).map(c -> AssetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssets(Collection<AssetSummary.BuilderImpl> assets) {
            this.assets = AssetSummaryListCopier.copyFromBuilder(assets);
        }

        @Override
        public ListPackageVersionAssetsResponse build() {
            return new ListPackageVersionAssetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
