/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackageVersionsRequest extends CodeartifactRequest implements
        ToCopyableBuilder<ListPackageVersionsRequest.Builder, ListPackageVersionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(ListPackageVersionsRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(ListPackageVersionsRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(ListPackageVersionsRequest::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ListPackageVersionsRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListPackageVersionsRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(ListPackageVersionsRequest::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListPackageVersionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListPackageVersionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListPackageVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPackageVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, STATUS_FIELD, SORT_BY_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final String status;

    private final String sortBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListPackageVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.status = builder.status;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the domain that contains the repository that contains the returned package versions.
     * </p>
     * 
     * @return The name of the domain that contains the repository that contains the returned package versions.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The name of the repository that contains the package.
     * </p>
     * 
     * @return The name of the repository that contains the package.
     */
    public String repository() {
        return repository;
    }

    /**
     * <p>
     * The format of the returned packages. The valid package types are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>: A Node Package Manager (npm) package.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>: A Python Package Index (PyPI) package.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the returned packages. The valid package types are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>: A Node Package Manager (npm) package.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>: A Python Package Index (PyPI) package.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR
     *         file.
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the returned packages. The valid package types are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>: A Node Package Manager (npm) package.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>: A Python Package Index (PyPI) package.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the returned packages. The valid package types are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>: A Node Package Manager (npm) package.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>: A Python Package Index (PyPI) package.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR
     *         file.
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package. The package component that specifies its namespace depends on its type. For
     * example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm package is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package. The package component that specifies its namespace depends on its type. For
     *         example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm package is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     *         </p>
     *         </li>
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package for which you want to return a list of package versions.
     * </p>
     * 
     * @return The name of the package for which you want to return a list of package versions.
     */
    public String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * A string that specifies the status of the package versions to include in the returned list. It can be one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Published</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unfinished</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unlisted</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Disposed</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A string that specifies the status of the package versions to include in the returned list. It can be one
     *         of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Published</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unfinished</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unlisted</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Disposed</code>
     *         </p>
     *         </li>
     * @see PackageVersionStatus
     */
    public PackageVersionStatus status() {
        return PackageVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * A string that specifies the status of the package versions to include in the returned list. It can be one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Published</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unfinished</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unlisted</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Disposed</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A string that specifies the status of the package versions to include in the returned list. It can be one
     *         of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Published</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unfinished</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unlisted</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Disposed</code>
     *         </p>
     *         </li>
     * @see PackageVersionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * How to sort the returned list of package versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link PackageVersionSortType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return How to sort the returned list of package versions.
     * @see PackageVersionSortType
     */
    public PackageVersionSortType sortBy() {
        return PackageVersionSortType.fromValue(sortBy);
    }

    /**
     * <p>
     * How to sort the returned list of package versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link PackageVersionSortType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return How to sort the returned list of package versions.
     * @see PackageVersionSortType
     */
    public String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionsRequest)) {
            return false;
        }
        ListPackageVersionsRequest other = (ListPackageVersionsRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(packageValue(), other.packageValue())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPackageVersionsRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("Repository", repository()).add("Format", formatAsString()).add("Namespace", namespace())
                .add("Package", packageValue()).add("Status", statusAsString()).add("SortBy", sortByAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageVersionsRequest, T> g) {
        return obj -> g.apply((ListPackageVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPackageVersionsRequest> {
        /**
         * <p>
         * The name of the domain that contains the repository that contains the returned package versions.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the repository that contains the returned package versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The name of the repository that contains the package.
         * </p>
         * 
         * @param repository
         *        The name of the repository that contains the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The format of the returned packages. The valid package types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>: A Node Package Manager (npm) package.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>: A Python Package Index (PyPI) package.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR
         * file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        The format of the returned packages. The valid package types are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>: A Node Package Manager (npm) package.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>: A Python Package Index (PyPI) package.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a
         *        JAR file.
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the returned packages. The valid package types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>: A Node Package Manager (npm) package.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>: A Python Package Index (PyPI) package.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR
         * file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        The format of the returned packages. The valid package types are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>: A Node Package Manager (npm) package.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>: A Python Package Index (PyPI) package.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a
         *        JAR file.
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package. The package component that specifies its namespace depends on its type. For
         * example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm package is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package. The package component that specifies its namespace depends on its type.
         *        For example: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm package is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A Python package does not contain a corresponding component, so Python packages do not have a
         *        namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package for which you want to return a list of package versions.
         * </p>
         * 
         * @param packageValue
         *        The name of the package for which you want to return a list of package versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * A string that specifies the status of the package versions to include in the returned list. It can be one of
         * the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Published</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unfinished</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unlisted</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Disposed</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A string that specifies the status of the package versions to include in the returned list. It can be
         *        one of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Published</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unfinished</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unlisted</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Disposed</code>
         *        </p>
         *        </li>
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A string that specifies the status of the package versions to include in the returned list. It can be one of
         * the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Published</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unfinished</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unlisted</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Disposed</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A string that specifies the status of the package versions to include in the returned list. It can be
         *        one of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Published</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unfinished</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unlisted</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Disposed</code>
         *        </p>
         *        </li>
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder status(PackageVersionStatus status);

        /**
         * <p>
         * How to sort the returned list of package versions.
         * </p>
         * 
         * @param sortBy
         *        How to sort the returned list of package versions.
         * @see PackageVersionSortType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionSortType
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * How to sort the returned list of package versions.
         * </p>
         * 
         * @param sortBy
         *        How to sort the returned list of package versions.
         * @see PackageVersionSortType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionSortType
         */
        Builder sortBy(PackageVersionSortType sortBy);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String format;

        private String namespace;

        private String packageValue;

        private String status;

        private String sortBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageVersionsRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            status(model.status);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PackageVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(PackageVersionSortType sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPackageVersionsRequest build() {
            return new ListPackageVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
