/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo;
import software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfoListCopier;
import software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo;
import software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryDescription> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RepositoryDescription.getter(RepositoryDescription::name)).setter(RepositoryDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ADMINISTRATOR_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("administratorAccount").getter(RepositoryDescription.getter(RepositoryDescription::administratorAccount)).setter(RepositoryDescription.setter(Builder::administratorAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("administratorAccount").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(RepositoryDescription.getter(RepositoryDescription::domainName)).setter(RepositoryDescription.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(RepositoryDescription.getter(RepositoryDescription::domainOwner)).setter(RepositoryDescription.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainOwner").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RepositoryDescription.getter(RepositoryDescription::arn)).setter(RepositoryDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RepositoryDescription.getter(RepositoryDescription::description)).setter(RepositoryDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<UpstreamRepositoryInfo>> UPSTREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("upstreams").getter(RepositoryDescription.getter(RepositoryDescription::upstreams)).setter(RepositoryDescription.setter(Builder::upstreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpstreamRepositoryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RepositoryExternalConnectionInfo>> EXTERNAL_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("externalConnections").getter(RepositoryDescription.getter(RepositoryDescription::externalConnections)).setter(RepositoryDescription.setter(Builder::externalConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalConnections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryExternalConnectionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ADMINISTRATOR_ACCOUNT_FIELD, DOMAIN_NAME_FIELD, DOMAIN_OWNER_FIELD, ARN_FIELD, DESCRIPTION_FIELD, UPSTREAMS_FIELD, EXTERNAL_CONNECTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String administratorAccount;
    private final String domainName;
    private final String domainOwner;
    private final String arn;
    private final String description;
    private final List<UpstreamRepositoryInfo> upstreams;
    private final List<RepositoryExternalConnectionInfo> externalConnections;

    private RepositoryDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.administratorAccount = builder.administratorAccount;
        this.domainName = builder.domainName;
        this.domainOwner = builder.domainOwner;
        this.arn = builder.arn;
        this.description = builder.description;
        this.upstreams = builder.upstreams;
        this.externalConnections = builder.externalConnections;
    }

    public String name() {
        return this.name;
    }

    public String administratorAccount() {
        return this.administratorAccount;
    }

    public String domainName() {
        return this.domainName;
    }

    public String domainOwner() {
        return this.domainOwner;
    }

    public String arn() {
        return this.arn;
    }

    public String description() {
        return this.description;
    }

    public boolean hasUpstreams() {
        return this.upstreams != null && !(this.upstreams instanceof SdkAutoConstructList);
    }

    public List<UpstreamRepositoryInfo> upstreams() {
        return this.upstreams;
    }

    public boolean hasExternalConnections() {
        return this.externalConnections != null && !(this.externalConnections instanceof SdkAutoConstructList);
    }

    public List<RepositoryExternalConnectionInfo> externalConnections() {
        return this.externalConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.administratorAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpstreams() ? this.upstreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalConnections() ? this.externalConnections() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryDescription)) {
            return false;
        }
        RepositoryDescription other = (RepositoryDescription)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.administratorAccount(), other.administratorAccount()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasUpstreams() == other.hasUpstreams() && Objects.equals(this.upstreams(), other.upstreams()) && this.hasExternalConnections() == other.hasExternalConnections() && Objects.equals(this.externalConnections(), other.externalConnections());
    }

    public String toString() {
        return ToString.builder((String)"RepositoryDescription").add("Name", (Object)this.name()).add("AdministratorAccount", (Object)this.administratorAccount()).add("DomainName", (Object)this.domainName()).add("DomainOwner", (Object)this.domainOwner()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Upstreams", this.hasUpstreams() ? this.upstreams() : null).add("ExternalConnections", this.hasExternalConnections() ? this.externalConnections() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "administratorAccount": {
                return Optional.ofNullable(clazz.cast(this.administratorAccount()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "upstreams": {
                return Optional.ofNullable(clazz.cast(this.upstreams()));
            }
            case "externalConnections": {
                return Optional.ofNullable(clazz.cast(this.externalConnections()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryDescription, T> g) {
        return obj -> g.apply((RepositoryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String administratorAccount;
        private String domainName;
        private String domainOwner;
        private String arn;
        private String description;
        private List<UpstreamRepositoryInfo> upstreams = DefaultSdkAutoConstructList.getInstance();
        private List<RepositoryExternalConnectionInfo> externalConnections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryDescription model) {
            this.name(model.name);
            this.administratorAccount(model.administratorAccount);
            this.domainName(model.domainName);
            this.domainOwner(model.domainOwner);
            this.arn(model.arn);
            this.description(model.description);
            this.upstreams(model.upstreams);
            this.externalConnections(model.externalConnections);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAdministratorAccount() {
            return this.administratorAccount;
        }

        @Override
        public final Builder administratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
            return this;
        }

        public final void setAdministratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<UpstreamRepositoryInfo.Builder> getUpstreams() {
            if (this.upstreams instanceof SdkAutoConstructList) {
                return null;
            }
            return this.upstreams != null ? (Collection)this.upstreams.stream().map(UpstreamRepositoryInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder upstreams(Collection<UpstreamRepositoryInfo> upstreams) {
            this.upstreams = UpstreamRepositoryInfoListCopier.copy(upstreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(UpstreamRepositoryInfo ... upstreams) {
            this.upstreams(Arrays.asList(upstreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(Consumer<UpstreamRepositoryInfo.Builder> ... upstreams) {
            this.upstreams(Stream.of(upstreams).map(c -> (UpstreamRepositoryInfo)((UpstreamRepositoryInfo.Builder)UpstreamRepositoryInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpstreams(Collection<UpstreamRepositoryInfo.BuilderImpl> upstreams) {
            this.upstreams = UpstreamRepositoryInfoListCopier.copyFromBuilder(upstreams);
        }

        public final Collection<RepositoryExternalConnectionInfo.Builder> getExternalConnections() {
            if (this.externalConnections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.externalConnections != null ? (Collection)this.externalConnections.stream().map(RepositoryExternalConnectionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder externalConnections(Collection<RepositoryExternalConnectionInfo> externalConnections) {
            this.externalConnections = RepositoryExternalConnectionInfoListCopier.copy(externalConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalConnections(RepositoryExternalConnectionInfo ... externalConnections) {
            this.externalConnections(Arrays.asList(externalConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalConnections(Consumer<RepositoryExternalConnectionInfo.Builder> ... externalConnections) {
            this.externalConnections(Stream.of(externalConnections).map(c -> (RepositoryExternalConnectionInfo)((RepositoryExternalConnectionInfo.Builder)RepositoryExternalConnectionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExternalConnections(Collection<RepositoryExternalConnectionInfo.BuilderImpl> externalConnections) {
            this.externalConnections = RepositoryExternalConnectionInfoListCopier.copyFromBuilder(externalConnections);
        }

        public RepositoryDescription build() {
            return new RepositoryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryDescription> {
        public Builder name(String var1);

        public Builder administratorAccount(String var1);

        public Builder domainName(String var1);

        public Builder domainOwner(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder upstreams(Collection<UpstreamRepositoryInfo> var1);

        public Builder upstreams(UpstreamRepositoryInfo ... var1);

        public Builder upstreams(Consumer<UpstreamRepositoryInfo.Builder> ... var1);

        public Builder externalConnections(Collection<RepositoryExternalConnectionInfo> var1);

        public Builder externalConnections(RepositoryExternalConnectionInfo ... var1);

        public Builder externalConnections(Consumer<RepositoryExternalConnectionInfo.Builder> ... var1);
    }
}

