/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackageVersionsResponse extends CodeartifactResponse implements
        ToCopyableBuilder<ListPackageVersionsResponse.Builder, ListPackageVersionsResponse> {
    private static final SdkField<String> DEFAULT_DISPLAY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultDisplayVersion").getter(getter(ListPackageVersionsResponse::defaultDisplayVersion))
            .setter(setter(Builder::defaultDisplayVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDisplayVersion").build())
            .build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ListPackageVersionsResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListPackageVersionsResponse::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(ListPackageVersionsResponse::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()).build();

    private static final SdkField<List<PackageVersionSummary>> VERSIONS_FIELD = SdkField
            .<List<PackageVersionSummary>> builder(MarshallingType.LIST)
            .memberName("versions")
            .getter(getter(ListPackageVersionsResponse::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPackageVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_DISPLAY_VERSION_FIELD,
            FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, VERSIONS_FIELD, NEXT_TOKEN_FIELD));

    private final String defaultDisplayVersion;

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final List<PackageVersionSummary> versions;

    private final String nextToken;

    private ListPackageVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.defaultDisplayVersion = builder.defaultDisplayVersion;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.versions = builder.versions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The default package version to display. This depends on the package format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Maven and PyPI packages, it's the most recently published package version.
     * </p>
     * </li>
     * <li>
     * <p>
     * For npm packages, it's the version referenced by the <code>latest</code> tag. If the <code>latest</code> tag is
     * not set, it's the most recently published package version.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The default package version to display. This depends on the package format: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Maven and PyPI packages, it's the most recently published package version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For npm packages, it's the version referenced by the <code>latest</code> tag. If the <code>latest</code>
     *         tag is not set, it's the most recently published package version.
     *         </p>
     *         </li>
     */
    public String defaultDisplayVersion() {
        return defaultDisplayVersion;
    }

    /**
     * <p>
     * A format of the package. Valid package format values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format of the package. Valid package format values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * A format of the package. Valid package format values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format of the package. Valid package format values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package. The package component that specifies its namespace depends on its type. For
     * example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm package is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package. The package component that specifies its namespace depends on its type. For
     *         example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm package is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     *         </p>
     *         </li>
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package.
     * </p>
     * 
     * @return The name of the package.
     */
    public String packageValue() {
        return packageValue;
    }

    /**
     * Returns true if the Versions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">
     * <code>PackageVersionSummary</code> </a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The returned list of <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">
     *         <code>PackageVersionSummary</code> </a> objects.
     */
    public List<PackageVersionSummary> versions() {
        return versions;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(defaultDisplayVersion());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(versions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionsResponse)) {
            return false;
        }
        ListPackageVersionsResponse other = (ListPackageVersionsResponse) obj;
        return Objects.equals(defaultDisplayVersion(), other.defaultDisplayVersion())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(packageValue(), other.packageValue()) && Objects.equals(versions(), other.versions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPackageVersionsResponse").add("DefaultDisplayVersion", defaultDisplayVersion())
                .add("Format", formatAsString()).add("Namespace", namespace()).add("Package", packageValue())
                .add("Versions", versions()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultDisplayVersion":
            return Optional.ofNullable(clazz.cast(defaultDisplayVersion()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageVersionsResponse, T> g) {
        return obj -> g.apply((ListPackageVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPackageVersionsResponse> {
        /**
         * <p>
         * The default package version to display. This depends on the package format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Maven and PyPI packages, it's the most recently published package version.
         * </p>
         * </li>
         * <li>
         * <p>
         * For npm packages, it's the version referenced by the <code>latest</code> tag. If the <code>latest</code> tag
         * is not set, it's the most recently published package version.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultDisplayVersion
         *        The default package version to display. This depends on the package format: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Maven and PyPI packages, it's the most recently published package version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For npm packages, it's the version referenced by the <code>latest</code> tag. If the
         *        <code>latest</code> tag is not set, it's the most recently published package version.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDisplayVersion(String defaultDisplayVersion);

        /**
         * <p>
         * A format of the package. Valid package format values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        A format of the package. Valid package format values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * A format of the package. Valid package format values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        A format of the package. Valid package format values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package. The package component that specifies its namespace depends on its type. For
         * example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm package is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package. The package component that specifies its namespace depends on its type.
         *        For example: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm package is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A Python package does not contain a corresponding component, so Python packages do not have a
         *        namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package.
         * </p>
         * 
         * @param packageValue
         *        The name of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">
         * <code>PackageVersionSummary</code> </a> objects.
         * </p>
         * 
         * @param versions
         *        The returned list of <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">
         *        <code>PackageVersionSummary</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<PackageVersionSummary> versions);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">
         * <code>PackageVersionSummary</code> </a> objects.
         * </p>
         * 
         * @param versions
         *        The returned list of <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">
         *        <code>PackageVersionSummary</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(PackageVersionSummary... versions);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">
         * <code>PackageVersionSummary</code> </a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PackageVersionSummary>.Builder} avoiding
         * the need to create one manually via {@link List<PackageVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackageVersionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #versions(List<PackageVersionSummary>)}.
         * 
         * @param versions
         *        a consumer that will call methods on {@link List<PackageVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versions(List<PackageVersionSummary>)
         */
        Builder versions(Consumer<PackageVersionSummary.Builder>... versions);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private String defaultDisplayVersion;

        private String format;

        private String namespace;

        private String packageValue;

        private List<PackageVersionSummary> versions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageVersionsResponse model) {
            super(model);
            defaultDisplayVersion(model.defaultDisplayVersion);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            versions(model.versions);
            nextToken(model.nextToken);
        }

        public final String getDefaultDisplayVersion() {
            return defaultDisplayVersion;
        }

        @Override
        public final Builder defaultDisplayVersion(String defaultDisplayVersion) {
            this.defaultDisplayVersion = defaultDisplayVersion;
            return this;
        }

        public final void setDefaultDisplayVersion(String defaultDisplayVersion) {
            this.defaultDisplayVersion = defaultDisplayVersion;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        public final Collection<PackageVersionSummary.Builder> getVersions() {
            return versions != null ? versions.stream().map(PackageVersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<PackageVersionSummary> versions) {
            this.versions = PackageVersionSummaryListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(PackageVersionSummary... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<PackageVersionSummary.Builder>... versions) {
            versions(Stream.of(versions).map(c -> PackageVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVersions(Collection<PackageVersionSummary.BuilderImpl> versions) {
            this.versions = PackageVersionSummaryListCopier.copyFromBuilder(versions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPackageVersionsResponse build() {
            return new ListPackageVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
