/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositoriesInDomainRequest extends CodeartifactRequest implements
        ToCopyableBuilder<ListRepositoriesInDomainRequest.Builder, ListRepositoriesInDomainRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(ListRepositoriesInDomainRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(ListRepositoriesInDomainRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> ADMINISTRATOR_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("administratorAccount").getter(getter(ListRepositoriesInDomainRequest::administratorAccount))
            .setter(setter(Builder::administratorAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("administrator-account").build())
            .build();

    private static final SdkField<String> REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryPrefix").getter(getter(ListRepositoriesInDomainRequest::repositoryPrefix))
            .setter(setter(Builder::repositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository-prefix").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRepositoriesInDomainRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRepositoriesInDomainRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, ADMINISTRATOR_ACCOUNT_FIELD, REPOSITORY_PREFIX_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String administratorAccount;

    private final String repositoryPrefix;

    private final Integer maxResults;

    private final String nextToken;

    private ListRepositoriesInDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.administratorAccount = builder.administratorAccount;
        this.repositoryPrefix = builder.repositoryPrefix;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the domain that contains the returned list of repositories.
     * </p>
     * 
     * @return The name of the domain that contains the returned list of repositories.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * Filter the list of repositories to only include those that are managed by the AWS account ID.
     * </p>
     * 
     * @return Filter the list of repositories to only include those that are managed by the AWS account ID.
     */
    public final String administratorAccount() {
        return administratorAccount;
    }

    /**
     * <p>
     * A prefix used to filter returned repositories. Only repositories with names that start with
     * <code>repositoryPrefix</code> are returned.
     * </p>
     * 
     * @return A prefix used to filter returned repositories. Only repositories with names that start with
     *         <code>repositoryPrefix</code> are returned.
     */
    public final String repositoryPrefix() {
        return repositoryPrefix;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(administratorAccount());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesInDomainRequest)) {
            return false;
        }
        ListRepositoriesInDomainRequest other = (ListRepositoriesInDomainRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(administratorAccount(), other.administratorAccount())
                && Objects.equals(repositoryPrefix(), other.repositoryPrefix())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRepositoriesInDomainRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("AdministratorAccount", administratorAccount()).add("RepositoryPrefix", repositoryPrefix())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "administratorAccount":
            return Optional.ofNullable(clazz.cast(administratorAccount()));
        case "repositoryPrefix":
            return Optional.ofNullable(clazz.cast(repositoryPrefix()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoriesInDomainRequest, T> g) {
        return obj -> g.apply((ListRepositoriesInDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRepositoriesInDomainRequest> {
        /**
         * <p>
         * The name of the domain that contains the returned list of repositories.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the returned list of repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * Filter the list of repositories to only include those that are managed by the AWS account ID.
         * </p>
         * 
         * @param administratorAccount
         *        Filter the list of repositories to only include those that are managed by the AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administratorAccount(String administratorAccount);

        /**
         * <p>
         * A prefix used to filter returned repositories. Only repositories with names that start with
         * <code>repositoryPrefix</code> are returned.
         * </p>
         * 
         * @param repositoryPrefix
         *        A prefix used to filter returned repositories. Only repositories with names that start with
         *        <code>repositoryPrefix</code> are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryPrefix(String repositoryPrefix);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String administratorAccount;

        private String repositoryPrefix;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoriesInDomainRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            administratorAccount(model.administratorAccount);
            repositoryPrefix(model.repositoryPrefix);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getAdministratorAccount() {
            return administratorAccount;
        }

        @Override
        public final Builder administratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
            return this;
        }

        public final void setAdministratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
        }

        public final String getRepositoryPrefix() {
            return repositoryPrefix;
        }

        @Override
        public final Builder repositoryPrefix(String repositoryPrefix) {
            this.repositoryPrefix = repositoryPrefix;
            return this;
        }

        public final void setRepositoryPrefix(String repositoryPrefix) {
            this.repositoryPrefix = repositoryPrefix;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositoriesInDomainRequest build() {
            return new ListRepositoriesInDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
