/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainRequest extends CodeartifactRequest implements
        ToCopyableBuilder<CreateDomainRequest.Builder, CreateDomainRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(CreateDomainRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKey").getter(getter(CreateDomainRequest::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            ENCRYPTION_KEY_FIELD));

    private final String domain;

    private final String encryptionKey;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.encryptionKey = builder.encryptionKey;
    }

    /**
     * <p>
     * The name of the domain to create. All domain names in an AWS Region that are in the same AWS account must be
     * unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive information in a domain name
     * because it is publicly discoverable.
     * </p>
     * 
     * @return The name of the domain to create. All domain names in an AWS Region that are in the same AWS account must
     *         be unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive information in a
     *         domain name because it is publicly discoverable.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The encryption key for the domain. This is used to encrypt content stored in a domain. An encryption key can be a
     * key ID, a key Amazon Resource Name (ARN), a key alias, or a key alias ARN. To specify an
     * <code>encryptionKey</code>, your IAM role must have <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code>
     * permissions on the encryption key that is used. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax"
     * >DescribeKey</a> in the <i>AWS Key Management Service API Reference</i> and <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API
     * Permissions Reference</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your domain. For more
     * information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using
     * symmetric and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * </important>
     * 
     * @return The encryption key for the domain. This is used to encrypt content stored in a domain. An encryption key
     *         can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key alias ARN. To specify an
     *         <code>encryptionKey</code>, your IAM role must have <code>kms:DescribeKey</code> and
     *         <code>kms:CreateGrant</code> permissions on the encryption key that is used. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax"
     *         >DescribeKey</a> in the <i>AWS Key Management Service API Reference</i> and <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS
     *         API Permissions Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p> <important>
     *         <p>
     *         CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your domain. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric
     *         and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.
     *         </p>
     */
    public String encryptionKey() {
        return encryptionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(encryptionKey(), other.encryptionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDomainRequest").add("Domain", domain()).add("EncryptionKey", encryptionKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainRequest> {
        /**
         * <p>
         * The name of the domain to create. All domain names in an AWS Region that are in the same AWS account must be
         * unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive information in a domain
         * name because it is publicly discoverable.
         * </p>
         * 
         * @param domain
         *        The name of the domain to create. All domain names in an AWS Region that are in the same AWS account
         *        must be unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive
         *        information in a domain name because it is publicly discoverable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The encryption key for the domain. This is used to encrypt content stored in a domain. An encryption key can
         * be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key alias ARN. To specify an
         * <code>encryptionKey</code>, your IAM role must have <code>kms:DescribeKey</code> and
         * <code>kms:CreateGrant</code> permissions on the encryption key that is used. For more information, see <a
         * href
         * ="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">
         * DescribeKey</a> in the <i>AWS Key Management Service API Reference</i> and <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API
         * Permissions Reference</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * <important>
         * <p>
         * CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your domain. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and
         * asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * </important>
         * 
         * @param encryptionKey
         *        The encryption key for the domain. This is used to encrypt content stored in a domain. An encryption
         *        key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key alias ARN. To specify an
         *        <code>encryptionKey</code>, your IAM role must have <code>kms:DescribeKey</code> and
         *        <code>kms:CreateGrant</code> permissions on the encryption key that is used. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax"
         *        >DescribeKey</a> in the <i>AWS Key Management Service API Reference</i> and <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS
         *        KMS API Permissions Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
         *        <important>
         *        <p>
         *        CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your domain. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric
         *        and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            domain(model.domain);
            encryptionKey(model.encryptionKey);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
