/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePackageVersionsResponse extends CodeartifactResponse implements
        ToCopyableBuilder<DeletePackageVersionsResponse.Builder, DeletePackageVersionsResponse> {
    private static final SdkField<Map<String, SuccessfulPackageVersionInfo>> SUCCESSFUL_VERSIONS_FIELD = SdkField
            .<Map<String, SuccessfulPackageVersionInfo>> builder(MarshallingType.MAP)
            .memberName("successfulVersions")
            .getter(getter(DeletePackageVersionsResponse::successfulVersions))
            .setter(setter(Builder::successfulVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulVersions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SuccessfulPackageVersionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuccessfulPackageVersionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, PackageVersionError>> FAILED_VERSIONS_FIELD = SdkField
            .<Map<String, PackageVersionError>> builder(MarshallingType.MAP)
            .memberName("failedVersions")
            .getter(getter(DeletePackageVersionsResponse::failedVersions))
            .setter(setter(Builder::failedVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedVersions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PackageVersionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageVersionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_VERSIONS_FIELD,
            FAILED_VERSIONS_FIELD));

    private final Map<String, SuccessfulPackageVersionInfo> successfulVersions;

    private final Map<String, PackageVersionError> failedVersions;

    private DeletePackageVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulVersions = builder.successfulVersions;
        this.failedVersions = builder.failedVersions;
    }

    /**
     * Returns true if the SuccessfulVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSuccessfulVersions() {
        return successfulVersions != null && !(successfulVersions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the package versions that were successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessfulVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the package versions that were successfully deleted.
     */
    public Map<String, SuccessfulPackageVersionInfo> successfulVersions() {
        return successfulVersions;
    }

    /**
     * Returns true if the FailedVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailedVersions() {
        return failedVersions != null && !(failedVersions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A <code>PackageVersionError</code> object that contains a map of errors codes for the deleted package that
     * failed. The possible error codes are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALREADY_EXISTS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MISMATCHED_REVISION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MISMATCHED_STATUS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_ALLOWED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_FOUND</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SKIPPED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A <code>PackageVersionError</code> object that contains a map of errors codes for the deleted package
     *         that failed. The possible error codes are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALREADY_EXISTS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MISMATCHED_REVISION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MISMATCHED_STATUS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_ALLOWED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_FOUND</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SKIPPED</code>
     *         </p>
     *         </li>
     */
    public Map<String, PackageVersionError> failedVersions() {
        return failedVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(successfulVersions());
        hashCode = 31 * hashCode + Objects.hashCode(failedVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePackageVersionsResponse)) {
            return false;
        }
        DeletePackageVersionsResponse other = (DeletePackageVersionsResponse) obj;
        return Objects.equals(successfulVersions(), other.successfulVersions())
                && Objects.equals(failedVersions(), other.failedVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePackageVersionsResponse").add("SuccessfulVersions", successfulVersions())
                .add("FailedVersions", failedVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "successfulVersions":
            return Optional.ofNullable(clazz.cast(successfulVersions()));
        case "failedVersions":
            return Optional.ofNullable(clazz.cast(failedVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePackageVersionsResponse, T> g) {
        return obj -> g.apply((DeletePackageVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeletePackageVersionsResponse> {
        /**
         * <p>
         * A list of the package versions that were successfully deleted.
         * </p>
         * 
         * @param successfulVersions
         *        A list of the package versions that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulVersions(Map<String, SuccessfulPackageVersionInfo> successfulVersions);

        /**
         * <p>
         * A <code>PackageVersionError</code> object that contains a map of errors codes for the deleted package that
         * failed. The possible error codes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALREADY_EXISTS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MISMATCHED_REVISION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MISMATCHED_STATUS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_ALLOWED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_FOUND</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SKIPPED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param failedVersions
         *        A <code>PackageVersionError</code> object that contains a map of errors codes for the deleted package
         *        that failed. The possible error codes are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALREADY_EXISTS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MISMATCHED_REVISION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MISMATCHED_STATUS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_ALLOWED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_FOUND</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SKIPPED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedVersions(Map<String, PackageVersionError> failedVersions);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private Map<String, SuccessfulPackageVersionInfo> successfulVersions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, PackageVersionError> failedVersions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePackageVersionsResponse model) {
            super(model);
            successfulVersions(model.successfulVersions);
            failedVersions(model.failedVersions);
        }

        public final Map<String, SuccessfulPackageVersionInfo.Builder> getSuccessfulVersions() {
            return successfulVersions != null ? CollectionUtils.mapValues(successfulVersions,
                    SuccessfulPackageVersionInfo::toBuilder) : null;
        }

        @Override
        public final Builder successfulVersions(Map<String, SuccessfulPackageVersionInfo> successfulVersions) {
            this.successfulVersions = SuccessfulPackageVersionInfoMapCopier.copy(successfulVersions);
            return this;
        }

        public final void setSuccessfulVersions(Map<String, SuccessfulPackageVersionInfo.BuilderImpl> successfulVersions) {
            this.successfulVersions = SuccessfulPackageVersionInfoMapCopier.copyFromBuilder(successfulVersions);
        }

        public final Map<String, PackageVersionError.Builder> getFailedVersions() {
            return failedVersions != null ? CollectionUtils.mapValues(failedVersions, PackageVersionError::toBuilder) : null;
        }

        @Override
        public final Builder failedVersions(Map<String, PackageVersionError> failedVersions) {
            this.failedVersions = PackageVersionErrorMapCopier.copy(failedVersions);
            return this;
        }

        public final void setFailedVersions(Map<String, PackageVersionError.BuilderImpl> failedVersions) {
            this.failedVersions = PackageVersionErrorMapCopier.copyFromBuilder(failedVersions);
        }

        @Override
        public DeletePackageVersionsResponse build() {
            return new DeletePackageVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
