/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a repository, including its Amazon Resource Name (ARN), description, and domain information. The <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListRepositories.html">ListRepositories</a>
 * operation returns a list of <code>RepositorySummary</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositorySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositorySummary.Builder, RepositorySummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RepositorySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ADMINISTRATOR_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("administratorAccount").getter(getter(RepositorySummary::administratorAccount))
            .setter(setter(Builder::administratorAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("administratorAccount").build())
            .build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(RepositorySummary::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(RepositorySummary::domainOwner)).setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainOwner").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RepositorySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RepositorySummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ADMINISTRATOR_ACCOUNT_FIELD, DOMAIN_NAME_FIELD, DOMAIN_OWNER_FIELD, ARN_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String administratorAccount;

    private final String domainName;

    private final String domainOwner;

    private final String arn;

    private final String description;

    private RepositorySummary(BuilderImpl builder) {
        this.name = builder.name;
        this.administratorAccount = builder.administratorAccount;
        this.domainName = builder.domainName;
        this.domainOwner = builder.domainOwner;
        this.arn = builder.arn;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The AWS account ID that manages the repository.
     * </p>
     * 
     * @return The AWS account ID that manages the repository.
     */
    public final String administratorAccount() {
        return administratorAccount;
    }

    /**
     * <p>
     * The name of the domain that contains the repository.
     * </p>
     * 
     * @return The name of the domain that contains the repository.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The ARN of the repository.
     * </p>
     * 
     * @return The ARN of the repository.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the repository.
     * </p>
     * 
     * @return The description of the repository.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(administratorAccount());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositorySummary)) {
            return false;
        }
        RepositorySummary other = (RepositorySummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(administratorAccount(), other.administratorAccount())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositorySummary").add("Name", name()).add("AdministratorAccount", administratorAccount())
                .add("DomainName", domainName()).add("DomainOwner", domainOwner()).add("Arn", arn())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "administratorAccount":
            return Optional.ofNullable(clazz.cast(administratorAccount()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositorySummary, T> g) {
        return obj -> g.apply((RepositorySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositorySummary> {
        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param name
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The AWS account ID that manages the repository.
         * </p>
         * 
         * @param administratorAccount
         *        The AWS account ID that manages the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administratorAccount(String administratorAccount);

        /**
         * <p>
         * The name of the domain that contains the repository.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that contains the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The ARN of the repository.
         * </p>
         * 
         * @param arn
         *        The ARN of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the repository.
         * </p>
         * 
         * @param description
         *        The description of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String administratorAccount;

        private String domainName;

        private String domainOwner;

        private String arn;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositorySummary model) {
            name(model.name);
            administratorAccount(model.administratorAccount);
            domainName(model.domainName);
            domainOwner(model.domainOwner);
            arn(model.arn);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAdministratorAccount() {
            return administratorAccount;
        }

        @Override
        public final Builder administratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
            return this;
        }

        public final void setAdministratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public RepositorySummary build() {
            return new RepositorySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
