/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRepositoryRequest extends CodeartifactRequest implements
        ToCopyableBuilder<UpdateRepositoryRequest.Builder, UpdateRepositoryRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(UpdateRepositoryRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(UpdateRepositoryRequest::domainOwner)).setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(UpdateRepositoryRequest::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateRepositoryRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<UpstreamRepository>> UPSTREAMS_FIELD = SdkField
            .<List<UpstreamRepository>> builder(MarshallingType.LIST)
            .memberName("upstreams")
            .getter(getter(UpdateRepositoryRequest::upstreams))
            .setter(setter(Builder::upstreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpstreamRepository> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpstreamRepository::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, DESCRIPTION_FIELD, UPSTREAMS_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String description;

    private final List<UpstreamRepository> upstreams;

    private UpdateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.description = builder.description;
        this.upstreams = builder.upstreams;
    }

    /**
     * <p>
     * The name of the domain associated with the repository to update.
     * </p>
     * 
     * @return The name of the domain associated with the repository to update.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The name of the repository to update.
     * </p>
     * 
     * @return The name of the repository to update.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * An updated repository description.
     * </p>
     * 
     * @return An updated repository description.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Upstreams property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUpstreams() {
        return upstreams != null && !(upstreams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of upstream repositories to associate with the repository. The order of the upstream repositories in the
     * list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
     * information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
     * upstream repositories</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpstreams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of upstream repositories to associate with the repository. The order of the upstream repositories
     *         in the list determines their priority order when AWS CodeArtifact looks for a requested package version.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
     *         repositories</a>.
     */
    public final List<UpstreamRepository> upstreams() {
        return upstreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpstreams() ? upstreams() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryRequest)) {
            return false;
        }
        UpdateRepositoryRequest other = (UpdateRepositoryRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository()) && Objects.equals(description(), other.description())
                && hasUpstreams() == other.hasUpstreams() && Objects.equals(upstreams(), other.upstreams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRepositoryRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("Repository", repository()).add("Description", description())
                .add("Upstreams", hasUpstreams() ? upstreams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "upstreams":
            return Optional.ofNullable(clazz.cast(upstreams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryRequest, T> g) {
        return obj -> g.apply((UpdateRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRepositoryRequest> {
        /**
         * <p>
         * The name of the domain associated with the repository to update.
         * </p>
         * 
         * @param domain
         *        The name of the domain associated with the repository to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The name of the repository to update.
         * </p>
         * 
         * @param repository
         *        The name of the repository to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * An updated repository description.
         * </p>
         * 
         * @param description
         *        An updated repository description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when AWS CodeArtifact looks for a requested package version. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         * repositories</a>.
         * </p>
         * 
         * @param upstreams
         *        A list of upstream repositories to associate with the repository. The order of the upstream
         *        repositories in the list determines their priority order when AWS CodeArtifact looks for a requested
         *        package version. For more information, see <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         *        repositories</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreams(Collection<UpstreamRepository> upstreams);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when AWS CodeArtifact looks for a requested package version. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         * repositories</a>.
         * </p>
         * 
         * @param upstreams
         *        A list of upstream repositories to associate with the repository. The order of the upstream
         *        repositories in the list determines their priority order when AWS CodeArtifact looks for a requested
         *        package version. For more information, see <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         *        repositories</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreams(UpstreamRepository... upstreams);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when AWS CodeArtifact looks for a requested package version. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         * repositories</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpstreamRepository>.Builder} avoiding the
         * need to create one manually via {@link List<UpstreamRepository>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpstreamRepository>.Builder#build()} is called immediately
         * and its result is passed to {@link #upstreams(List<UpstreamRepository>)}.
         * 
         * @param upstreams
         *        a consumer that will call methods on {@link List<UpstreamRepository>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upstreams(List<UpstreamRepository>)
         */
        Builder upstreams(Consumer<UpstreamRepository.Builder>... upstreams);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String description;

        private List<UpstreamRepository> upstreams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            description(model.description);
            upstreams(model.upstreams);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<UpstreamRepository.Builder> getUpstreams() {
            List<UpstreamRepository.Builder> result = UpstreamRepositoryListCopier.copyToBuilder(this.upstreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder upstreams(Collection<UpstreamRepository> upstreams) {
            this.upstreams = UpstreamRepositoryListCopier.copy(upstreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(UpstreamRepository... upstreams) {
            upstreams(Arrays.asList(upstreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(Consumer<UpstreamRepository.Builder>... upstreams) {
            upstreams(Stream.of(upstreams).map(c -> UpstreamRepository.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUpstreams(Collection<UpstreamRepository.BuilderImpl> upstreams) {
            this.upstreams = UpstreamRepositoryListCopier.copyFromBuilder(upstreams);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRepositoryRequest build() {
            return new UpdateRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
