/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositoriesResponse extends CodeartifactResponse implements
        ToCopyableBuilder<ListRepositoriesResponse.Builder, ListRepositoriesResponse> {
    private static final SdkField<List<RepositorySummary>> REPOSITORIES_FIELD = SdkField
            .<List<RepositorySummary>> builder(MarshallingType.LIST)
            .memberName("repositories")
            .getter(getter(ListRepositoriesResponse::repositories))
            .setter(setter(Builder::repositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositorySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositorySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRepositoriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RepositorySummary> repositories;

    private final String nextToken;

    private ListRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.repositories = builder.repositories;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Repositories property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRepositories() {
        return repositories != null && !(repositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">
     * <code>RepositorySummary</code> </a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRepositories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The returned list of <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">
     *         <code>RepositorySummary</code> </a> objects.
     */
    public final List<RepositorySummary> repositories() {
        return repositories;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositories() ? repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesResponse)) {
            return false;
        }
        ListRepositoriesResponse other = (ListRepositoriesResponse) obj;
        return hasRepositories() == other.hasRepositories() && Objects.equals(repositories(), other.repositories())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRepositoriesResponse").add("Repositories", hasRepositories() ? repositories() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositories":
            return Optional.ofNullable(clazz.cast(repositories()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoriesResponse, T> g) {
        return obj -> g.apply((ListRepositoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRepositoriesResponse> {
        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">
         * <code>RepositorySummary</code> </a> objects.
         * </p>
         * 
         * @param repositories
         *        The returned list of <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">
         *        <code>RepositorySummary</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(Collection<RepositorySummary> repositories);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">
         * <code>RepositorySummary</code> </a> objects.
         * </p>
         * 
         * @param repositories
         *        The returned list of <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">
         *        <code>RepositorySummary</code> </a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(RepositorySummary... repositories);

        /**
         * <p>
         * The returned list of <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">
         * <code>RepositorySummary</code> </a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RepositorySummary>.Builder} avoiding the
         * need to create one manually via {@link List<RepositorySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositorySummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #repositories(List<RepositorySummary>)}.
         * 
         * @param repositories
         *        a consumer that will call methods on {@link List<RepositorySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositories(List<RepositorySummary>)
         */
        Builder repositories(Consumer<RepositorySummary.Builder>... repositories);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private List<RepositorySummary> repositories = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoriesResponse model) {
            super(model);
            repositories(model.repositories);
            nextToken(model.nextToken);
        }

        public final List<RepositorySummary.Builder> getRepositories() {
            List<RepositorySummary.Builder> result = RepositorySummaryListCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder repositories(Collection<RepositorySummary> repositories) {
            this.repositories = RepositorySummaryListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(RepositorySummary... repositories) {
            repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<RepositorySummary.Builder>... repositories) {
            repositories(Stream.of(repositories).map(c -> RepositorySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRepositories(Collection<RepositorySummary.BuilderImpl> repositories) {
            this.repositories = RepositorySummaryListCopier.copyFromBuilder(repositories);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRepositoriesResponse build() {
            return new ListRepositoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
