/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An AWS CodeArtifact resource policy that contains a resource ARN, document details, and a revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePolicy implements SdkPojo, Serializable, ToCopyableBuilder<ResourcePolicy.Builder, ResourcePolicy> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(ResourcePolicy::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(ResourcePolicy::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("document").getter(getter(ResourcePolicy::document)).setter(setter(Builder::document))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            REVISION_FIELD, DOCUMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String revision;

    private final String document;

    private ResourcePolicy(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.revision = builder.revision;
        this.document = builder.document;
    }

    /**
     * <p>
     * The ARN of the resource associated with the resource policy
     * </p>
     * 
     * @return The ARN of the resource associated with the resource policy
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The current revision of the resource policy.
     * </p>
     * 
     * @return The current revision of the resource policy.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The resource policy formatted in JSON.
     * </p>
     * 
     * @return The resource policy formatted in JSON.
     */
    public final String document() {
        return document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePolicy)) {
            return false;
        }
        ResourcePolicy other = (ResourcePolicy) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(revision(), other.revision())
                && Objects.equals(document(), other.document());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcePolicy").add("ResourceArn", resourceArn()).add("Revision", revision())
                .add("Document", document()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePolicy, T> g) {
        return obj -> g.apply((ResourcePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePolicy> {
        /**
         * <p>
         * The ARN of the resource associated with the resource policy
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource associated with the resource policy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The current revision of the resource policy.
         * </p>
         * 
         * @param revision
         *        The current revision of the resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The resource policy formatted in JSON.
         * </p>
         * 
         * @param document
         *        The resource policy formatted in JSON.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String revision;

        private String document;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePolicy model) {
            resourceArn(model.resourceArn);
            revision(model.revision);
            document(model.document);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        public final String getDocument() {
            return document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public ResourcePolicy build() {
            return new ResourcePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
