/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class SuccessfulPackageVersionInfoMapCopier {
    static Map<String, SuccessfulPackageVersionInfo> copy(
            Map<String, ? extends SuccessfulPackageVersionInfo> successfulPackageVersionInfoMapParam) {
        Map<String, SuccessfulPackageVersionInfo> map;
        if (successfulPackageVersionInfoMapParam == null || successfulPackageVersionInfoMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, SuccessfulPackageVersionInfo> modifiableMap = new LinkedHashMap<>();
            successfulPackageVersionInfoMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, SuccessfulPackageVersionInfo> copyFromBuilder(
            Map<String, ? extends SuccessfulPackageVersionInfo.Builder> successfulPackageVersionInfoMapParam) {
        Map<String, SuccessfulPackageVersionInfo> map;
        if (successfulPackageVersionInfoMapParam == null || successfulPackageVersionInfoMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, SuccessfulPackageVersionInfo> modifiableMap = new LinkedHashMap<>();
            successfulPackageVersionInfoMapParam.forEach((key, value) -> {
                SuccessfulPackageVersionInfo member = value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, SuccessfulPackageVersionInfo.Builder> copyToBuilder(
            Map<String, ? extends SuccessfulPackageVersionInfo> successfulPackageVersionInfoMapParam) {
        Map<String, SuccessfulPackageVersionInfo.Builder> map;
        if (successfulPackageVersionInfoMapParam == null || successfulPackageVersionInfoMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, SuccessfulPackageVersionInfo.Builder> modifiableMap = new LinkedHashMap<>();
            successfulPackageVersionInfoMapParam.forEach((key, value) -> {
                SuccessfulPackageVersionInfo.Builder member = value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
