/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePackageVersionResponse extends CodeartifactResponse implements
        ToCopyableBuilder<DescribePackageVersionResponse.Builder, DescribePackageVersionResponse> {
    private static final SdkField<PackageVersionDescription> PACKAGE_VERSION_FIELD = SdkField
            .<PackageVersionDescription> builder(MarshallingType.SDK_POJO).memberName("packageVersion")
            .getter(getter(DescribePackageVersionResponse::packageVersion)).setter(setter(Builder::packageVersion))
            .constructor(PackageVersionDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_FIELD));

    private final PackageVersionDescription packageVersion;

    private DescribePackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.packageVersion = builder.packageVersion;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">
     * PackageVersionDescription</a> object that contains information about the requested package version.
     * </p>
     * 
     * @return A <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
     *         >PackageVersionDescription</a> object that contains information about the requested package version.
     */
    public final PackageVersionDescription packageVersion() {
        return packageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageVersionResponse)) {
            return false;
        }
        DescribePackageVersionResponse other = (DescribePackageVersionResponse) obj;
        return Objects.equals(packageVersion(), other.packageVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePackageVersionResponse").add("PackageVersion", packageVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageVersionResponse, T> g) {
        return obj -> g.apply((DescribePackageVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePackageVersionResponse> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">
         * PackageVersionDescription</a> object that contains information about the requested package version.
         * </p>
         * 
         * @param packageVersion
         *        A <a href=
         *        "https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
         *        >PackageVersionDescription</a> object that contains information about the requested package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(PackageVersionDescription packageVersion);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">
         * PackageVersionDescription</a> object that contains information about the requested package version.
         * </p>
         * This is a convenience that creates an instance of the {@link PackageVersionDescription.Builder} avoiding the
         * need to create one manually via {@link PackageVersionDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageVersionDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #packageVersion(PackageVersionDescription)}.
         * 
         * @param packageVersion
         *        a consumer that will call methods on {@link PackageVersionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageVersion(PackageVersionDescription)
         */
        default Builder packageVersion(Consumer<PackageVersionDescription.Builder> packageVersion) {
            return packageVersion(PackageVersionDescription.builder().applyMutation(packageVersion).build());
        }
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private PackageVersionDescription packageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageVersionResponse model) {
            super(model);
            packageVersion(model.packageVersion);
        }

        public final PackageVersionDescription.Builder getPackageVersion() {
            return packageVersion != null ? packageVersion.toBuilder() : null;
        }

        @Override
        public final Builder packageVersion(PackageVersionDescription packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final void setPackageVersion(PackageVersionDescription.BuilderImpl packageVersion) {
            this.packageVersion = packageVersion != null ? packageVersion.build() : null;
        }

        @Override
        public DescribePackageVersionResponse build() {
            return new DescribePackageVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
