/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a domain, including its name, Amazon Resource Name (ARN), and status. The <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListDomains.html">ListDomains</a> operation
 * returns a list of <code>DomainSummary</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSummary implements SdkPojo, Serializable, ToCopyableBuilder<DomainSummary.Builder, DomainSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DomainSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(DomainSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DomainSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DomainSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(DomainSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKey").getter(getter(DomainSummary::encryptionKey)).setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OWNER_FIELD,
            ARN_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, ENCRYPTION_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String owner;

    private final String arn;

    private final String status;

    private final Instant createdTime;

    private final String encryptionKey;

    private DomainSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.owner = builder.owner;
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.encryptionKey = builder.encryptionKey;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The ARN of the domain.
     * </p>
     * 
     * @return The ARN of the domain.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A string that contains the status of the domain. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleted</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A string that contains the status of the domain. The valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleted</code>
     *         </p>
     *         </li>
     * @see DomainStatus
     */
    public final DomainStatus status() {
        return DomainStatus.fromValue(status);
    }

    /**
     * <p>
     * A string that contains the status of the domain. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleted</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A string that contains the status of the domain. The valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleted</code>
     *         </p>
     *         </li>
     * @see DomainStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp that contains the date and time the domain was created.
     * </p>
     * 
     * @return A timestamp that contains the date and time the domain was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The key used to encrypt the domain.
     * </p>
     * 
     * @return The key used to encrypt the domain.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(owner(), other.owner())
                && Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(encryptionKey(), other.encryptionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainSummary").add("Name", name()).add("Owner", owner()).add("Arn", arn())
                .add("Status", statusAsString()).add("CreatedTime", createdTime()).add("EncryptionKey", encryptionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSummary, T> g) {
        return obj -> g.apply((DomainSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSummary> {
        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param name
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param owner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The ARN of the domain.
         * </p>
         * 
         * @param arn
         *        The ARN of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A string that contains the status of the domain. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleted</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A string that contains the status of the domain. The valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleted</code>
         *        </p>
         *        </li>
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A string that contains the status of the domain. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleted</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A string that contains the status of the domain. The valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleted</code>
         *        </p>
         *        </li>
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(DomainStatus status);

        /**
         * <p>
         * A timestamp that contains the date and time the domain was created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that contains the date and time the domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The key used to encrypt the domain.
         * </p>
         * 
         * @param encryptionKey
         *        The key used to encrypt the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String owner;

        private String arn;

        private String status;

        private Instant createdTime;

        private String encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            name(model.name);
            owner(model.owner);
            arn(model.arn);
            status(model.status);
            createdTime(model.createdTime);
            encryptionKey(model.encryptionKey);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @Override
        public DomainSummary build() {
            return new DomainSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
